/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.ui.wizards;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.runtime.callback.Callback;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.runtime.persistence.interfaces.IURIPersistenceService;
import org.eclipse.tcf.te.runtime.properties.PropertiesContainer;
import org.eclipse.tcf.te.runtime.services.ServiceManager;
import org.eclipse.tcf.te.tcf.core.peers.Peer;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.ILocatorModelLookupService;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.ILocatorModelRefreshService;
import org.eclipse.tcf.te.tcf.locator.model.Model;
import org.eclipse.tcf.te.tcf.ui.nls.Messages;
import org.eclipse.tcf.te.tcf.ui.wizards.pages.NewTargetWizardPage;
import org.eclipse.tcf.te.ui.interfaces.data.IDataExchangeNode;
import org.eclipse.tcf.te.ui.swt.DisplayUtil;
import org.eclipse.tcf.te.ui.views.ViewsUtil;
import org.eclipse.tcf.te.ui.wizards.AbstractWizard;
import org.eclipse.tcf.te.ui.wizards.pages.AbstractWizardPage;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class NewTargetWizard
extends AbstractWizard
implements INewWizard {
    private static final AtomicInteger counter = new AtomicInteger();

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        super.init(workbench, selection);
        this.setWindowTitle(Messages.NewTargetWizard_windowTitle);
    }

    public void addPages() {
        this.addPage((IWizardPage)new NewTargetWizardPage());
    }

    protected void extractData(IPropertiesContainer peerAttributes) {
        Assert.isNotNull((Object)peerAttributes);
        IWizardPage[] iWizardPageArray = this.getPages();
        int n = iWizardPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardPage page = iWizardPageArray[n2];
            if (page instanceof AbstractWizardPage) {
                ((AbstractWizardPage)page).saveWidgetValues();
            }
            if (page instanceof IDataExchangeNode) {
                ((IDataExchangeNode)page).extractData(peerAttributes);
            }
            ++n2;
        }
    }

    public boolean performFinish() {
        PropertiesContainer peerAttributes = new PropertiesContainer();
        this.extractData((IPropertiesContainer)peerAttributes);
        if (!peerAttributes.containsKey("ID")) {
            peerAttributes.setProperty("ID", (Object)UUID.randomUUID().toString());
        }
        if (!peerAttributes.containsKey("Name")) {
            peerAttributes.setProperty("Name", (Object)NLS.bind((String)Messages.NewTargetWizard_newPeer_name, (Object)counter.incrementAndGet()));
        }
        final HashMap<String, String> attrs = new HashMap<String, String>();
        for (Map.Entry entry : peerAttributes.getProperties().entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            attrs.put((String)entry.getKey(), entry.getValue() instanceof String ? (String)entry.getValue() : entry.getValue().toString());
        }
        try {
            IURIPersistenceService persistenceService = (IURIPersistenceService)ServiceManager.getInstance().getService(IURIPersistenceService.class);
            if (persistenceService == null) {
                throw new IOException("Persistence service instance unavailable.");
            }
            persistenceService.write((Object)new Peer(attrs), null);
            Protocol.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    ILocatorModelRefreshService service = (ILocatorModelRefreshService)Model.getModel().getService(ILocatorModelRefreshService.class);
                    if (service != null) {
                        service.refresh((ICallback)new Callback(){

                            protected void internalDone(Object caller, IStatus status) {
                                final IPeerModel peerNode = ((ILocatorModelLookupService)Model.getModel().getService(ILocatorModelLookupService.class)).lkupPeerModelById((String)attrs.get("ID"));
                                if (peerNode != null) {
                                    ViewsUtil.refresh((String)"org.eclipse.tcf.te.ui.views.View");
                                    StructuredSelection selection = new StructuredSelection((Object)peerNode);
                                    ViewsUtil.setSelection((String)"org.eclipse.tcf.te.ui.views.View", (ISelection)selection);
                                    if (NewTargetWizard.this.isOpenEditorOnPerformFinish()) {
                                        ViewsUtil.openEditor((ISelection)selection);
                                    }
                                    DisplayUtil.safeAsyncExec((Runnable)new Runnable(){

                                        @Override
                                        public void run() {
                                            NewTargetWizard.this.postPerformFinish(peerNode);
                                        }
                                    });
                                }
                            }
                        });
                    }
                }
            });
        }
        catch (IOException e) {
            if (this.getContainer().getCurrentPage() instanceof WizardPage) {
                String message = NLS.bind((String)Messages.NewTargetWizard_error_savePeer, (Object)e.getLocalizedMessage());
                ((WizardPage)this.getContainer().getCurrentPage()).setMessage(message, 3);
                this.getContainer().updateMessage();
            }
            return false;
        }
        return true;
    }

    protected boolean isOpenEditorOnPerformFinish() {
        return true;
    }

    protected void postPerformFinish(IPeerModel peerModel) {
    }
}

