/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.terminals.internal.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.runtime.properties.PropertiesContainer;
import org.eclipse.tcf.te.ui.controls.BaseDialogPageControl;
import org.eclipse.tcf.te.ui.controls.BaseWizardConfigurationPanelControl;
import org.eclipse.tcf.te.ui.controls.interfaces.IWizardConfigurationPanel;
import org.eclipse.tcf.te.ui.interfaces.data.IDataExchangeNode;
import org.eclipse.tcf.te.ui.jface.dialogs.CustomTrayDialog;
import org.eclipse.tcf.te.ui.jface.interfaces.IValidatingContainer;
import org.eclipse.tcf.te.ui.swt.SWTControlUtil;
import org.eclipse.tcf.te.ui.terminals.activator.UIPlugin;
import org.eclipse.tcf.te.ui.terminals.help.IContextHelpIds;
import org.eclipse.tcf.te.ui.terminals.interfaces.IConfigurationPanel;
import org.eclipse.tcf.te.ui.terminals.interfaces.ILauncherDelegate;
import org.eclipse.tcf.te.ui.terminals.launcher.LauncherDelegateManager;
import org.eclipse.tcf.te.ui.terminals.nls.Messages;
import org.eclipse.tcf.te.ui.terminals.panels.AbstractConfigurationPanel;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class LaunchTerminalSettingsDialog
extends CustomTrayDialog
implements IValidatingContainer {
    private ISelection selection = null;
    Combo terminals;
    SettingsPanelControl settings;
    private FormToolkit toolkit = null;
    final Map<String, ILauncherDelegate> label2delegate = new HashMap<String, ILauncherDelegate>();
    private IPropertiesContainer data = null;
    private long start = 0L;

    public LaunchTerminalSettingsDialog(Shell shell) {
        super(shell, IContextHelpIds.LAUNCH_TERMINAL_SETTINGS_DIALOG);
    }

    public LaunchTerminalSettingsDialog(Shell shell, long start) {
        super(shell, IContextHelpIds.LAUNCH_TERMINAL_SETTINGS_DIALOG);
        this.start = start;
    }

    public void setSelection(ISelection selection) {
        this.selection = selection;
    }

    public ISelection getSelection() {
        return this.selection;
    }

    protected void dispose() {
        if (this.settings != null) {
            this.settings.dispose();
            this.settings = null;
        }
        if (this.toolkit != null) {
            this.toolkit.dispose();
            this.toolkit = null;
        }
        super.dispose();
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createContents(Composite parent) {
        Control composite = super.createContents(parent);
        this.validate();
        return composite;
    }

    protected void createDialogAreaContent(Composite parent) {
        super.createDialogAreaContent(parent);
        if (UIPlugin.getTraceHandler().isSlotEnabled(0, "trace/launchTerminalCommandHandler")) {
            UIPlugin.getTraceHandler().trace("Creating dialog area after " + (System.currentTimeMillis() - this.start) + " ms.", "trace/launchTerminalCommandHandler", (Object)this);
        }
        this.setDialogTitle(Messages.LaunchTerminalSettingsDialog_title);
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        panel.setLayout((Layout)layout);
        panel.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        Label label = new Label(panel, 256);
        label.setText(Messages.LaunchTerminalSettingsDialog_combo_label);
        this.terminals = new Combo(panel, 8);
        this.terminals.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.terminals.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IWizardConfigurationPanel oldPanel = LaunchTerminalSettingsDialog.this.settings.getActiveConfigurationPanel();
                PropertiesContainer data = new PropertiesContainer();
                if (oldPanel instanceof IDataExchangeNode) {
                    ((IDataExchangeNode)oldPanel).extractData((IPropertiesContainer)data);
                }
                data.setProperty("ip.port", null);
                data.setProperty("timeout", null);
                data.setProperty("tm.terminal.connector.id", null);
                data.setProperty("connector.type.id", null);
                LaunchTerminalSettingsDialog.this.settings.showConfigurationPanel(LaunchTerminalSettingsDialog.this.terminals.getText());
                IWizardConfigurationPanel newPanel = LaunchTerminalSettingsDialog.this.settings.getActiveConfigurationPanel();
                if (newPanel instanceof IDataExchangeNode) {
                    ((IDataExchangeNode)newPanel).setupData((IPropertiesContainer)data);
                }
            }
        });
        this.fillCombo(this.terminals);
        this.settings = new SettingsPanelControl(null);
        String terminalLabel = SWTControlUtil.getItem((Control)this.terminals, (int)0);
        if (terminalLabel != null) {
            ILauncherDelegate delegate = this.label2delegate.get(terminalLabel);
            Assert.isNotNull((Object)delegate);
            IConfigurationPanel configPanel = delegate.getPanel((BaseDialogPageControl)this.settings);
            if (configPanel == null) {
                configPanel = new EmptySettingsPanel((BaseDialogPageControl)this.settings);
            }
            Assert.isNotNull((Object)configPanel);
            configPanel.setSelection(this.getSelection());
            this.settings.addConfigurationPanel(terminalLabel, configPanel);
        }
        this.toolkit = new FormToolkit(panel.getDisplay());
        this.settings.setupPanel(panel, this.terminals.getItems(), this.toolkit);
        GridData layoutData = new GridData(4, 4, true, true);
        layoutData.horizontalSpan = 2;
        this.settings.getPanel().setLayoutData((Object)layoutData);
        this.terminals.select(0);
        this.settings.showConfigurationPanel(this.terminals.getText());
        SWTControlUtil.setEnabled((Control)this.terminals, (this.terminals.getItemCount() > 1 ? 1 : 0) != 0);
        this.restoreWidgetValues();
        LaunchTerminalSettingsDialog.applyDialogFont((Control)panel);
        if (UIPlugin.getTraceHandler().isSlotEnabled(0, "trace/launchTerminalCommandHandler")) {
            UIPlugin.getTraceHandler().trace("Created dialog area after " + (System.currentTimeMillis() - this.start) + " ms.", "trace/launchTerminalCommandHandler", (Object)this);
        }
    }

    protected void fillCombo(Combo combo) {
        Assert.isNotNull((Object)combo);
        if (UIPlugin.getTraceHandler().isSlotEnabled(0, "trace/launchTerminalCommandHandler")) {
            UIPlugin.getTraceHandler().trace("Filling combo after " + (System.currentTimeMillis() - this.start) + " ms.", "trace/launchTerminalCommandHandler", (Object)this);
        }
        ArrayList<String> items = new ArrayList<String>();
        if (this.selection == null || this.selection.isEmpty()) {
            if (UIPlugin.getTraceHandler().isSlotEnabled(0, "trace/launchTerminalCommandHandler")) {
                UIPlugin.getTraceHandler().trace("Getting launcher delegates after " + (System.currentTimeMillis() - this.start) + " ms.", "trace/launchTerminalCommandHandler", (Object)this);
            }
            ILauncherDelegate[] delegates = LauncherDelegateManager.getInstance().getLauncherDelegates(true);
            if (UIPlugin.getTraceHandler().isSlotEnabled(0, "trace/launchTerminalCommandHandler")) {
                UIPlugin.getTraceHandler().trace("Got launcher delegates after " + (System.currentTimeMillis() - this.start) + " ms.", "trace/launchTerminalCommandHandler", (Object)this);
            }
            ILauncherDelegate[] iLauncherDelegateArray = delegates;
            int n = delegates.length;
            int n2 = 0;
            while (n2 < n) {
                ILauncherDelegate delegate = iLauncherDelegateArray[n2];
                String label = delegate.getLabel();
                String id = delegate.getId();
                if (!id.equals("org.eclipse.tcf.te.ui.terminals.launcher.tcf")) {
                    if (label == null || "".equals(label.trim())) {
                        label = delegate.getId();
                    }
                    this.label2delegate.put(label, delegate);
                    items.add(label);
                }
                ++n2;
            }
        } else {
            if (UIPlugin.getTraceHandler().isSlotEnabled(0, "trace/launchTerminalCommandHandler")) {
                UIPlugin.getTraceHandler().trace("Getting applicable launcher delegates after " + (System.currentTimeMillis() - this.start) + " ms.", "trace/launchTerminalCommandHandler", (Object)this);
            }
            ILauncherDelegate[] delegates = LauncherDelegateManager.getInstance().getApplicableLauncherDelegates(this.selection);
            if (UIPlugin.getTraceHandler().isSlotEnabled(0, "trace/launchTerminalCommandHandler")) {
                UIPlugin.getTraceHandler().trace("Got applicable launcher delegates after " + (System.currentTimeMillis() - this.start) + " ms.", "trace/launchTerminalCommandHandler", (Object)this);
            }
            ILauncherDelegate[] iLauncherDelegateArray = delegates;
            int n = delegates.length;
            int n3 = 0;
            while (n3 < n) {
                ILauncherDelegate delegate = iLauncherDelegateArray[n3];
                String label = delegate.getLabel();
                if (label == null || "".equals(label.trim())) {
                    label = delegate.getId();
                }
                this.label2delegate.put(label, delegate);
                items.add(label);
                ++n3;
            }
        }
        Collections.sort(items);
        combo.setItems(items.toArray(new String[items.size()]));
    }

    public void validate() {
        IWizardConfigurationPanel panel = this.settings.getActiveConfigurationPanel();
        Button okButton = this.getButton(0);
        SWTControlUtil.setEnabled((Control)okButton, (boolean)panel.isValid());
    }

    public void setMessage(String message, int messageType) {
        if (this.settings != null) {
            this.settings.setMessage(message, messageType);
        }
    }

    protected void saveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            settings.put("terminalLabel", SWTControlUtil.getText((Control)this.terminals));
            this.settings.saveWidgetValues(settings, null);
        }
    }

    protected void restoreWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            int index;
            String terminalLabel = settings.get("terminalLabel");
            int n = index = terminalLabel != null ? Arrays.asList(this.terminals.getItems()).indexOf(terminalLabel) : -1;
            if (index != -1) {
                this.terminals.select(index);
                this.settings.showConfigurationPanel(this.terminals.getText());
            }
            this.settings.restoreWidgetValues(settings, null);
        }
    }

    protected void okPressed() {
        IWizardConfigurationPanel panel = this.settings.getActiveConfigurationPanel();
        if (!panel.isValid()) {
            MessageBox mb = new MessageBox(this.getShell(), 33);
            mb.setText(Messages.LaunchTerminalSettingsDialog_error_title);
            mb.setMessage(NLS.bind((String)Messages.LaunchTerminalSettingsDialog_error_invalidSettings, (Object)(panel.getMessage() != null ? panel.getMessage() : Messages.LaunchTerminalSettingsDialog_error_unknownReason)));
            mb.open();
            return;
        }
        this.data = new PropertiesContainer();
        this.data.setProperty("delegateId", (Object)this.label2delegate.get(this.terminals.getText()).getId());
        this.data.setProperty("selection", (Object)this.selection);
        if (panel instanceof IDataExchangeNode) {
            ((IDataExchangeNode)panel).extractData(this.data);
        }
        super.okPressed();
    }

    public IPropertiesContainer getSettings() {
        return this.data;
    }

    protected class EmptySettingsPanel
    extends AbstractConfigurationPanel {
        public EmptySettingsPanel(BaseDialogPageControl parentControl) {
            super(parentControl);
        }

        public void setupPanel(Composite parent, FormToolkit toolkit) {
            Composite panel = new Composite(parent, 0);
            panel.setLayout((Layout)new GridLayout());
            panel.setLayoutData((Object)new GridData(4, 4, true, true));
            Label label = new Label(panel, 256);
            GridData layoutData = new GridData(4, 4, true, true);
            layoutData.widthHint = LaunchTerminalSettingsDialog.this.convertWidthInCharsToPixels(30);
            layoutData.heightHint = LaunchTerminalSettingsDialog.this.convertHeightInCharsToPixels(5);
            label.setLayoutData((Object)layoutData);
            this.setControl(panel);
        }

        public boolean dataChanged(IPropertiesContainer data, TypedEvent e) {
            return false;
        }

        @Override
        protected void saveSettingsForHost(boolean add) {
        }

        @Override
        protected void fillSettingsForHost(String host) {
        }

        @Override
        protected String getHostFromSettings() {
            return null;
        }

        @Override
        public void doRestoreWidgetValues(IDialogSettings settings, String idPrefix) {
        }

        @Override
        public void doSaveWidgetValues(IDialogSettings settings, String idPrefix) {
        }
    }

    protected class SettingsPanelControl
    extends BaseWizardConfigurationPanelControl
    implements IValidatingContainer {
        public SettingsPanelControl(IDialogPage parentPage) {
            super(parentPage);
            this.setPanelIsGroup(true);
        }

        public String getGroupLabel() {
            return Messages.LaunchTerminalSettingsDialog_group_label;
        }

        public void showConfigurationPanel(String key) {
            IWizardConfigurationPanel configPanel = this.getConfigurationPanel(key);
            if (configPanel == null) {
                ILauncherDelegate delegate = LaunchTerminalSettingsDialog.this.label2delegate.get(key);
                Assert.isNotNull((Object)delegate);
                configPanel = delegate.getPanel((BaseDialogPageControl)this);
                if (configPanel == null) {
                    configPanel = new EmptySettingsPanel((BaseDialogPageControl)this);
                }
                ((IConfigurationPanel)configPanel).setSelection(LaunchTerminalSettingsDialog.this.getSelection());
                this.addConfigurationPanel(key, configPanel);
                configPanel.setupPanel(this.getPanel(), this.getFormToolkit());
            }
            super.showConfigurationPanel(key);
            this.validate();
        }

        public void validate() {
            LaunchTerminalSettingsDialog.this.validate();
        }
    }
}

