/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.views.editor.pages;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.tcf.te.runtime.nls.Messages;
import org.eclipse.tcf.te.ui.jface.interfaces.IValidatingContainer;
import org.eclipse.tcf.te.ui.views.activator.UIPlugin;
import org.eclipse.tcf.te.ui.views.interfaces.IEditorPage;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.part.MultiPageSelectionProvider;

public abstract class AbstractEditorPage
extends FormPage
implements IEditorPage,
IValidatingContainer {
    private String id;
    private Composite messageComp = null;
    private Label message = null;
    private Label messageType = null;

    public AbstractEditorPage() {
        super("", "");
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) {
        super.setInitializationData(config, propertyName, data);
        if (config != null) {
            this.id = config.getAttribute("id");
            if (this.id == null || this.id.trim().length() == 0) {
                Status status = new Status(4, UIPlugin.getUniqueIdentifier(), NLS.bind((String)Messages.Extension_error_missingRequiredAttribute, (Object)"id", (Object)config.getContributor().getName()));
                UIPlugin.getDefault().getLog().log((IStatus)status);
            }
        }
    }

    public String getId() {
        return this.id;
    }

    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        Assert.isNotNull((Object)managedForm);
        managedForm.setInput(this.getEditorInputNode());
        this.messageComp = new Composite(managedForm.getForm().getForm().getHead(), 0);
        GridLayout gl = new GridLayout(2, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.marginLeft = 0;
        gl.marginRight = 0;
        this.messageComp.setLayout((Layout)gl);
        this.messageType = new Label(this.messageComp, 0);
        GridData gd = new GridData(20, 20);
        this.messageType.setLayoutData((Object)gd);
        this.message = new Label(this.messageComp, 0);
    }

    protected void setInput(IEditorInput input) {
        super.setInput(input);
        if (this.getManagedForm() != null) {
            this.getManagedForm().setInput(this.getEditorInputNode());
        }
        this.getSite().getSelectionProvider().setSelection((ISelection)(input != null ? new StructuredSelection(this.getEditorInputNode()) : null));
    }

    protected void setInputWithNotify(IEditorInput input) {
        super.setInputWithNotify(input);
        if (this.getManagedForm() != null) {
            this.getManagedForm().setInput(this.getEditorInputNode());
        }
        this.getSite().getSelectionProvider().setSelection((ISelection)(input != null ? new StructuredSelection(this.getEditorInputNode()) : null));
    }

    public void setActive(boolean active) {
        super.setActive(active);
        if (!active) {
            StructuredSelection selection = this.getEditorInput() != null ? new StructuredSelection(this.getEditorInputNode()) : null;
            this.getSite().getSelectionProvider().setSelection((ISelection)selection);
            if (this.getSite().getSelectionProvider() instanceof MultiPageSelectionProvider) {
                SelectionChangedEvent changedEvent = new SelectionChangedEvent(this.getSite().getSelectionProvider(), (ISelection)selection);
                ((MultiPageSelectionProvider)this.getSite().getSelectionProvider()).firePostSelectionChanged(changedEvent);
            }
        }
    }

    public Object getEditorInputNode() {
        IEditorInput input = this.getEditorInput();
        return input != null ? input.getAdapter(Object.class) : null;
    }

    public void preDoSave(IProgressMonitor monitor) {
    }

    public void postDoSave(IProgressMonitor monitor) {
    }

    public final void validate() {
        IValidatingContainer.ValidationResult result = this.doValidate();
        if (result != null) {
            this.setMessage(result.getMessage(), result.getMessageType());
        } else {
            this.setMessage(null, 0);
        }
    }

    protected Image getMessageImage(int messageType) {
        switch (messageType) {
            case 1: {
                return JFaceResources.getImage((String)"dialog_messasge_info_image");
            }
            case 2: {
                return JFaceResources.getImage((String)"dialog_messasge_warning_image");
            }
            case 3: {
                return JFaceResources.getImage((String)"dialog_message_error_image");
            }
        }
        return null;
    }

    public void setMessage(String text, int type) {
        if (this.getManagedForm() != null && this.messageComp != null && this.message != null && this.messageType != null) {
            ScrolledForm form = this.getManagedForm().getForm();
            if (text != null) {
                this.messageType.setImage(this.getMessageImage(type));
                this.message.setText(text);
                form.setHeadClient((Control)this.messageComp);
            } else {
                form.setHeadClient(null);
            }
        }
    }

    protected IValidatingContainer.ValidationResult doValidate() {
        return new IValidatingContainer.ValidationResult();
    }
}

