/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.extension.properties;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.team.svn.core.extension.properties.IPredefinedPropertySet;
import org.eclipse.team.svn.core.extension.properties.PredefinedProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PredefinedPropertySet
implements IPredefinedPropertySet {
    private Map<String, PredefinedProperty> properties = null;

    @Override
    public List<PredefinedProperty> getPredefinedProperties() {
        return new ArrayList<PredefinedProperty>(this.getPropertiesMap().values());
    }

    @Override
    public PredefinedProperty getPredefinedProperty(String name) {
        return this.getPropertiesMap().get(name);
    }

    @Override
    public Map<String, String> getPredefinedPropertiesRegexps() {
        HashMap<String, String> regexpmap = new HashMap<String, String>();
        for (PredefinedProperty property : this.getPredefinedProperties()) {
            regexpmap.put(property.name, property.validationRegexp);
        }
        return regexpmap;
    }

    public void registerProperties(List<PredefinedProperty> properties) {
        for (PredefinedProperty property : properties) {
            this.registerProperty(property);
        }
    }

    public void registerProperties(PredefinedProperty[] properties) {
        PredefinedProperty[] predefinedPropertyArray = properties;
        int n = properties.length;
        int n2 = 0;
        while (n2 < n) {
            PredefinedProperty property = predefinedPropertyArray[n2];
            this.registerProperty(property);
            ++n2;
        }
    }

    public void registerProperty(PredefinedProperty property) {
        this.getPropertiesMap().put(property.name, property);
    }

    protected synchronized Map<String, PredefinedProperty> getPropertiesMap() {
        if (this.properties == null) {
            this.properties = new LinkedHashMap<String, PredefinedProperty>();
            this.init();
        }
        return this.properties;
    }

    protected void init() {
    }
}

