/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.local;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.operation.IUnprotectedOperation;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.operation.local.AbstractWorkingCopyOperation;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IResourceProvider;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.FileUtility;

public class MarkResolvedOperation
extends AbstractWorkingCopyOperation {
    protected int conflictResult;
    protected int depth;

    public MarkResolvedOperation(IResource[] resources, int conflictResult, int depth) {
        super("Operation_MarkResolved", SVNMessages.class, resources);
        this.conflictResult = conflictResult;
        this.depth = depth;
    }

    public MarkResolvedOperation(IResourceProvider provider, int conflictResult, int depth) {
        super("Operation_MarkResolved", SVNMessages.class, provider);
        this.conflictResult = conflictResult;
        this.depth = depth;
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        IResource[] resources = this.operableData();
        int i = 0;
        while (i < resources.length && !monitor.isCanceled()) {
            IRepositoryLocation location = SVNRemoteStorage.instance().getRepositoryLocation(resources[i]);
            final String path = FileUtility.getWorkingCopyPath(resources[i]);
            final ISVNConnector proxy = location.acquireSVNProxy();
            this.protectStep(new IUnprotectedOperation(){

                public void run(IProgressMonitor monitor) throws Exception {
                    proxy.resolve(path, MarkResolvedOperation.this.conflictResult, MarkResolvedOperation.this.depth, new SVNProgressMonitor(MarkResolvedOperation.this, monitor, null));
                }
            }, monitor, resources.length);
            location.releaseSVNProxy(proxy);
            ++i;
        }
    }
}

