/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.ast;

import org.eclipse.wst.jsdt.core.ast.IJsDoc;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.wst.jsdt.internal.compiler.ast.ASTNode;
import org.eclipse.wst.jsdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.Argument;
import org.eclipse.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.wst.jsdt.internal.compiler.ast.JavadocAllocationExpression;
import org.eclipse.wst.jsdt.internal.compiler.ast.JavadocFieldReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.JavadocMessageSend;
import org.eclipse.wst.jsdt.internal.compiler.ast.JavadocQualifiedTypeReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.JavadocReturnStatement;
import org.eclipse.wst.jsdt.internal.compiler.ast.JavadocSingleNameReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.JavadocSingleTypeReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeReference;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ClassScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ImportBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Scope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;

public class Javadoc
extends ASTNode
implements IJsDoc {
    public JavadocSingleNameReference[] paramReferences;
    public TypeReference[] exceptionReferences;
    public JavadocReturnStatement returnStatement;
    public Expression[] seeReferences;
    public long inheritedPositions = -1L;
    public JavadocSingleNameReference[] invalidParameters;
    public long valuePositions = -1L;
    public int modifiers = 0;
    public TypeReference namespace = null;
    public TypeReference memberOf = null;
    public TypeReference returnType = null;
    public TypeReference extendsType = null;
    public TypeReference classDef = null;
    public TypeReference methodDef = null;
    public JavadocSingleNameReference property = null;
    public boolean isConstructor;

    public Javadoc(int sourceStart, int sourceEnd) {
        this.sourceStart = sourceStart;
        this.sourceEnd = sourceEnd;
    }

    boolean canBeSeen(int visibility, int modifiers) {
        if (modifiers < 0) {
            return true;
        }
        switch (modifiers & 7) {
            case 1: {
                return true;
            }
            case 4: {
                return visibility != 1;
            }
            case 0: {
                return visibility == 0 || visibility == 2;
            }
            case 2: {
                return visibility == 2;
            }
        }
        return true;
    }

    public ASTNode getNodeStartingAt(int start) {
        JavadocSingleNameReference param;
        int i;
        int length = 0;
        if (this.paramReferences != null) {
            length = this.paramReferences.length;
            i = 0;
            while (i < length) {
                param = this.paramReferences[i];
                if (param.sourceStart == start) {
                    return param;
                }
                ++i;
            }
        }
        if (this.invalidParameters != null) {
            length = this.invalidParameters.length;
            i = 0;
            while (i < length) {
                param = this.invalidParameters[i];
                if (param.sourceStart == start) {
                    return param;
                }
                ++i;
            }
        }
        if (this.exceptionReferences != null) {
            length = this.exceptionReferences.length;
            i = 0;
            while (i < length) {
                TypeReference typeRef = this.exceptionReferences[i];
                if (typeRef.sourceStart == start) {
                    return typeRef;
                }
                ++i;
            }
        }
        if (this.seeReferences != null) {
            length = this.seeReferences.length;
            i = 0;
            while (i < length) {
                int l;
                int j;
                Expression expression = this.seeReferences[i];
                if (expression.sourceStart == start) {
                    return expression;
                }
                if (expression instanceof JavadocAllocationExpression) {
                    JavadocAllocationExpression allocationExpr = (JavadocAllocationExpression)this.seeReferences[i];
                    if (allocationExpr.binding != null && allocationExpr.binding.isValidBinding() && allocationExpr.arguments != null) {
                        j = 0;
                        l = allocationExpr.arguments.length;
                        while (j < l) {
                            if (allocationExpr.arguments[j].sourceStart == start) {
                                return allocationExpr.arguments[j];
                            }
                            ++j;
                        }
                    }
                } else if (expression instanceof JavadocMessageSend) {
                    JavadocMessageSend messageSend = (JavadocMessageSend)this.seeReferences[i];
                    if (messageSend.binding != null && messageSend.binding.isValidBinding() && messageSend.arguments != null) {
                        j = 0;
                        l = messageSend.arguments.length;
                        while (j < l) {
                            if (messageSend.arguments[j].sourceStart == start) {
                                return messageSend.arguments[j];
                            }
                            ++j;
                        }
                    }
                }
                ++i;
            }
        }
        return null;
    }

    public StringBuffer print(int indent, StringBuffer output) {
        int length;
        int i;
        Javadoc.printIndent(indent, output).append("/**\n");
        if (this.paramReferences != null) {
            i = 0;
            length = this.paramReferences.length;
            while (i < length) {
                Javadoc.printIndent(indent + 1, output).append(" * @param ");
                this.paramReferences[i].print(indent, output).append('\n');
                ++i;
            }
        }
        if (this.returnStatement != null) {
            Javadoc.printIndent(indent + 1, output).append(" * @");
            this.returnStatement.print(indent, output).append('\n');
        }
        if (this.exceptionReferences != null) {
            i = 0;
            length = this.exceptionReferences.length;
            while (i < length) {
                Javadoc.printIndent(indent + 1, output).append(" * @throws ");
                this.exceptionReferences[i].print(indent, output).append('\n');
                ++i;
            }
        }
        if (this.seeReferences != null) {
            i = 0;
            length = this.seeReferences.length;
            while (i < length) {
                Javadoc.printIndent(indent + 1, output).append(" * @see ");
                this.seeReferences[i].print(indent, output).append('\n');
                ++i;
            }
        }
        if (this.returnType != null) {
            Javadoc.printIndent(indent + 1, output).append(" * @type ");
            this.returnType.print(indent, output).append('\n');
        }
        if (this.memberOf != null) {
            Javadoc.printIndent(indent + 1, output).append(" * @member ");
            this.memberOf.print(indent, output).append('\n');
        }
        if (this.extendsType != null) {
            Javadoc.printIndent(indent + 1, output).append(" * @extends ");
            this.extendsType.print(indent, output).append('\n');
        }
        if (this.isConstructor) {
            Javadoc.printIndent(indent + 1, output).append(" * @constructor\n");
        }
        if ((this.modifiers & 2) != 0) {
            Javadoc.printIndent(indent + 1, output).append(" * @private\n");
        }
        if ((this.modifiers & 0x10) != 0) {
            Javadoc.printIndent(indent + 1, output).append(" * @final\n");
        }
        Javadoc.printIndent(indent, output).append(" */\n");
        return output;
    }

    public void resolve(ClassScope scope) {
        boolean source15;
        int paramTagsSize = this.paramReferences == null ? 0 : this.paramReferences.length;
        int i = 0;
        while (i < paramTagsSize) {
            JavadocSingleNameReference param = this.paramReferences[i];
            scope.problemReporter().javadocUnexpectedTag(param.tagSourceStart, param.tagSourceEnd);
            ++i;
        }
        if (this.returnStatement != null) {
            scope.problemReporter().javadocUnexpectedTag(this.returnStatement.sourceStart, this.returnStatement.sourceEnd);
        }
        int throwsTagsLength = this.exceptionReferences == null ? 0 : this.exceptionReferences.length;
        int i2 = 0;
        while (i2 < throwsTagsLength) {
            int end;
            int start;
            TypeReference typeRef = this.exceptionReferences[i2];
            if (typeRef instanceof JavadocSingleTypeReference) {
                JavadocSingleTypeReference singleRef = (JavadocSingleTypeReference)typeRef;
                start = singleRef.tagSourceStart;
                end = singleRef.tagSourceEnd;
            } else if (typeRef instanceof JavadocQualifiedTypeReference) {
                JavadocQualifiedTypeReference qualifiedRef = (JavadocQualifiedTypeReference)typeRef;
                start = qualifiedRef.tagSourceStart;
                end = qualifiedRef.tagSourceEnd;
            } else {
                start = typeRef.sourceStart;
                end = typeRef.sourceEnd;
            }
            scope.problemReporter().javadocUnexpectedTag(start, end);
            ++i2;
        }
        int seeTagsLength = this.seeReferences == null ? 0 : this.seeReferences.length;
        int i3 = 0;
        while (i3 < seeTagsLength) {
            this.resolveReference(this.seeReferences[i3], scope);
            ++i3;
        }
        boolean bl = source15 = scope.compilerOptions().sourceLevel >= 0x310000L;
        if (!source15 && this.valuePositions != -1L) {
            scope.problemReporter().javadocUnexpectedTag((int)(this.valuePositions >>> 32), (int)this.valuePositions);
        }
    }

    public void resolve(CompilationUnitScope unitScope) {
    }

    public void resolve(MethodScope methScope) {
        boolean source15;
        boolean reportMissing;
        AbstractMethodDeclaration methDecl = methScope.referenceMethod();
        boolean overriding = methDecl == null || methDecl.binding == null ? false : !methDecl.binding.isStatic() && (methDecl.binding.modifiers & 0x30000000) != 0;
        int seeTagsLength = this.seeReferences == null ? 0 : this.seeReferences.length;
        boolean superRef = false;
        int i = 0;
        while (i < seeTagsLength) {
            this.resolveReference(this.seeReferences[i], methScope);
            if (methDecl != null && (methDecl.isConstructor() || overriding) && !superRef) {
                if (this.seeReferences[i] instanceof JavadocMessageSend) {
                    ReferenceBinding methodReceiverType;
                    JavadocMessageSend messageSend = (JavadocMessageSend)this.seeReferences[i];
                    if (messageSend.binding != null && messageSend.binding.isValidBinding() && messageSend.actualReceiverType instanceof ReferenceBinding && (methodReceiverType = (ReferenceBinding)messageSend.actualReceiverType).isSuperclassOf(methDecl.binding.declaringClass) && CharOperation.equals(messageSend.selector, methDecl.getName()) && methDecl.binding.returnType.isCompatibleWith(messageSend.binding.returnType)) {
                        if (messageSend.arguments == null && methDecl.arguments == null) {
                            superRef = true;
                        } else if (messageSend.arguments != null && methDecl.arguments != null) {
                            superRef = methDecl.binding.areParametersEqual(messageSend.binding);
                        }
                    }
                } else if (this.seeReferences[i] instanceof JavadocAllocationExpression) {
                    JavadocAllocationExpression allocationExpr = (JavadocAllocationExpression)this.seeReferences[i];
                    if (allocationExpr.binding != null && allocationExpr.binding.isValidBinding() && methDecl.binding.declaringClass.isCompatibleWith(allocationExpr.resolvedType)) {
                        if (allocationExpr.arguments == null && methDecl.arguments == null) {
                            superRef = true;
                        } else if (allocationExpr.arguments != null && methDecl.arguments != null) {
                            superRef = methDecl.binding.areParametersCompatibleWith(allocationExpr.binding.parameters);
                        }
                    }
                }
            }
            ++i;
        }
        boolean bl = reportMissing = methDecl == null || (!overriding || this.inheritedPositions == -1L) && !superRef && (methDecl.binding == null || methDecl.binding.declaringClass == null || !methDecl.binding.declaringClass.isLocalType());
        if (!overriding && this.inheritedPositions != -1L) {
            int start = (int)(this.inheritedPositions >>> 32);
            int end = (int)this.inheritedPositions;
            methScope.problemReporter().javadocUnexpectedTag(start, end);
        }
        boolean considerParamRefAsUsage = methScope.compilerOptions().reportUnusedParameterIncludeDocCommentReference;
        this.resolveParamTags(methScope, reportMissing, considerParamRefAsUsage);
        if (this.returnStatement == null) {
            if (reportMissing && methDecl != null && methDecl.isMethod()) {
                MethodDeclaration meth = (MethodDeclaration)methDecl;
                if (meth.binding != null && meth.binding.returnType != TypeBinding.VOID && !meth.binding.isConstructor()) {
                    methScope.problemReporter().javadocMissingReturnTag(meth.declarationSourceStart, meth.declarationSourceEnd, methDecl.binding.modifiers);
                }
            }
        } else {
            this.returnStatement.resolve(methScope);
        }
        this.resolveThrowsTags(methScope, reportMissing);
        boolean bl2 = source15 = methScope.compilerOptions().sourceLevel >= 0x310000L;
        if (!source15 && methDecl != null && this.valuePositions != -1L) {
            methScope.problemReporter().javadocUnexpectedTag((int)(this.valuePositions >>> 32), (int)this.valuePositions);
        }
        int length = this.invalidParameters == null ? 0 : this.invalidParameters.length;
        int i2 = 0;
        while (i2 < length) {
            this.invalidParameters[i2].resolve(methScope, false, false);
            ++i2;
        }
    }

    private void resolveReference(Expression reference, Scope scope) {
        boolean source15;
        int problemCount = scope.referenceContext().compilationResult().problemCount;
        switch (scope.kind) {
            case 2: {
                reference.resolveType((MethodScope)scope);
                break;
            }
            case 3: {
                reference.resolveType((ClassScope)scope);
            }
        }
        boolean hasProblems = scope.referenceContext().compilationResult().problemCount > problemCount;
        boolean bl = source15 = scope.compilerOptions().sourceLevel >= 0x310000L;
        if (reference instanceof JavadocFieldReference) {
            JavadocFieldReference fieldRef = (JavadocFieldReference)reference;
            if (fieldRef.methodBinding != null && fieldRef.receiverType != null) {
                if (scope.enclosingSourceType().isCompatibleWith(fieldRef.receiverType)) {
                    fieldRef.bits |= 0x4000;
                }
                fieldRef.methodBinding = scope.findMethod((ReferenceBinding)fieldRef.receiverType, fieldRef.token, new TypeBinding[0], fieldRef);
            }
            if (!hasProblems && fieldRef.binding != null && fieldRef.binding.isValidBinding() && fieldRef.receiverType instanceof ReferenceBinding) {
                ReferenceBinding resolvedType = (ReferenceBinding)fieldRef.receiverType;
                this.verifyTypeReference(fieldRef, fieldRef.receiver, scope, source15, resolvedType, fieldRef.binding.modifiers);
            }
            return;
        }
        if (!hasProblems && (reference instanceof JavadocSingleTypeReference || reference instanceof JavadocQualifiedTypeReference) && reference.resolvedType instanceof ReferenceBinding) {
            ReferenceBinding resolvedType = (ReferenceBinding)reference.resolvedType;
            this.verifyTypeReference(reference, reference, scope, source15, resolvedType, resolvedType.modifiers);
        }
        if (reference instanceof JavadocMessageSend) {
            JavadocMessageSend msgSend = (JavadocMessageSend)reference;
            if (!hasProblems && msgSend.binding != null && msgSend.binding.isValidBinding() && msgSend.actualReceiverType instanceof ReferenceBinding) {
                ReferenceBinding resolvedType = (ReferenceBinding)msgSend.actualReceiverType;
                this.verifyTypeReference(msgSend, msgSend.receiver, scope, source15, resolvedType, msgSend.binding.modifiers);
            }
        } else if (reference instanceof JavadocAllocationExpression) {
            JavadocAllocationExpression alloc = (JavadocAllocationExpression)reference;
            if (!hasProblems && alloc.binding != null && alloc.binding.isValidBinding() && alloc.resolvedType instanceof ReferenceBinding) {
                ReferenceBinding resolvedType = (ReferenceBinding)alloc.resolvedType;
                this.verifyTypeReference(alloc, alloc.type, scope, source15, resolvedType, alloc.binding.modifiers);
            }
        }
    }

    private void resolveParamTags(MethodScope scope, boolean reportMissing, boolean considerParamRefAsUsage) {
        block14: {
            int j;
            boolean found;
            int argumentsSize;
            int paramTagsSize;
            AbstractMethodDeclaration methodDecl;
            block13: {
                methodDecl = scope.referenceMethod();
                int n = paramTagsSize = this.paramReferences == null ? 0 : this.paramReferences.length;
                if (methodDecl == null) {
                    int i = 0;
                    while (i < paramTagsSize) {
                        JavadocSingleNameReference param = this.paramReferences[i];
                        scope.problemReporter().javadocUnexpectedTag(param.tagSourceStart, param.tagSourceEnd);
                        ++i;
                    }
                    return;
                }
                int n2 = argumentsSize = methodDecl.arguments == null ? 0 : methodDecl.arguments.length;
                if (paramTagsSize != 0) break block13;
                if (!reportMissing) break block14;
                int i = 0;
                while (i < argumentsSize) {
                    Argument arg = methodDecl.arguments[i];
                    scope.problemReporter().javadocMissingParamTag(arg.name, arg.sourceStart, arg.sourceEnd, methodDecl.binding == null ? 0 : methodDecl.binding.modifiers);
                    ++i;
                }
                break block14;
            }
            LocalVariableBinding[] bindings = new LocalVariableBinding[paramTagsSize];
            int maxBindings = 0;
            int i = 0;
            while (i < paramTagsSize) {
                JavadocSingleNameReference param = this.paramReferences[i];
                param.resolve(scope, true, considerParamRefAsUsage);
                if (param.binding != null && param.binding.isValidBinding()) {
                    found = false;
                    j = 0;
                    while (j < maxBindings && !found) {
                        if (bindings[j] == param.binding) {
                            scope.problemReporter().javadocDuplicatedParamTag(param.token, param.sourceStart, param.sourceEnd, methodDecl.binding.modifiers);
                            found = true;
                        }
                        ++j;
                    }
                    if (!found) {
                        bindings[maxBindings++] = (LocalVariableBinding)param.binding;
                    }
                }
                ++i;
            }
            if (reportMissing) {
                i = 0;
                while (i < argumentsSize) {
                    Argument arg = methodDecl.arguments[i];
                    found = false;
                    j = 0;
                    while (j < maxBindings && !found) {
                        LocalVariableBinding binding = bindings[j];
                        if (arg.binding == binding) {
                            found = true;
                        }
                        ++j;
                    }
                    if (!found) {
                        scope.problemReporter().javadocMissingParamTag(arg.name, arg.sourceStart, arg.sourceEnd, methodDecl.binding.modifiers);
                    }
                    ++i;
                }
            }
        }
    }

    private void resolveThrowsTags(MethodScope methScope, boolean reportMissing) {
        int throwsTagsLength;
        AbstractMethodDeclaration md = methScope.referenceMethod();
        int n = throwsTagsLength = this.exceptionReferences == null ? 0 : this.exceptionReferences.length;
        if (md == null) {
            int i = 0;
            while (i < throwsTagsLength) {
                TypeReference typeRef = this.exceptionReferences[i];
                int start = typeRef.sourceStart;
                int end = typeRef.sourceEnd;
                if (typeRef instanceof JavadocQualifiedTypeReference) {
                    start = ((JavadocQualifiedTypeReference)typeRef).tagSourceStart;
                    end = ((JavadocQualifiedTypeReference)typeRef).tagSourceEnd;
                } else if (typeRef instanceof JavadocSingleTypeReference) {
                    start = ((JavadocSingleTypeReference)typeRef).tagSourceStart;
                    end = ((JavadocSingleTypeReference)typeRef).tagSourceEnd;
                }
                methScope.problemReporter().javadocUnexpectedTag(start, end);
                ++i;
            }
            return;
        }
        if (throwsTagsLength != 0) {
            int maxRef = 0;
            TypeReference[] typeReferences = new TypeReference[throwsTagsLength];
            int i = 0;
            while (i < throwsTagsLength) {
                TypeReference typeRef = this.exceptionReferences[i];
                typeRef.resolve(methScope);
                TypeBinding typeBinding = typeRef.resolvedType;
                if (typeBinding != null && typeBinding.isValidBinding() && typeBinding.isClass()) {
                    typeReferences[maxRef++] = typeRef;
                }
                ++i;
            }
        }
    }

    private void verifyTypeReference(Expression reference, Expression typeReference, Scope scope, boolean source15, ReferenceBinding resolvedType, int modifiers) {
        if (resolvedType.isValidBinding()) {
            if (!this.canBeSeen(scope.problemReporter().options.reportInvalidJavadocTagsVisibility, modifiers)) {
                scope.problemReporter().javadocHiddenReference(typeReference.sourceStart, reference.sourceEnd, scope, modifiers);
                return;
            }
            if (reference != typeReference && !this.canBeSeen(scope.problemReporter().options.reportInvalidJavadocTagsVisibility, resolvedType.modifiers)) {
                scope.problemReporter().javadocHiddenReference(typeReference.sourceStart, typeReference.sourceEnd, scope, resolvedType.modifiers);
                return;
            }
            if (resolvedType.isMemberType()) {
                ReferenceBinding topLevelType = resolvedType;
                int packageLength = topLevelType.fPackage.compoundName.length;
                int depth = resolvedType.depth();
                int idx = depth + packageLength;
                char[][] computedCompoundName = new char[idx + 1][];
                computedCompoundName[idx] = topLevelType.sourceName;
                while (topLevelType.enclosingType() != null) {
                    topLevelType = topLevelType.enclosingType();
                    computedCompoundName[--idx] = topLevelType.sourceName;
                }
                int i = packageLength;
                while (--i >= 0) {
                    computedCompoundName[--idx] = topLevelType.fPackage.compoundName[i];
                }
                ClassScope topLevelScope = scope.classScope();
                if (topLevelScope.parent.kind != 4 || !CharOperation.equals(topLevelType.sourceName, topLevelScope.referenceContext.name)) {
                    topLevelScope = topLevelScope.outerMostClassScope();
                    if (typeReference instanceof JavadocSingleTypeReference && (!source15 && depth == 1 || topLevelType != topLevelScope.referenceContext.binding) && source15) {
                        CompilationUnitScope unitScope = topLevelScope.compilationUnitScope();
                        ImportBinding[] imports = unitScope.imports;
                        int length = imports == null ? 0 : imports.length;
                        int i2 = 0;
                        block2: while (i2 < length) {
                            char[][] compoundName = imports[i2].compoundName;
                            int compoundNameLength = compoundName.length;
                            if (imports[i2].onDemand && compoundNameLength == computedCompoundName.length - 1 || compoundNameLength == computedCompoundName.length) {
                                int j = compoundNameLength;
                                while (--j >= 0) {
                                    if (!CharOperation.equals(imports[i2].compoundName[j], computedCompoundName[j])) break;
                                    if (j == 0) break block2;
                                }
                            }
                            ++i2;
                        }
                    }
                }
            }
        }
    }

    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope)) {
            int length;
            int i;
            if (this.paramReferences != null) {
                i = 0;
                length = this.paramReferences.length;
                while (i < length) {
                    this.paramReferences[i].traverse(visitor, scope);
                    ++i;
                }
            }
            if (this.returnStatement != null) {
                this.returnStatement.traverse(visitor, scope);
            }
            if (this.exceptionReferences != null) {
                i = 0;
                length = this.exceptionReferences.length;
                while (i < length) {
                    this.exceptionReferences[i].traverse(visitor, scope);
                    ++i;
                }
            }
            if (this.seeReferences != null) {
                i = 0;
                length = this.seeReferences.length;
                while (i < length) {
                    this.seeReferences[i].traverse(visitor, scope);
                    ++i;
                }
            }
        }
        visitor.endVisit(this, scope);
    }

    public void traverse(ASTVisitor visitor, ClassScope scope) {
        if (visitor.visit(this, scope)) {
            int length;
            int i;
            if (this.paramReferences != null) {
                i = 0;
                length = this.paramReferences.length;
                while (i < length) {
                    this.paramReferences[i].traverse(visitor, scope);
                    ++i;
                }
            }
            if (this.returnStatement != null) {
                this.returnStatement.traverse(visitor, scope);
            }
            if (this.exceptionReferences != null) {
                i = 0;
                length = this.exceptionReferences.length;
                while (i < length) {
                    this.exceptionReferences[i].traverse(visitor, scope);
                    ++i;
                }
            }
            if (this.seeReferences != null) {
                i = 0;
                length = this.seeReferences.length;
                while (i < length) {
                    this.seeReferences[i].traverse(visitor, scope);
                    ++i;
                }
            }
        }
        visitor.endVisit(this, scope);
    }

    public JavadocSingleNameReference findParam(char[] name) {
        if (this.paramReferences != null) {
            int i = 0;
            while (i < this.paramReferences.length) {
                if (CharOperation.equals(name, this.paramReferences[i].token)) {
                    return this.paramReferences[i];
                }
                ++i;
            }
        }
        return null;
    }

    public int getASTType() {
        return 51;
    }
}

