/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import java.util.ArrayList;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.compiler.CategorizedProblem;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.internal.codeassist.ISelectionRequestor;
import org.eclipse.wst.jsdt.internal.codeassist.SelectionEngine;
import org.eclipse.wst.jsdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.wst.jsdt.internal.core.ClassFile;
import org.eclipse.wst.jsdt.internal.core.CompilationUnit;
import org.eclipse.wst.jsdt.internal.core.JavaElement;
import org.eclipse.wst.jsdt.internal.core.LocalVariable;
import org.eclipse.wst.jsdt.internal.core.NameLookup;
import org.eclipse.wst.jsdt.internal.core.Openable;
import org.eclipse.wst.jsdt.internal.core.ResolvedBinaryField;
import org.eclipse.wst.jsdt.internal.core.ResolvedBinaryMethod;
import org.eclipse.wst.jsdt.internal.core.ResolvedSourceField;
import org.eclipse.wst.jsdt.internal.core.ResolvedSourceMethod;
import org.eclipse.wst.jsdt.internal.core.ResolvedSourceType;
import org.eclipse.wst.jsdt.internal.core.SourceField;
import org.eclipse.wst.jsdt.internal.core.util.HandleFactory;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class SelectionRequestor
implements ISelectionRequestor {
    protected NameLookup nameLookup;
    protected Openable openable;
    protected IJavaScriptElement[] elements = JavaElement.NO_ELEMENTS;
    protected int elementIndex = -1;
    protected HandleFactory handleFactory = new HandleFactory();
    private static final char[] js = new char[]{'.', 'j', 's'};

    public SelectionRequestor(NameLookup nameLookup, Openable openable) {
        this.nameLookup = nameLookup;
        this.openable = openable;
    }

    private void acceptBinaryMethod(IType type, IFunction method, char[] uniqueKey, boolean isConstructor) {
        try {
            if (!isConstructor || ((JavaElement)((Object)method)).getSourceMapper() == null) {
                if (uniqueKey != null) {
                    ResolvedBinaryMethod resolvedMethod = new ResolvedBinaryMethod((JavaElement)method.getParent(), method.getElementName(), method.getParameterTypes(), new String(uniqueKey));
                    resolvedMethod.occurrenceCount = method.getOccurrenceCount();
                    method = resolvedMethod;
                }
                this.addElement(method);
                if (SelectionEngine.DEBUG) {
                    System.out.print("SELECTION - accept method(");
                    System.out.print(method.toString());
                    System.out.println(")");
                }
            } else {
                ISourceRange range = method.getSourceRange();
                if (range.getOffset() != -1 && range.getLength() != 0) {
                    if (uniqueKey != null) {
                        ResolvedBinaryMethod resolvedMethod = new ResolvedBinaryMethod((JavaElement)method.getParent(), method.getElementName(), method.getParameterTypes(), new String(uniqueKey));
                        resolvedMethod.occurrenceCount = method.getOccurrenceCount();
                        method = resolvedMethod;
                    }
                    this.addElement(method);
                    if (SelectionEngine.DEBUG) {
                        System.out.print("SELECTION - accept method(");
                        System.out.print(method.toString());
                        System.out.println(")");
                    }
                } else {
                    this.addElement(type);
                    if (SelectionEngine.DEBUG) {
                        System.out.print("SELECTION - accept type(");
                        System.out.print(type.toString());
                        System.out.println(")");
                    }
                }
            }
        }
        catch (JavaScriptModelException javaScriptModelException) {}
    }

    protected void acceptBinaryMethod(IType type, char[] selector, char[][] parameterPackageNames, char[][] parameterTypeNames, String[] parameterSignatures, char[][] typeParameterNames, char[][][] typeParameterBoundNames, char[] uniqueKey, boolean isConstructor) {
        IFunction method = type.getFunction(new String(selector), parameterSignatures);
        if (method.exists()) {
            IFunction[] methods;
            if (typeParameterNames != null && typeParameterNames.length != 0 && (methods = type.findMethods(method)).length > 1) {
                int i = 0;
                while (i < methods.length) {
                    this.acceptBinaryMethod(type, method, uniqueKey, isConstructor);
                    ++i;
                }
                return;
            }
            this.acceptBinaryMethod(type, method, uniqueKey, isConstructor);
        }
    }

    public void acceptType(char[] packageName, char[] fileName, char[] typeName, int modifiers, boolean isDeclaration, char[] uniqueKey, int start, int end) {
        int acceptFlags = 0;
        boolean kind = false;
        acceptFlags = 2;
        IType type = null;
        if (isDeclaration) {
            type = this.resolveTypeByLocation(packageName, typeName, acceptFlags, start, end);
        } else {
            type = this.resolveType(packageName, fileName, typeName, acceptFlags);
            if (type != null) {
                String key = uniqueKey == null ? type.getKey() : new String(uniqueKey);
                ResolvedSourceType resolvedType = new ResolvedSourceType((JavaElement)type.getParent(), type.getElementName(), key);
                resolvedType.occurrenceCount = type.getOccurrenceCount();
                type = resolvedType;
            }
        }
        if (type != null) {
            this.addElement(type);
            if (SelectionEngine.DEBUG) {
                System.out.print("SELECTION - accept type(");
                System.out.print(type.toString());
                System.out.println(")");
            }
        }
    }

    public void acceptError(CategorizedProblem error) {
    }

    public void acceptField(char[] declaringTypePackageName, char[] fileName, char[] declaringTypeName, char[] name, boolean isDeclaration, char[] uniqueKey, int start, int end) {
        if (isDeclaration) {
            IType type = this.resolveTypeByLocation(declaringTypePackageName, declaringTypeName, 30, start, end);
            if (type != null) {
                try {
                    IField[] fields = type.getFields();
                    int i = 0;
                    while (i < fields.length) {
                        IField field = fields[i];
                        ISourceRange range = field.getNameRange();
                        if (range.getOffset() <= start && range.getOffset() + range.getLength() >= end && field.getElementName().equals(new String(name))) {
                            this.addElement(fields[i]);
                            if (SelectionEngine.DEBUG) {
                                System.out.print("SELECTION - accept field(");
                                System.out.print(field.toString());
                                System.out.println(")");
                            }
                            return;
                        }
                        ++i;
                    }
                }
                catch (JavaScriptModelException javaScriptModelException) {
                    return;
                }
            }
        } else {
            IType type = this.resolveType(declaringTypePackageName, fileName, declaringTypeName, 30);
            if (type != null) {
                IField field = type.getField(new String(name));
                if (field.exists()) {
                    if (uniqueKey != null) {
                        ResolvedSourceField resolvedField = new ResolvedSourceField((JavaElement)field.getParent(), field.getElementName(), new String(uniqueKey));
                        resolvedField.occurrenceCount = field.getOccurrenceCount();
                        field = resolvedField;
                    }
                    this.addElement(field);
                    if (SelectionEngine.DEBUG) {
                        System.out.print("SELECTION - accept field(");
                        System.out.print(field.toString());
                        System.out.println(")");
                    }
                } else {
                    IFunction method = type.getFunction(new String(name), null);
                    if (method.exists()) {
                        if (uniqueKey != null) {
                            ResolvedSourceField resolvedField = new ResolvedSourceField((JavaElement)method.getParent(), method.getElementName(), new String(uniqueKey));
                            resolvedField.occurrenceCount = method.getOccurrenceCount();
                            field = resolvedField;
                        }
                        this.addElement(field);
                        if (SelectionEngine.DEBUG) {
                            System.out.print("SELECTION - accept field(");
                            System.out.print(field.toString());
                            System.out.println(")");
                        }
                    }
                }
            }
        }
    }

    public void acceptLocalField(FieldBinding fieldBinding) {
        IType type;
        IField field;
        SourceTypeBinding typeBinding = (SourceTypeBinding)fieldBinding.declaringClass;
        IJavaScriptElement res = this.findLocalElement(typeBinding.sourceStart());
        if (res != null && res.getElementType() == 7 && (field = (type = (IType)res).getField(new String(fieldBinding.name))).exists()) {
            char[] uniqueKey = fieldBinding.computeUniqueKey();
            if (field.isBinary()) {
                ResolvedBinaryField resolvedField = new ResolvedBinaryField((JavaElement)field.getParent(), field.getElementName(), new String(uniqueKey));
                resolvedField.occurrenceCount = field.getOccurrenceCount();
                field = resolvedField;
            } else {
                ResolvedSourceField resolvedField = new ResolvedSourceField((JavaElement)field.getParent(), field.getElementName(), new String(uniqueKey));
                resolvedField.occurrenceCount = field.getOccurrenceCount();
                field = resolvedField;
            }
            this.addElement(field);
            if (SelectionEngine.DEBUG) {
                System.out.print("SELECTION - accept field(");
                System.out.print(field.toString());
                System.out.println(")");
            }
        }
    }

    public void acceptLocalMethod(MethodBinding methodBinding) {
        IJavaScriptElement res = this.findLocalElement(methodBinding.sourceStart());
        if (res != null) {
            if (res.getElementType() == 9) {
                IFunction method = (IFunction)res;
                char[] uniqueKey = methodBinding.computeUniqueKey();
                if (method.isBinary()) {
                    ResolvedBinaryMethod resolvedRes = new ResolvedBinaryMethod((JavaElement)res.getParent(), method.getElementName(), method.getParameterTypes(), new String(uniqueKey));
                    resolvedRes.occurrenceCount = method.getOccurrenceCount();
                    res = resolvedRes;
                } else {
                    ResolvedSourceMethod resolvedRes = new ResolvedSourceMethod((JavaElement)res.getParent(), method.getElementName(), method.getParameterTypes(), new String(uniqueKey));
                    resolvedRes.occurrenceCount = method.getOccurrenceCount();
                    res = resolvedRes;
                }
                this.addElement(res);
                if (SelectionEngine.DEBUG) {
                    System.out.print("SELECTION - accept method(");
                    System.out.print(res.toString());
                    System.out.println(")");
                }
            } else if (methodBinding.selector == TypeConstants.INIT && res.getElementType() == 7) {
                res = ((JavaElement)res).resolved(methodBinding.declaringClass);
                this.addElement(res);
                if (SelectionEngine.DEBUG) {
                    System.out.print("SELECTION - accept type(");
                    System.out.print(res.toString());
                    System.out.println(")");
                }
            }
        }
    }

    public void acceptLocalType(TypeBinding typeBinding) {
        IJavaScriptElement res = null;
        if (typeBinding instanceof SourceTypeBinding) {
            res = this.findLocalElement(((SourceTypeBinding)typeBinding).sourceStart());
        }
        if (res != null && res.getElementType() == 7) {
            res = ((JavaElement)res).resolved(typeBinding);
            this.addElement(res);
            if (SelectionEngine.DEBUG) {
                System.out.print("SELECTION - accept type(");
                System.out.print(res.toString());
                System.out.println(")");
            }
        }
    }

    public void acceptLocalVariable(LocalVariableBinding binding) {
        LocalDeclaration local = binding.declaration;
        if (local == null) {
            return;
        }
        IJavaScriptElement parent = null;
        if (binding.declaringScope instanceof CompilationUnitScope) {
            char[] fileName;
            CompilationUnitScope compilationUnitScope = (CompilationUnitScope)binding.declaringScope;
            char[] packageName = CharOperation.concatWith(compilationUnitScope.currentPackageName, '.');
            parent = this.resolveCompilationUnit(packageName, fileName = compilationUnitScope.referenceContext.compilationUnitBinding.qualifiedSourceName());
            if (parent == null) {
                parent = this.resolveCompilationUnit(CharOperation.NO_CHAR, fileName);
            }
        } else {
            parent = this.findLocalElement(local.sourceStart);
        }
        Object localVar = null;
        if (parent != null) {
            String localName = new String(local.name);
            if (parent instanceof SourceField) {
                SourceField sourceField = (SourceField)parent;
                if (sourceField.name.equals(localName)) {
                    parent = sourceField.getParent();
                }
            }
            localVar = new LocalVariable((JavaElement)parent, localName, local.declarationSourceStart, local.declarationSourceEnd, local.sourceStart, local.sourceEnd, Util.typeSignature(local.type));
        }
        if (localVar != null) {
            this.addElement((IJavaScriptElement)localVar);
            if (SelectionEngine.DEBUG) {
                System.out.print("SELECTION - accept local variable(");
                System.out.print(localVar.toString());
                System.out.println(")");
            }
        }
    }

    public void acceptMethod(char[] declaringTypePackageName, char[] fileName, char[] declaringTypeName, String enclosingDeclaringTypeSignature, char[] selector, char[][] parameterPackageNames, char[][] parameterTypeNames, String[] parameterSignatures, char[][] typeParameterNames, char[][][] typeParameterBoundNames, boolean isConstructor, boolean isDeclaration, char[] uniqueKey, int start, int end) {
        IJavaScriptElement[] previousElement = this.elements;
        int previousElementIndex = this.elementIndex;
        this.elements = JavaElement.NO_ELEMENTS;
        this.elementIndex = -1;
        boolean isFileName = SelectionRequestor.isFileName(declaringTypeName);
        if (isDeclaration) {
            IType type = this.resolveTypeByLocation(declaringTypePackageName, declaringTypeName, 30, start, end);
            this.acceptMethodDeclaration(type, selector, start, end);
        } else {
            IJavaScriptElement parent = !isFileName ? this.resolveType(declaringTypePackageName, fileName, declaringTypeName, 30) : this.resolveCompilationUnit(declaringTypePackageName, declaringTypeName);
            this.acceptSourceMethod(parent, selector, parameterPackageNames, parameterTypeNames, parameterSignatures, typeParameterNames, typeParameterBoundNames, uniqueKey);
        }
        if (previousElementIndex > -1) {
            int elementsLength = this.elementIndex + previousElementIndex + 2;
            if (elementsLength > this.elements.length) {
                this.elements = new IJavaScriptElement[elementsLength * 2 + 1];
                System.arraycopy(this.elements, 0, this.elements, 0, this.elementIndex + 1);
            }
            System.arraycopy(previousElement, 0, this.elements, this.elementIndex + 1, previousElementIndex + 1);
            this.elementIndex += previousElementIndex + 1;
        }
    }

    private static boolean isFileName(char[] name) {
        return CharOperation.endsWith(name, js) && CharOperation.contains('/', name);
    }

    public void acceptPackage(char[] packageName) {
        IPackageFragment[] pkgs = this.nameLookup.findPackageFragments(new String(packageName), false);
        if (pkgs != null) {
            int i = 0;
            int length = pkgs.length;
            while (i < length) {
                this.addElement(pkgs[i]);
                if (SelectionEngine.DEBUG) {
                    System.out.print("SELECTION - accept package(");
                    System.out.print(pkgs[i].toString());
                    System.out.println(")");
                }
                ++i;
            }
        }
    }

    protected void acceptSourceMethod(IJavaScriptElement parent, char[] selector, char[][] parameterPackageNames, char[][] parameterTypeNames, String[] parameterSignatures, char[][] typeParameterNames, char[][][] typeParameterBoundNames, char[] uniqueKey) {
        String name = new String(selector);
        IFunction[] methods = null;
        try {
            if (parent instanceof IType) {
                methods = ((IType)parent).getFunctions();
            } else if (parent instanceof IJavaScriptUnit) {
                methods = ((IJavaScriptUnit)parent).getFunctions();
            } else if (parent instanceof IClassFile) {
                methods = ((IClassFile)parent).getFunctions();
            }
            if (methods != null) {
                int i = 0;
                while (i < methods.length) {
                    if (methods[i].getElementName().equals(name)) {
                        IFunction method = methods[i];
                        if (uniqueKey != null) {
                            ResolvedSourceMethod resolvedMethod = new ResolvedSourceMethod((JavaElement)method.getParent(), method.getElementName(), method.getParameterTypes(), new String(uniqueKey));
                            resolvedMethod.occurrenceCount = method.getOccurrenceCount();
                            method = resolvedMethod;
                        }
                        this.addElement(method);
                    }
                    ++i;
                }
            }
        }
        catch (JavaScriptModelException javaScriptModelException) {
            return;
        }
        if (this.elementIndex == -1) {
            this.addElement(parent);
            if (SelectionEngine.DEBUG) {
                System.out.print("SELECTION - accept type(");
                System.out.print(parent.toString());
                System.out.println(")");
            }
            return;
        }
        if (this.elementIndex == 0) {
            if (SelectionEngine.DEBUG) {
                System.out.print("SELECTION - accept method(");
                System.out.print(this.elements[0].toString());
                System.out.println(")");
            }
            return;
        }
        IJavaScriptElement[] matches = this.elements;
        int matchesIndex = this.elementIndex;
        this.elements = JavaElement.NO_ELEMENTS;
        this.elementIndex = -1;
        int i = 0;
        while (i <= matchesIndex) {
            IFunction method = (IFunction)matches[i];
            String[] signatures = method.getParameterTypes();
            boolean match = true;
            int p = 0;
            while (p < signatures.length) {
                char[] simpleParameterName;
                String simpleName = Signature.getSimpleName(Signature.toString(signatures[p]));
                if (!simpleName.equals(new String(simpleParameterName = CharOperation.lastSegment(parameterTypeNames[p], '.')))) {
                    match = false;
                    break;
                }
                ++p;
            }
            if (match) {
                this.addElement(method);
                if (SelectionEngine.DEBUG) {
                    System.out.print("SELECTION - accept method(");
                    System.out.print(method.toString());
                    System.out.println(")");
                }
            }
            ++i;
        }
    }

    protected void acceptMethodDeclaration(IType type, char[] selector, int start, int end) {
        String name = new String(selector);
        IFunction[] methods = null;
        try {
            if (type != null) {
                methods = type.getFunctions();
            } else if (this.openable instanceof CompilationUnit) {
                methods = ((CompilationUnit)this.openable).getFunctions();
            } else if (this.openable instanceof ClassFile) {
                methods = ((ClassFile)this.openable).getFunctions();
            }
            int i = 0;
            while (i < methods.length) {
                ISourceRange range = methods[i].getNameRange();
                if (range.getOffset() <= start && range.getOffset() + range.getLength() >= end && methods[i].getElementName().equals(name)) {
                    this.addElement(methods[i]);
                    if (SelectionEngine.DEBUG) {
                        System.out.print("SELECTION - accept method(");
                        System.out.print(this.elements[0].toString());
                        System.out.println(")");
                    }
                    return;
                }
                ++i;
            }
        }
        catch (JavaScriptModelException javaScriptModelException) {
            return;
        }
        this.addElement(type);
        if (SelectionEngine.DEBUG) {
            System.out.print("SELECTION - accept type(");
            System.out.print(type.toString());
            System.out.println(")");
        }
    }

    public void acceptTypeParameter(char[] declaringTypePackageName, char[] fileName, char[] declaringTypeName, char[] typeParameterName, boolean isDeclaration, int start, int end) {
        IType type = isDeclaration ? this.resolveTypeByLocation(declaringTypePackageName, declaringTypeName, 30, start, end) : this.resolveType(declaringTypePackageName, fileName, declaringTypeName, 30);
        if (type != null) {
            this.addElement(type);
            if (SelectionEngine.DEBUG) {
                System.out.print("SELECTION - accept type(");
                System.out.print(type.toString());
                System.out.println(")");
            }
        }
    }

    public void acceptMethodTypeParameter(char[] declaringTypePackageName, char[] fileName, char[] declaringTypeName, char[] selector, int selectorStart, int selectorEnd, char[] typeParameterName, boolean isDeclaration, int start, int end) {
        IType type = this.resolveTypeByLocation(declaringTypePackageName, declaringTypeName, 30, selectorStart, selectorEnd);
        if (type != null) {
            Object method = null;
            String name = new String(selector);
            IFunction[] methods = null;
            try {
                methods = type.getFunctions();
                int i = 0;
                while (i < methods.length) {
                    ISourceRange range = methods[i].getNameRange();
                    if (range.getOffset() >= selectorStart && range.getOffset() + range.getLength() <= selectorEnd && methods[i].getElementName().equals(name)) {
                        method = methods[i];
                        break;
                    }
                    ++i;
                }
            }
            catch (JavaScriptModelException javaScriptModelException) {}
            if (method == null) {
                this.addElement(type);
                if (SelectionEngine.DEBUG) {
                    System.out.print("SELECTION - accept type(");
                    System.out.print(type.toString());
                    System.out.println(")");
                }
            } else {
                this.addElement((IJavaScriptElement)method);
                if (SelectionEngine.DEBUG) {
                    System.out.print("SELECTION - accept method(");
                    System.out.print(method.toString());
                    System.out.println(")");
                }
            }
        }
    }

    protected void addElement(IJavaScriptElement element) {
        int elementLength = this.elementIndex + 1;
        if (elementLength == this.elements.length) {
            this.elements = new IJavaScriptElement[elementLength * 2 + 1];
            System.arraycopy(this.elements, 0, this.elements, 0, elementLength);
        }
        this.elements[++this.elementIndex] = element;
    }

    protected IJavaScriptElement findLocalElement(int pos) {
        IJavaScriptElement res = null;
        if (this.openable instanceof ITypeRoot) {
            ITypeRoot cu = (ITypeRoot)((Object)this.openable);
            try {
                res = cu.getElementAt(pos);
            }
            catch (JavaScriptModelException javaScriptModelException) {}
        } else if (this.openable instanceof ClassFile) {
            ClassFile cf = (ClassFile)this.openable;
            try {
                res = cf.getElementAtConsideringSibling(pos);
            }
            catch (JavaScriptModelException javaScriptModelException) {}
        }
        return res;
    }

    public IJavaScriptElement[] getElements() {
        int elementLength = this.elementIndex + 1;
        if (this.elements.length != elementLength) {
            this.elements = new IJavaScriptElement[elementLength];
            System.arraycopy(this.elements, 0, this.elements, 0, elementLength);
        }
        return this.elements;
    }

    protected IType resolveType(char[] packageName, char[] fileName, char[] typeName, int acceptFlags) {
        ITypeRoot compilationUnit;
        IType type = null;
        if (fileName != null && (compilationUnit = (ITypeRoot)this.resolveCompilationUnit(packageName, fileName)) != null && compilationUnit.exists()) {
            String fulltypeName = null;
            fulltypeName = packageName == null || packageName.length == 0 ? new String(typeName) : new String(CharOperation.concat(packageName, typeName, '.'));
            type = compilationUnit.getType(fulltypeName);
            if (type != null && type.exists()) {
                return type;
            }
        }
        if (this.openable instanceof CompilationUnit && ((CompilationUnit)this.openable).isWorkingCopy()) {
            CompilationUnit wc = (CompilationUnit)this.openable;
            if (packageName == null || packageName.length == 0) {
                char[][] compoundName = CharOperation.splitOn('.', typeName);
                if (compoundName.length > 0) {
                    type = wc.getType(new String(compoundName[0]));
                    int i = 1;
                    int length = compoundName.length;
                    while (i < length) {
                        type = type.getType(new String(compoundName[i]));
                        ++i;
                    }
                }
                if (type != null && !type.exists()) {
                    type = null;
                }
            }
        }
        if (type == null) {
            IPackageFragment[] pkgs = this.nameLookup.findPackageFragments(packageName == null || packageName.length == 0 ? "" : new String(packageName), false);
            int i = 0;
            int length = pkgs == null ? 0 : pkgs.length;
            while (i < length) {
                type = this.nameLookup.findType(new String(typeName), pkgs[i], false, acceptFlags, true);
                if (type != null) break;
                ++i;
            }
            if (type == null) {
                String pName = "";
                if (packageName != null) {
                    pName = new String(packageName);
                }
                if (this.openable != null && this.openable.getParent().getElementName().equals(pName)) {
                    String tName = new String(typeName);
                    IType[] allTypes = null;
                    try {
                        ArrayList list = this.openable.getChildrenOfType(7);
                        allTypes = new IType[list.size()];
                        list.toArray(allTypes);
                    }
                    catch (JavaScriptModelException javaScriptModelException) {
                        return null;
                    }
                    int i2 = 0;
                    while (i2 < allTypes.length) {
                        if (allTypes[i2].getTypeQualifiedName().equals(tName)) {
                            return allTypes[i2];
                        }
                        ++i2;
                    }
                }
            }
        }
        return type;
    }

    protected IJavaScriptElement resolveCompilationUnit(char[] packageName, char[] compilationUnitName) {
        IJavaScriptElement compilationUnit = null;
        String fullCUName = new String(compilationUnitName);
        Path cuPath = new Path(fullCUName);
        String cuName = cuPath.lastSegment();
        Openable cu = new HandleFactory().createOpenable(fullCUName, null);
        if ((cu instanceof CompilationUnit || cu instanceof ClassFile) && cu.exists()) {
            return cu;
        }
        if ((this.openable instanceof CompilationUnit || this.openable instanceof ClassFile) && (cuName.equals(this.openable.getElementName()) && new String(packageName).equals(this.openable.getParent().getElementName()) || fullCUName.startsWith("http:") && fullCUName.equals(this.openable.getElementName()))) {
            return this.openable;
        }
        IPackageFragment[] pkgs = this.nameLookup.findPackageFragments(packageName == null || packageName.length == 0 ? "" : new String(packageName), false);
        int i = 0;
        int length = pkgs == null ? 0 : pkgs.length;
        while (i < length) {
            IJavaScriptUnit compUnit;
            if (!Util.isMetadataFileName(cuName) && (compUnit = pkgs[i].getJavaScriptUnit(cuName)).exists()) {
                return compUnit;
            }
            IClassFile classFile = pkgs[i].getClassFile(cuName);
            if (classFile.exists()) {
                return classFile;
            }
            ++i;
        }
        return compilationUnit;
    }

    protected IType resolveTypeByLocation(char[] packageName, char[] typeName, int acceptFlags, int start, int end) {
        IType type = null;
        if (this.openable instanceof CompilationUnit && ((CompilationUnit)this.openable).isOpen()) {
            CompilationUnit wc = (CompilationUnit)this.openable;
            try {
                if (packageName == null || packageName.length == 0) {
                    ISourceRange range;
                    IType[] tTypes;
                    char[][] compoundName = CharOperation.splitOn('.', typeName);
                    if (compoundName.length > 0) {
                        tTypes = wc.getTypes();
                        int i = 0;
                        int depth = 0;
                        while (i < tTypes.length) {
                            range = tTypes[i].getSourceRange();
                            if (range.getOffset() <= start && range.getOffset() + range.getLength() >= end && tTypes[i].getElementName().equals(new String(compoundName[depth]))) {
                                if (depth == compoundName.length - 1) {
                                    type = tTypes[i];
                                    break;
                                }
                                tTypes = tTypes[i].getTypes();
                                i = 0;
                                ++depth;
                                continue;
                            }
                            ++i;
                        }
                    }
                    tTypes = wc.getTypes();
                    String typeNameString = new String(typeName);
                    int i = 0;
                    while (i < tTypes.length && type == null) {
                        range = tTypes[i].getSourceRange();
                        if (range.getOffset() <= start && range.getOffset() + range.getLength() >= end && tTypes[i].getElementName().equals(typeNameString)) {
                            type = tTypes[i];
                        }
                        ++i;
                    }
                    if (type != null && !type.exists()) {
                        type = null;
                    }
                }
            }
            catch (JavaScriptModelException javaScriptModelException) {}
        }
        if (type == null && typeName != null && (type = this.nameLookup.findType(new String(typeName), false, acceptFlags)) == null) {
            String pName = "";
            if (packageName != null) {
                pName = new String(packageName);
            }
            if (this.openable != null && this.openable.getParent().getElementName().equals(pName)) {
                String tName = new String(typeName);
                IType[] allTypes = null;
                try {
                    ArrayList list = this.openable.getChildrenOfType(7);
                    allTypes = new IType[list.size()];
                    list.toArray(allTypes);
                }
                catch (JavaScriptModelException javaScriptModelException) {
                    return null;
                }
                int i = 0;
                while (i < allTypes.length) {
                    if (allTypes[i].getTypeQualifiedName().equals(tName)) {
                        return allTypes[i];
                    }
                    ++i;
                }
            }
        }
        return type;
    }
}

