/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor;

import java.util.Iterator;
import java.util.ResourceBundle;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.ui.texteditor.SelectMarkerRulerAction;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.validation.XtextAnnotation;

public final class XtextMarkerRulerAction
extends SelectMarkerRulerAction {
    protected XtextEditor textEditor;
    protected IVerticalRulerInfo ruler;

    public XtextMarkerRulerAction(ResourceBundle bundle, String prefix, XtextEditor editor, IVerticalRulerInfo ruler) {
        super(bundle, prefix, (ITextEditor)editor, ruler);
        this.textEditor = editor;
        this.ruler = ruler;
    }

    public void run() {
        try {
            IDocument document = this.getDocument();
            int annotationLine = this.ruler.getLineOfLastMouseButtonActivity();
            int annotationLineOffet = document.getLineOffset(annotationLine);
            Point currentSelection = this.textEditor.getInternalSourceViewer().getSelectedRange();
            int currentLine = document.getLineOfOffset(currentSelection.x);
            if (currentLine != annotationLine) {
                this.textEditor.getInternalSourceViewer().setSelectedRange(annotationLineOffet, 0);
            }
            ITextOperationTarget operation = (ITextOperationTarget)this.textEditor.getAdapter(ITextOperationTarget.class);
            int opCode = 22;
            if (operation != null && operation.canDoOperation(22)) {
                operation.doOperation(22);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void update() {
        this.setEnabled(this.hasQuickFixableAnnotationInCurrentLine());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean hasQuickFixableAnnotationInCurrentLine() {
        try {
            XtextAnnotation annotation;
            Object element;
            AbstractMarkerAnnotationModel annotationModel = this.getAnnotationModel();
            int line = this.ruler.getLineOfLastMouseButtonActivity();
            IDocument document = this.getDocument();
            IRegion region = document.getLineInformation(line);
            Iterator iterator = annotationModel.getAnnotationIterator(region.getOffset(), region.getLength(), true, true);
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!((element = iterator.next()) instanceof XtextAnnotation ? (annotation = (XtextAnnotation)((Object)element)).isQuickFixable() : element instanceof MarkerAnnotation && (annotation = (MarkerAnnotation)element).isQuickFixableStateSet() && annotation.isQuickFixable()));
            return true;
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return false;
    }
}

