/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.computation;

import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.xbase.XClosure;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.typesystem.computation.AbstractClosureTypeHelper;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeAssigner;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeComputationState;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeExpectation;
import org.eclipse.xtext.xbase.typesystem.conformance.ConformanceHint;
import org.eclipse.xtext.xbase.typesystem.references.FunctionTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.UnknownTypeReference;

@NonNullByDefault
public class UnknownClosureTypeHelper
extends AbstractClosureTypeHelper {
    protected UnknownClosureTypeHelper(XClosure closure, ITypeExpectation expectation, ITypeComputationState state) {
        super(closure, expectation, state);
    }

    protected void computeTypes() {
        ITypeAssigner typeAssigner = this.getState().withoutRootExpectation().assignTypes();
        ITypeComputationState closureBodyTypeComputationState = this.getClosureBodyTypeComputationState(typeAssigner);
        closureBodyTypeComputationState.computeTypes(this.getClosure().getExpression());
        this.getExpectation().acceptActualType(new UnknownTypeReference(this.getExpectation().getReferenceOwner()), ConformanceHint.UNCHECKED);
    }

    @Nullable
    public FunctionTypeReference getExpectedClosureType() {
        return null;
    }

    @Nullable
    public JvmOperation getOperation() {
        return null;
    }

    protected ITypeComputationState getClosureBodyTypeComputationState(ITypeAssigner typeAssigner) {
        EList<JvmFormalParameter> closureParameters = this.getClosure().getFormalParameters();
        int paramCount = closureParameters.size();
        int i = 0;
        while (i < paramCount) {
            JvmFormalParameter closureParameter = (JvmFormalParameter)closureParameters.get(i);
            if (closureParameter.eContainingFeature() != XbasePackage.Literals.XCLOSURE__IMPLICIT_PARAMETER && closureParameter.getParameterType() != null) {
                LightweightTypeReference closureParameterType = typeAssigner.toLightweightTypeReference(closureParameter.getParameterType());
                typeAssigner.assignType((JvmIdentifiableElement)closureParameter, closureParameterType);
            } else {
                typeAssigner.assignType((JvmIdentifiableElement)closureParameter, new UnknownTypeReference(typeAssigner.getReferenceOwner()));
            }
            ++i;
        }
        ITypeComputationState result = typeAssigner.getForkedState();
        return result;
    }
}

