/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.selenium.condition;

import com.thoughtworks.selenium.condition.Condition;
import com.thoughtworks.selenium.condition.ConditionRunner;

public class Text
extends Condition {
    private final String locator;
    private final String expectedText;

    public Text(String expectedText) {
        this(expectedText, (String)null);
    }

    public Text(String expectedText, String locator) {
        super("Expecting text " + expectedText + (locator == null ? "" : " in " + locator));
        this.locator = locator;
        this.expectedText = expectedText;
    }

    @Override
    public boolean isTrue(ConditionRunner.Context context) {
        if (this.locator == null) {
            return context.getSelenium().isTextPresent(this.expectedText);
        }
        return context.getSelenium().getText(this.locator).equalsIgnoreCase(this.expectedText);
    }
}

