/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives;

import org.apache.commons.collections.primitives.LongCollection;
import org.apache.commons.collections.primitives.LongIterator;

public abstract class AbstractLongCollection
implements LongCollection {
    @Override
    public abstract LongIterator iterator();

    @Override
    public abstract int size();

    protected AbstractLongCollection() {
    }

    @Override
    public boolean add(long element) {
        throw new UnsupportedOperationException("add(long) is not supported.");
    }

    @Override
    public boolean addAll(LongCollection c) {
        boolean modified = false;
        LongIterator iter = c.iterator();
        while (iter.hasNext()) {
            modified |= this.add(iter.next());
        }
        return modified;
    }

    @Override
    public void clear() {
        LongIterator iter = this.iterator();
        while (iter.hasNext()) {
            iter.next();
            iter.remove();
        }
    }

    @Override
    public boolean contains(long element) {
        LongIterator iter = this.iterator();
        while (iter.hasNext()) {
            if (iter.next() != element) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(LongCollection c) {
        LongIterator iter = c.iterator();
        while (iter.hasNext()) {
            if (this.contains(iter.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean removeElement(long element) {
        LongIterator iter = this.iterator();
        while (iter.hasNext()) {
            if (iter.next() != element) continue;
            iter.remove();
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(LongCollection c) {
        boolean modified = false;
        LongIterator iter = c.iterator();
        while (iter.hasNext()) {
            modified |= this.removeElement(iter.next());
        }
        return modified;
    }

    @Override
    public boolean retainAll(LongCollection c) {
        boolean modified = false;
        LongIterator iter = this.iterator();
        while (iter.hasNext()) {
            if (c.contains(iter.next())) continue;
            iter.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public long[] toArray() {
        long[] array = new long[this.size()];
        int i = 0;
        LongIterator iter = this.iterator();
        while (iter.hasNext()) {
            array[i] = iter.next();
            ++i;
        }
        return array;
    }

    @Override
    public long[] toArray(long[] a) {
        if (a.length < this.size()) {
            return this.toArray();
        }
        int i = 0;
        LongIterator iter = this.iterator();
        while (iter.hasNext()) {
            a[i] = iter.next();
            ++i;
        }
        return a;
    }
}

