/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives.adapters;

import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.primitives.ShortCollection;
import org.apache.commons.collections.primitives.ShortIterator;
import org.apache.commons.collections.primitives.ShortList;
import org.apache.commons.collections.primitives.ShortListIterator;
import org.apache.commons.collections.primitives.adapters.AbstractCollectionShortCollection;
import org.apache.commons.collections.primitives.adapters.ListIteratorShortListIterator;
import org.apache.commons.collections.primitives.adapters.ListShortList;
import org.apache.commons.collections.primitives.adapters.ShortCollectionCollection;

abstract class AbstractListShortList
extends AbstractCollectionShortCollection
implements ShortList {
    AbstractListShortList() {
    }

    @Override
    public void add(int index, short element) {
        this.getList().add(index, new Short(element));
    }

    @Override
    public boolean addAll(int index, ShortCollection collection) {
        return this.getList().addAll(index, ShortCollectionCollection.wrap(collection));
    }

    @Override
    public short get(int index) {
        return ((Number)this.getList().get(index)).shortValue();
    }

    @Override
    public int indexOf(short element) {
        return this.getList().indexOf(new Short(element));
    }

    @Override
    public int lastIndexOf(short element) {
        return this.getList().lastIndexOf(new Short(element));
    }

    @Override
    public ShortListIterator listIterator() {
        return ListIteratorShortListIterator.wrap(this.getList().listIterator());
    }

    @Override
    public ShortListIterator listIterator(int index) {
        return ListIteratorShortListIterator.wrap(this.getList().listIterator(index));
    }

    @Override
    public short removeElementAt(int index) {
        return ((Number)this.getList().remove(index)).shortValue();
    }

    @Override
    public short set(int index, short element) {
        return ((Number)this.getList().set(index, new Short(element))).shortValue();
    }

    @Override
    public ShortList subList(int fromIndex, int toIndex) {
        return ListShortList.wrap(this.getList().subList(fromIndex, toIndex));
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ShortList) {
            ShortList that = (ShortList)obj;
            if (this == that) {
                return true;
            }
            if (this.size() != that.size()) {
                return false;
            }
            ShortIterator thisiter = this.iterator();
            ShortIterator thatiter = that.iterator();
            while (thisiter.hasNext()) {
                if (thisiter.next() == thatiter.next()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.getList().hashCode();
    }

    @Override
    protected final Collection getCollection() {
        return this.getList();
    }

    protected abstract List getList();
}

