/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives.adapters.io;

import java.io.Reader;
import org.apache.commons.collections.primitives.CharIterator;

public class CharIteratorReader
extends Reader {
    private CharIterator iterator = null;

    public CharIteratorReader(CharIterator in) {
        this.iterator = in;
    }

    @Override
    public int read(char[] buf, int off, int len) {
        if (this.iterator.hasNext()) {
            int count = 0;
            while (this.iterator.hasNext() && count < len) {
                buf[off + count] = this.iterator.next();
                ++count;
            }
            return count;
        }
        return -1;
    }

    @Override
    public void close() {
    }

    public static Reader adapt(CharIterator in) {
        return in == null ? null : new CharIteratorReader(in);
    }
}

