/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.internal.ui.editors.action;

import org.eclipse.birt.report.designer.ui.util.ExceptionUtil;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.MeasureViewHandle;
import org.eclipse.birt.report.item.crosstab.internal.ui.AggregationCellProviderWrapper;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.action.AbstractCrosstabAction;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.model.CrosstabAdaptUtil;
import org.eclipse.birt.report.item.crosstab.ui.i18n.Messages;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;

public class DeleteMeasureHandleAction
extends AbstractCrosstabAction {
    private MeasureViewHandle measureViewHandle;
    private static final String ACTION_MSG_MERGE = Messages.getString("DeleteMeasureHandleAction.DisplayName");
    public static final String ID = "org.eclipse.birt.report.item.crosstab.internal.ui.editors.action.DeleteMeasureHandleAction";
    private static final String NAME = Messages.getString("DeleteMeasureHandleAction.TransName");

    public DeleteMeasureHandleAction(DesignElementHandle handle) {
        super(handle);
        this.setId(ID);
        this.setText(ACTION_MSG_MERGE);
        ExtendedItemHandle extendedHandle = CrosstabAdaptUtil.getExtendedItemHandle(handle);
        this.setHandle((DesignElementHandle)extendedHandle);
        this.measureViewHandle = CrosstabAdaptUtil.getMeasureViewHandle(extendedHandle);
        ISharedImages shareImages = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(shareImages.getImageDescriptor("IMG_TOOL_DELETE"));
    }

    public boolean isEnabled() {
        return !DEUtil.isReferenceElement((DesignElementHandle)this.measureViewHandle.getCrosstabHandle());
    }

    protected boolean calculateEnabled() {
        return !DEUtil.isReferenceElement((DesignElementHandle)this.measureViewHandle.getCrosstabHandle());
    }

    private CrosstabReportItemHandle getCrosstabReportItemHandle(Object editpart) {
        return this.measureViewHandle.getCrosstab();
    }

    public void run() {
        CrosstabReportItemHandle reportItem = this.getCrosstabReportItemHandle(this.getHandle());
        if (reportItem != null) {
            this.transStar(NAME);
            try {
                boolean bool = CrosstabAdaptUtil.needRemoveInvaildBindings(reportItem);
                if (bool) {
                    reportItem.removeMeasure(this.measureViewHandle.getIndex());
                    CrosstabAdaptUtil.removeInvalidBindings(reportItem);
                }
                AggregationCellProviderWrapper providerWrapper = new AggregationCellProviderWrapper((ExtendedItemHandle)reportItem.getModelHandle());
                providerWrapper.updateAllAggregationCells(0);
            }
            catch (SemanticException e) {
                this.rollBack();
                ExceptionUtil.handle((Throwable)e);
                return;
            }
            this.transEnd();
        }
    }
}

