/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.pde.helper;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.core.plugin.IExtensions;
import org.eclipse.pde.core.plugin.IExtensionsModelFactory;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginModelFactory;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.core.plugin.IPluginParent;

public class ExtensionHelper {
    public static IPluginExtension createExtension(IPluginModelBase pluginModelBase, String extensionPointId) throws CoreException {
        IPluginExtension extension = null;
        IPluginModelFactory pluginModelFactory = pluginModelBase.getPluginFactory();
        if (pluginModelFactory == null) {
            return null;
        }
        extension = pluginModelFactory.createExtension();
        if (extension == null) {
            return null;
        }
        extension.setPoint(extensionPointId);
        pluginModelBase.getExtensions().add(extension);
        return extension;
    }

    public static IPluginElement createPluginElement(IPluginParent parent, String name) throws CoreException {
        if (parent == null) {
            return null;
        }
        IPluginElement element = null;
        IExtensionsModelFactory factory = parent.getModel().getFactory();
        if (factory == null) {
            return null;
        }
        element = factory.createElement((IPluginObject)parent);
        if (element == null) {
            return null;
        }
        element.setName(name);
        parent.add((IPluginObject)element);
        return element;
    }

    public static IPluginExtension[] getPluginExtension(IExtensions extensions, String fullyQualifiedExtensionPointId) {
        ArrayList<IPluginExtension> result = new ArrayList<IPluginExtension>();
        if (fullyQualifiedExtensionPointId == null || extensions == null) {
            return result.toArray(new IPluginExtension[0]);
        }
        IPluginExtension[] iPluginExtensionArray = extensions.getExtensions();
        int n = iPluginExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginExtension pluginExtension = iPluginExtensionArray[n2];
            if (fullyQualifiedExtensionPointId.equals(pluginExtension.getPoint())) {
                result.add(pluginExtension);
            }
            ++n2;
        }
        return result.toArray(new IPluginExtension[result.size()]);
    }

    public static IPluginElement[] getPluginElement(IPluginParent parent, String element) {
        ArrayList<IPluginElement> result = new ArrayList<IPluginElement>(0);
        if (element == null || parent == null) {
            return result.toArray(new IPluginElement[0]);
        }
        IPluginObject[] iPluginObjectArray = parent.getChildren();
        int n = iPluginObjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginElement pluginElement;
            IPluginObject pluginObject = iPluginObjectArray[n2];
            if (pluginObject instanceof IPluginElement && element.equals((pluginElement = (IPluginElement)pluginObject).getName())) {
                result.add(pluginElement);
            }
            ++n2;
        }
        return result.toArray(new IPluginElement[result.size()]);
    }
}

