/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.op;

import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.egit.core.internal.job.RuleUtil;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.StashCreateCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.team.core.TeamException;

public class StashCreateOperation
implements IEGitOperation {
    private final Repository repository;
    private final String message;
    private RevCommit commit;

    public StashCreateOperation(Repository repository) {
        this(repository, null);
    }

    public StashCreateOperation(Repository repository, String message) {
        this.repository = repository;
        this.message = message;
    }

    public RevCommit getCommit() {
        return this.commit;
    }

    public void execute(IProgressMonitor monitor) throws CoreException {
        IWorkspaceRunnable action = new IWorkspaceRunnable(){

            public void run(IProgressMonitor pm) throws CoreException {
                try {
                    try {
                        StashCreateCommand command = Git.wrap((Repository)StashCreateOperation.this.repository).stashCreate();
                        if (StashCreateOperation.this.message != null) {
                            command.setWorkingDirectoryMessage(StashCreateOperation.this.message);
                        }
                        StashCreateOperation.this.commit = command.call();
                    }
                    catch (JGitInternalException e) {
                        throw new TeamException(e.getLocalizedMessage(), e.getCause());
                    }
                    catch (GitAPIException e) {
                        throw new TeamException(e.getLocalizedMessage(), e.getCause());
                    }
                }
                finally {
                    if (StashCreateOperation.this.commit != null) {
                        StashCreateOperation.this.repository.notifyIndexChanged();
                    }
                    pm.done();
                }
            }
        };
        ResourcesPlugin.getWorkspace().run(action, this.getSchedulingRule(), 1, (IProgressMonitor)(monitor != null ? monitor : new NullProgressMonitor()));
    }

    public ISchedulingRule getSchedulingRule() {
        return RuleUtil.getRule(this.repository);
    }
}

