/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.admin;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.eclipse.emf.cdo.admin.CDOAdminClient;
import org.eclipse.emf.cdo.admin.CDOAdminClientRepository;
import org.eclipse.emf.cdo.common.CDOCommonRepository;
import org.eclipse.emf.cdo.common.admin.CDOAdminRepository;
import org.eclipse.emf.cdo.internal.admin.CDOAdminClientRepositoryImpl;
import org.eclipse.emf.cdo.internal.admin.bundle.OM;
import org.eclipse.emf.cdo.internal.admin.protocol.CDOAdminClientProtocol;
import org.eclipse.emf.cdo.spi.common.admin.AbstractCDOAdmin;
import org.eclipse.net4j.channel.IChannelMultiplexer;
import org.eclipse.net4j.connector.IConnector;
import org.eclipse.net4j.util.concurrent.ExecutorServiceFactory;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.lifecycle.ILifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleEventAdapter;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOAdminClientImpl
extends AbstractCDOAdmin
implements CDOAdminClient {
    private static final String URL_SEPARATOR = "://";
    private final String url;
    private final IManagedContainer container;
    private final ExecutorService executorService;
    private boolean connected;
    private ConnectLock connectLock = new ConnectLock();
    private long connectAttempt;
    private CDOAdminClientProtocol protocol;

    public CDOAdminClientImpl(String url, long timeout, IManagedContainer container) {
        super(timeout);
        this.url = url;
        this.container = container;
        this.executorService = ExecutorServiceFactory.get((IManagedContainer)container);
        this.activate();
    }

    @Override
    public final String getURL() {
        return this.url;
    }

    public final IManagedContainer getContainer() {
        return this.container;
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public IConnector getConnector() {
        if (!this.connected) {
            return null;
        }
        IChannelMultiplexer multiplexer = this.protocol.getChannel().getMultiplexer();
        if (multiplexer instanceof IConnector) {
            return (IConnector)multiplexer;
        }
        return null;
    }

    @Override
    public CDOAdminClientRepository[] getRepositories() {
        CDOAdminRepository[] repositories = super.getRepositories();
        CDOAdminClientRepository[] result = new CDOAdminClientRepository[repositories.length];
        int i = 0;
        while (i < repositories.length) {
            result[i] = (CDOAdminClientRepository)repositories[i];
            ++i;
        }
        return result;
    }

    @Override
    public synchronized CDOAdminClientRepository getRepository(String name) {
        return (CDOAdminClientRepository)super.getRepository(name);
    }

    @Override
    public CDOAdminClientRepository createRepository(String name, String type, Map<String, Object> properties) {
        return (CDOAdminClientRepository)super.createRepository(name, type, properties);
    }

    @Override
    public CDOAdminClientRepository waitForRepository(String name) {
        return (CDOAdminClientRepository)super.waitForRepository(name);
    }

    public void repositoryTypeChanged(String name, CDOCommonRepository.Type oldType, CDOCommonRepository.Type newType) {
        CDOAdminClientRepositoryImpl repository = (CDOAdminClientRepositoryImpl)this.getRepository(name);
        if (repository != null) {
            repository.typeChanged(oldType, newType);
        }
    }

    public void repositoryStateChanged(String name, CDOCommonRepository.State oldState, CDOCommonRepository.State newState) {
        CDOAdminClientRepositoryImpl repository = (CDOAdminClientRepositoryImpl)this.getRepository(name);
        if (repository != null) {
            repository.stateChanged(oldState, newState);
        }
    }

    public void repositoryReplicationProgressed(String name, double totalWork, double work) {
        CDOAdminClientRepositoryImpl repository = (CDOAdminClientRepositoryImpl)this.getRepository(name);
        if (repository != null) {
            repository.replicationProgressed(totalWork, work);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CDOAdminClient)) {
            return false;
        }
        CDOAdminClient other = (CDOAdminClient)obj;
        return !(this.url == null ? other.getURL() != null : !this.url.equals(other.getURL()));
    }

    public String toString() {
        return this.url;
    }

    protected boolean doCreateRepository(String name, String type, Map<String, Object> properties) {
        return this.protocol.createRepository(name, type, properties);
    }

    protected boolean doDeleteRepository(String name, String type) {
        return this.protocol.deleteRepository(name, type);
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        this.connect();
    }

    protected void doDeactivate() throws Exception {
        this.setConnected(false);
        this.protocol.close();
        this.protocol = null;
        super.doDeactivate();
    }

    protected void setConnected(final boolean on) {
        this.connected = on;
        if (!on) {
            this.clear();
        }
        this.fireEvent(new CDOAdminClient.ConnectionStateChangedEvent(){

            public CDOAdminClient getSource() {
                return CDOAdminClientImpl.this;
            }

            public boolean isConnected() {
                return on;
            }

            public String toString() {
                return "ConnectionStateChangedEvent[connected=" + on + "]";
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void connect() {
        if (LifecycleUtil.isActive((Object)this.executorService)) {
            ConnectLock connectLock = this.connectLock;
            synchronized (connectLock) {
                this.executorService.submit(new ConnectRunnable());
            }
        }
    }

    private static final class ConnectLock {
        private ConnectLock() {
        }
    }

    protected class ConnectRunnable
    implements Runnable {
        protected ConnectRunnable() {
        }

        private void sleep() throws InterruptedException {
            long now = System.currentTimeMillis();
            if (CDOAdminClientImpl.this.connectAttempt != 0L) {
                long passed = now - CDOAdminClientImpl.this.connectAttempt;
                long timeout = CDOAdminClientImpl.this.getTimeout();
                long sleep = Math.max(timeout - passed, timeout);
                Thread.sleep(sleep);
            }
            CDOAdminClientImpl.this.connectAttempt = now;
        }

        public void run() {
            try {
                this.sleep();
                int pos = CDOAdminClientImpl.this.url.indexOf(CDOAdminClientImpl.URL_SEPARATOR);
                String type = CDOAdminClientImpl.this.url.substring(0, pos);
                String description = CDOAdminClientImpl.this.url.substring(pos + CDOAdminClientImpl.URL_SEPARATOR.length());
                IConnector connector = (IConnector)CDOAdminClientImpl.this.container.getElement("org.eclipse.net4j.connectors", type, description);
                CDOAdminClientImpl.this.protocol = new CDOAdminClientProtocol(CDOAdminClientImpl.this);
                CDOAdminClientImpl.this.protocol.open(connector);
                CDOAdminClientImpl.this.protocol.addListener((IListener)new LifecycleEventAdapter(){

                    protected void onDeactivated(ILifecycle lifecycle) {
                        CDOAdminClientImpl.this.setConnected(false);
                        CDOAdminClientImpl.this.protocol = null;
                        if (CDOAdminClientImpl.this.isActive()) {
                            CDOAdminClientImpl.this.connect();
                        }
                    }
                });
                Set<CDOAdminClientRepository> repositories = CDOAdminClientImpl.this.protocol.queryRepositories();
                for (CDOAdminClientRepository repository : repositories) {
                    CDOAdminClientImpl.this.addElement(repository);
                }
                CDOAdminClientImpl.this.setConnected(true);
            }
            catch (InterruptedException ex) {
                OM.LOG.error((Throwable)ex);
                return;
            }
            catch (Throwable ex) {
                if (CDOAdminClientImpl.this.protocol != null) {
                    LifecycleUtil.deactivate((Object)CDOAdminClientImpl.this.protocol.getChannel());
                    CDOAdminClientImpl.this.protocol = null;
                }
                CDOAdminClientImpl.this.connect();
            }
        }
    }
}

