/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.dawn.ecoretools.diagram.part;

import java.lang.reflect.Field;
import java.util.List;
import org.eclipse.emf.cdo.dawn.preferences.PreferenceConstants;
import org.eclipse.emf.cdo.dawn.ui.wizards.dialogs.CDOResourceNodeSelectionDialog;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecoretools.diagram.part.EcoreCreationWizardPage;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class DawnEcoreCreationWizardPage
extends EcoreCreationWizardPage {
    private final CDOView view;
    private URI semanticModelURI;

    public DawnEcoreCreationWizardPage(String pageName, IStructuredSelection selection, CDOView view) {
        super(pageName, selection);
        this.view = view;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        final Text nameFd = (Text)this.getField("nameFd");
        nameFd.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Text directoryFd = (Text)DawnEcoreCreationWizardPage.this.getField("directoryFd");
                DawnEcoreCreationWizardPage.this.semanticModelURI = URI.createURI((String)(String.valueOf(directoryFd.getText()) + nameFd.getText()));
                DawnEcoreCreationWizardPage.this.setPageComplete(DawnEcoreCreationWizardPage.this.validatePage());
            }
        });
        URI domainModelURI = this.getDomainModelURI();
        this.setModelURI(domainModelURI);
    }

    protected void handleDirectoryChoose() {
        CDOResourceNodeSelectionDialog dialog = new CDOResourceNodeSelectionDialog(this.getShell(), this.view);
        if (dialog.open() == 0) {
            this.semanticModelURI = dialog.getResults();
            if (this.semanticModelURI != null) {
                this.setModelURI(this.semanticModelURI);
                this.loadModelFile();
            }
        }
    }

    private void setModelURI(URI semanticModelURI) {
        Text directoryFd = (Text)this.getField("directoryFd");
        directoryFd.setText(semanticModelURI.toString().replace(semanticModelURI.lastSegment(), ""));
        Text nameFd = (Text)this.getField("nameFd");
        nameFd.setText(semanticModelURI.lastSegment());
    }

    protected void handleModelChoose() {
        CDOResourceNodeSelectionDialog dialog = new CDOResourceNodeSelectionDialog(this.getShell(), this.view, true);
        if (dialog.open() == 0) {
            this.semanticModelURI = dialog.getResults();
            if (this.semanticModelURI != null) {
                Text modelFd = (Text)this.getField("modelFd");
                modelFd.setText(this.semanticModelURI.toString());
                this.loadModelFile();
            }
        }
    }

    protected boolean loadModelFile() {
        if (this.semanticModelURI == null) {
            return false;
        }
        Resource resource = this.getResourceSet().getResource(this.semanticModelURI, true);
        if (resource != null) {
            ComposedAdapterFactory adapterFactory = this.getAdapterFactory();
            TreeViewer viewer = (TreeViewer)this.getField("viewer");
            AdapterFactoryContentProvider adapterContentProvider = new AdapterFactoryContentProvider((AdapterFactory)adapterFactory);
            adapterContentProvider.inputChanged((Viewer)viewer, null, null);
            viewer.setContentProvider((IContentProvider)new EcoreCreationWizardPage.WizardContentProvider((ITreeContentProvider)adapterContentProvider));
            viewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)adapterFactory));
            viewer.setInput((Object)resource.getContents());
            viewer.refresh();
            viewer.setSelection((ISelection)new StructuredSelection((List)resource.getContents()), true);
            return true;
        }
        return false;
    }

    protected ResourceSet getResourceSet() {
        return this.view.getResourceSet();
    }

    private Object getField(String name) {
        Field[] fields = ((Object)((Object)this)).getClass().getSuperclass().getDeclaredFields();
        int i = 0;
        while (i < fields.length) {
            if (name.equals(fields[i].getName())) {
                try {
                    fields[i].setAccessible(true);
                    return fields[i].get((Object)this);
                }
                catch (IllegalAccessException ex) {
                    throw new RuntimeException("IllegalAccessException accessing " + name);
                }
            }
            ++i;
        }
        return null;
    }

    protected boolean validatePage() {
        this.setMessage(null);
        this.setErrorMessage(null);
        if (this.view.hasResource(this.getDomainModelURI().path())) {
            this.setErrorMessage("Resource already exists");
            return false;
        }
        return true;
    }

    public URI getDomainModelURI() {
        if (this.semanticModelURI == null) {
            String authority = PreferenceConstants.getRepositoryName();
            this.semanticModelURI = URI.createURI((String)("cdo://" + authority + "/default.ecore"));
            int i = 2;
            while (i < 30 && this.view.hasResource(this.semanticModelURI.path())) {
                this.semanticModelURI = URI.createURI((String)("cdo://" + authority + "/" + "default" + i + ".ecore"));
                ++i;
            }
        }
        return this.semanticModelURI;
    }

    public URI getDiagramModelURI() {
        return URI.createURI((String)(String.valueOf(this.semanticModelURI.toString()) + "diag"));
    }
}

