/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.dawn.ecoretools.diagram.part;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.cdo.dawn.ecoretools.diagram.part.DawnEcoreDocumentProvider;
import org.eclipse.emf.cdo.dawn.editors.IDawnEditor;
import org.eclipse.emf.cdo.dawn.editors.IDawnEditorSupport;
import org.eclipse.emf.cdo.dawn.gmf.editors.impl.DawnGMFEditorSupport;
import org.eclipse.emf.cdo.dawn.ui.DawnEditorInput;
import org.eclipse.emf.cdo.ui.CDOEditorInput;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.ecoretools.diagram.part.EcoreDiagramEditor;
import org.eclipse.emf.ecoretools.diagram.part.EcoreDiagramEditorPlugin;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.AbstractDocumentProvider;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDocumentProvider;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.net4j.util.transaction.TransactionException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;

public class DawnEcoreDiagramEditor
extends EcoreDiagramEditor
implements IDawnEditor {
    public static String ID = "org.eclipse.emf.cdo.dawn.ecoretools.diagram.part.DawnEcoreDiagramEditor";
    private IDawnEditorSupport dawnEditorSupport;

    public DawnEcoreDiagramEditor() {
        EcoreDiagramEditorPlugin.getInstance().logInfo("CDO Editor ist starting");
        this.setDocumentProvider((IDocumentProvider)new DawnEcoreDocumentProvider());
        this.setDawnEditorSupport((IDawnEditorSupport)new DawnGMFEditorSupport((IDawnEditor)this));
    }

    public void setInput(IEditorInput input) {
        EcoreDiagramEditorPlugin.getInstance().logInfo("Setting input for DawnEcoreDiagramEditor (" + input + ")");
        try {
            this.doSetInput(input, true);
        }
        catch (CoreException x) {
            x.printStackTrace(System.err);
            String title = x.getMessage();
            String msg = x.getMessage();
            Shell shell = this.getSite().getShell();
            ErrorDialog.openError((Shell)shell, (String)title, (String)msg, (IStatus)x.getStatus());
        }
        this.dawnEditorSupport.setView(((DawnEditorInput)input).getView());
    }

    protected void initializeGraphicalViewer() {
        super.initializeGraphicalViewer();
        this.dawnEditorSupport.registerListeners();
    }

    public void doSave(IProgressMonitor monitor) {
        try {
            this.dawnEditorSupport.setDirty(false);
            this.updateState(this.getEditorInput());
            this.validateState(this.getEditorInput());
            this.performSave(false, monitor);
        }
        catch (TransactionException e) {
            if (e.getMessage().contains("conflict")) {
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"conflict", (String)"Your Resource is in conflict and cannot be committed");
            }
            throw e;
        }
    }

    public boolean isDirty() {
        return this.dawnEditorSupport.isDirty();
    }

    public String getContributorID() {
        return ID;
    }

    protected void setDocumentProvider(IEditorInput input) {
        if (input instanceof IFileEditorInput || input instanceof URIEditorInput || input instanceof CDOEditorInput) {
            this.setDocumentProvider(this.getDocumentProvider());
        } else {
            super.setDocumentProvider(input);
        }
    }

    public void dispose() {
        try {
            super.dispose();
        }
        finally {
            this.dawnEditorSupport.close();
        }
    }

    public CDOView getView() {
        return this.dawnEditorSupport.getView();
    }

    public void setDirty() {
        this.dawnEditorSupport.setDirty(true);
        ((AbstractDocumentProvider)this.getDocumentProvider()).changed((Object)this.getEditorInput());
    }

    public void setDawnEditorSupport(IDawnEditorSupport dawnEditorSupport) {
        this.dawnEditorSupport = dawnEditorSupport;
    }

    public IDawnEditorSupport getDawnEditorSupport() {
        return this.dawnEditorSupport;
    }

    protected void updateCache(Object element) throws CoreException {
    }
}

