/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.dawn.examples.acore.diagram.part;

import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.cdo.dawn.examples.acore.ACoreRoot;
import org.eclipse.emf.cdo.dawn.examples.acore.AcorePackage;
import org.eclipse.emf.cdo.dawn.examples.acore.diagram.part.AcoreDiagramEditorPlugin;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;

public class AcoreVisualIDRegistry {
    private static final String DEBUG_KEY = "org.eclipse.emf.cdo.dawn.examples.acore.diagram/debug/visualID";

    public static int getVisualID(View view) {
        if (view instanceof Diagram) {
            if ("Acore".equals(view.getType())) {
                return 1000;
            }
            return -1;
        }
        return AcoreVisualIDRegistry.getVisualID(view.getType());
    }

    public static String getModelID(View view) {
        Diagram diagram = view.getDiagram();
        while (view != diagram) {
            EAnnotation annotation = view.getEAnnotation("Shortcut");
            if (annotation != null) {
                return (String)annotation.getDetails().get((Object)"modelID");
            }
            view = (View)view.eContainer();
        }
        return diagram != null ? diagram.getType() : null;
    }

    public static int getVisualID(String type) {
        try {
            return Integer.parseInt(type);
        }
        catch (NumberFormatException e) {
            if (Boolean.TRUE.toString().equalsIgnoreCase(Platform.getDebugOption((String)DEBUG_KEY))) {
                AcoreDiagramEditorPlugin.getInstance().logError("Unable to parse view type as a visualID number: " + type);
            }
            return -1;
        }
    }

    public static String getType(int visualID) {
        return String.valueOf(visualID);
    }

    public static int getDiagramVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        if (AcorePackage.eINSTANCE.getACoreRoot().isSuperTypeOf(domainElement.eClass()) && AcoreVisualIDRegistry.isDiagram((ACoreRoot)domainElement)) {
            return 1000;
        }
        return -1;
    }

    public static int getNodeVisualID(View containerView, EObject domainElement) {
        int containerVisualID;
        if (domainElement == null) {
            return -1;
        }
        String containerModelID = AcoreVisualIDRegistry.getModelID(containerView);
        if (!"Acore".equals(containerModelID)) {
            return -1;
        }
        if ("Acore".equals(containerModelID)) {
            containerVisualID = AcoreVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 1000;
        } else {
            return -1;
        }
        switch (containerVisualID) {
            case 1000: {
                if (AcorePackage.eINSTANCE.getAInterface().isSuperTypeOf(domainElement.eClass())) {
                    return 2001;
                }
                if (!AcorePackage.eINSTANCE.getAClass().isSuperTypeOf(domainElement.eClass())) break;
                return 2002;
            }
            case 7001: {
                if (!AcorePackage.eINSTANCE.getAAttribute().isSuperTypeOf(domainElement.eClass())) break;
                return 3001;
            }
            case 7002: {
                if (!AcorePackage.eINSTANCE.getAOperation().isSuperTypeOf(domainElement.eClass())) break;
                return 3002;
            }
            case 7003: {
                if (!AcorePackage.eINSTANCE.getAAttribute().isSuperTypeOf(domainElement.eClass())) break;
                return 3003;
            }
            case 7004: {
                if (!AcorePackage.eINSTANCE.getAOperation().isSuperTypeOf(domainElement.eClass())) break;
                return 3004;
            }
        }
        return -1;
    }

    public static boolean canCreateNode(View containerView, int nodeVisualID) {
        int containerVisualID;
        String containerModelID = AcoreVisualIDRegistry.getModelID(containerView);
        if (!"Acore".equals(containerModelID)) {
            return false;
        }
        if ("Acore".equals(containerModelID)) {
            containerVisualID = AcoreVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 1000;
        } else {
            return false;
        }
        switch (containerVisualID) {
            case 1000: {
                if (2001 == nodeVisualID) {
                    return true;
                }
                if (2002 != nodeVisualID) break;
                return true;
            }
            case 2001: {
                if (5001 == nodeVisualID) {
                    return true;
                }
                if (7001 == nodeVisualID) {
                    return true;
                }
                if (7002 != nodeVisualID) break;
                return true;
            }
            case 2002: {
                if (5002 == nodeVisualID) {
                    return true;
                }
                if (7003 == nodeVisualID) {
                    return true;
                }
                if (7004 != nodeVisualID) break;
                return true;
            }
            case 7001: {
                if (3001 != nodeVisualID) break;
                return true;
            }
            case 7002: {
                if (3002 != nodeVisualID) break;
                return true;
            }
            case 7003: {
                if (3003 != nodeVisualID) break;
                return true;
            }
            case 7004: {
                if (3004 != nodeVisualID) break;
                return true;
            }
        }
        return false;
    }

    public static int getLinkWithClassVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        return -1;
    }

    private static boolean isDiagram(ACoreRoot element) {
        return true;
    }
}

