/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.dawn.notifications;

import java.util.HashMap;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.lock.CDOLockState;
import org.eclipse.emf.cdo.common.revision.CDOIDAndBranch;
import org.eclipse.emf.cdo.dawn.editors.IDawnEditor;
import org.eclipse.emf.cdo.dawn.editors.IDawnEditorSupport;
import org.eclipse.emf.cdo.dawn.notifications.BasicDawnListener;
import org.eclipse.emf.cdo.dawn.spi.DawnState;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.cdo.view.CDOViewLocksChangedEvent;

public class BasicDawnLockingHandler
extends BasicDawnListener {
    public BasicDawnLockingHandler(IDawnEditor editor) {
        super(editor);
    }

    public void handleLocksChangedEvent(CDOViewLocksChangedEvent event) {
        CDOViewLocksChangedEvent lockEvent = event;
        CDOLockState[] lockStates = lockEvent.getLockStates();
        HashMap<Object, DawnState> changedObjects = new HashMap<Object, DawnState>();
        CDOLockState[] cDOLockStateArray = lockStates;
        int n = lockStates.length;
        int n2 = 0;
        while (n2 < n) {
            CDOID id;
            CDOLockState state = cDOLockStateArray[n2];
            Object lockedObject = state.getLockedObject();
            CDOView view = this.editor.getDawnEditorSupport().getView();
            if (lockedObject instanceof CDOID) {
                id = (CDOID)lockedObject;
            } else if (lockedObject instanceof CDOIDAndBranch) {
                id = ((CDOIDAndBranch)lockedObject).getID();
            } else {
                throw new RuntimeException("Unexpected object type: " + lockedObject);
            }
            if (id != null) {
                CDOObject object = view.getObject(id);
                if (object.cdoWriteLock().isLocked()) {
                    throw new RuntimeException("Locally locked objects should not occur.");
                }
                if (object.cdoWriteLock().isLockedByOthers()) {
                    changedObjects.put(object, DawnState.LOCKED_REMOTELY);
                } else {
                    changedObjects.put(object, DawnState.CLEAN);
                }
            }
            ++n2;
        }
        IDawnEditorSupport dawnEditorSupport = this.editor.getDawnEditorSupport();
        dawnEditorSupport.handleRemoteLockChanges(changedObjects);
    }
}

