/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.net4j.protocol;

import java.io.IOException;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionHandler;
import org.eclipse.emf.cdo.common.util.CDOCommonUtil;
import org.eclipse.emf.cdo.server.internal.net4j.bundle.OM;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerProtocol;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerReadIndication;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class HandleRevisionsIndication
extends CDOServerReadIndication {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_PROTOCOL, HandleRevisionsIndication.class);
    private EClass eClass;
    private CDOBranch branch;
    private boolean exactBranch;
    private long timeStamp;
    private boolean exactTime;

    public HandleRevisionsIndication(CDOServerProtocol protocol) {
        super(protocol, (short)48);
    }

    protected void indicating(CDODataInput in) throws IOException {
        if (in.readBoolean()) {
            this.eClass = (EClass)in.readCDOClassifierRefAndResolve();
            if (TRACER.isEnabled()) {
                TRACER.format("Read eClass: {0}", new Object[]{this.eClass});
            }
        }
        if (in.readBoolean()) {
            this.branch = in.readCDOBranch();
            if (TRACER.isEnabled()) {
                TRACER.format("Read branch: {0}", new Object[]{this.branch});
            }
            this.exactBranch = in.readBoolean();
            if (TRACER.isEnabled()) {
                TRACER.format("Read exactBranch: {0}", new Object[]{this.exactBranch});
            }
        }
        this.timeStamp = in.readLong();
        if (TRACER.isEnabled()) {
            TRACER.format("Read timeStamp: {0}", new Object[]{CDOCommonUtil.formatTimeStamp((long)this.timeStamp)});
        }
        this.exactTime = in.readBoolean();
        if (TRACER.isEnabled()) {
            TRACER.format("Read exactTime: {0}", new Object[]{this.exactTime});
        }
    }

    protected void responding(final CDODataOutput out) throws IOException {
        final IOException[] ioException = new IOException[1];
        final RuntimeException[] runtimeException = new RuntimeException[1];
        this.getRepository().handleRevisions(this.eClass, this.branch, this.exactBranch, this.timeStamp, this.exactTime, (CDORevisionHandler)new CDORevisionHandler.Filtered.Undetached(new CDORevisionHandler(){

            public boolean handleRevision(CDORevision revision) {
                try {
                    out.writeBoolean(true);
                    out.writeCDORevision(revision, -1);
                    return true;
                }
                catch (IOException ex) {
                    ioException[0] = ex;
                }
                catch (RuntimeException ex) {
                    runtimeException[0] = ex;
                }
                return false;
            }
        }));
        if (ioException[0] != null) {
            throw ioException[0];
        }
        if (runtimeException[0] != null) {
            throw runtimeException[0];
        }
        out.writeBoolean(false);
    }
}

