/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDReference;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.model.CDOClassifierRef;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.model.CDOPackageInfo;
import org.eclipse.emf.cdo.common.model.CDOPackageRegistry;
import org.eclipse.emf.cdo.common.model.CDOPackageUnit;
import org.eclipse.emf.cdo.common.util.CDOQueryInfo;
import org.eclipse.emf.cdo.server.IQueryContext;
import org.eclipse.emf.cdo.server.IQueryHandler;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.IStore;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.IView;
import org.eclipse.emf.cdo.server.StoreThreadLocal;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageRegistry;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.spi.server.QueryHandlerFactory;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.util.factory.ProductCreationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XRefsQueryHandler
implements IQueryHandler {
    @Override
    public void executeQuery(CDOQueryInfo info, IQueryContext context) {
        try {
            IStoreAccessor accessor = StoreThreadLocal.getAccessor();
            QueryContext xrefsContext = new QueryContext(info, context);
            accessor.queryXRefs(xrefsContext);
            IQueryContext branchPoint = context;
            CDOBranch branch = branchPoint.getBranch();
            while (!branch.isMainBranch() && context.getResultCount() < info.getMaxResults()) {
                branchPoint = branch.getBase();
                branch = branchPoint.getBranch();
                xrefsContext.setBranchPoint(branchPoint);
                accessor.queryXRefs(xrefsContext);
            }
        }
        catch (StoreThreadLocal.NoSessionRegisteredException noSessionRegisteredException) {
            // empty catch block
        }
    }

    public static void collectSourceCandidates(IView view, Collection<EClass> concreteTypes, Map<EClass, List<EReference>> sourceCandidates) {
        InternalRepository repository = (InternalRepository)view.getRepository();
        InternalCDOPackageRegistry packageRegistry = repository.getPackageRegistry(false);
        CDOPackageInfo[] cDOPackageInfoArray = packageRegistry.getPackageInfos();
        int n = cDOPackageInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            CDOPackageInfo packageInfo = cDOPackageInfoArray[n2];
            XRefsQueryHandler.collectSourceCandidates(packageInfo, concreteTypes, sourceCandidates);
            ++n2;
        }
    }

    public static void collectSourceCandidates(CDOPackageInfo packageInfo, Collection<EClass> concreteTypes, Map<EClass, List<EReference>> sourceCandidates) {
        CDOPackageUnit.State state = packageInfo.getPackageUnit().getState();
        if (state == CDOPackageUnit.State.LOADED || state == CDOPackageUnit.State.PROXY) {
            EPackage ePackage = packageInfo.getEPackage();
            for (EClassifier eClassifier : ePackage.getEClassifiers()) {
                if (!(eClassifier instanceof EClass)) continue;
                XRefsQueryHandler.collectSourceCandidates((EClass)eClassifier, concreteTypes, sourceCandidates);
            }
        }
    }

    public static void collectSourceCandidates(EClass eClass, Collection<EClass> concreteTypes, Map<EClass, List<EReference>> sourceCandidates) {
        if (!eClass.isAbstract() && !eClass.isInterface()) {
            EReference[] eReferenceArray = CDOModelUtil.getClassInfo((EClass)eClass).getAllPersistentReferences();
            int n = eReferenceArray.length;
            int n2 = 0;
            while (n2 < n) {
                EReference eReference = eReferenceArray[n2];
                XRefsQueryHandler.collectSourceCandidates(eClass, eReference, concreteTypes, sourceCandidates);
                ++n2;
            }
        }
    }

    public static void collectSourceCandidates(EReference eReference, Collection<EClass> concreteTypes, Map<EClass, List<EReference>> sourceCandidates, CDOPackageRegistry packageRegistry) {
        EClass rootClass = eReference.getEContainingClass();
        XRefsQueryHandler.collectSourceCandidates(rootClass, eReference, concreteTypes, sourceCandidates);
        Collection descendentClasses = (Collection)packageRegistry.getSubTypes().get(rootClass);
        if (descendentClasses != null) {
            for (EClass candidateClass : descendentClasses) {
                XRefsQueryHandler.collectSourceCandidates(candidateClass, eReference, concreteTypes, sourceCandidates);
            }
        }
    }

    public static void collectSourceCandidates(EClass eClass, EReference eReference, Collection<EClass> concreteTypes, Map<EClass, List<EReference>> sourceCandidates) {
        if (!(eClass.isAbstract() || eClass.isInterface() || eReference.isContainer() || eReference.isContainment() || !XRefsQueryHandler.canReference(eReference.getEReferenceType(), concreteTypes))) {
            List<EReference> list = sourceCandidates.get(eClass);
            if (list == null) {
                list = new ArrayList<EReference>();
                sourceCandidates.put(eClass, list);
            }
            list.add(eReference);
        }
    }

    private static boolean canReference(EClass declaredType, Collection<EClass> concreteTypes) {
        for (EClass concreteType : concreteTypes) {
            if (!declaredType.isSuperTypeOf(concreteType)) continue;
            return true;
        }
        return false;
    }

    public static class Factory
    extends QueryHandlerFactory {
        public Factory() {
            super("resources");
        }

        public XRefsQueryHandler create(String description) throws ProductCreationException {
            return new XRefsQueryHandler();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class QueryContext
    implements IStoreAccessor.QueryXRefsContext {
        private CDOQueryInfo info;
        private IQueryContext context;
        private CDOBranchPoint branchPoint;
        private Map<CDOID, EClass> targetObjects;
        private Map<EClass, List<EReference>> sourceCandidates;
        private EReference[] sourceReferences;

        public QueryContext(CDOQueryInfo info, IQueryContext context) {
            this.info = info;
            this.context = context;
            this.branchPoint = context;
        }

        public void setBranchPoint(CDOBranchPoint branchPoint) {
            this.branchPoint = branchPoint;
        }

        public CDOBranch getBranch() {
            return this.branchPoint.getBranch();
        }

        public long getTimeStamp() {
            return this.branchPoint.getTimeStamp();
        }

        @Override
        public Map<CDOID, EClass> getTargetObjects() {
            if (this.targetObjects == null) {
                IRepository repository = this.context.getView().getRepository();
                IStore store = repository.getStore();
                CDOPackageRegistry packageRegistry = repository.getPackageRegistry();
                this.targetObjects = CDOIDUtil.createMap();
                StringTokenizer tokenizer = new StringTokenizer(this.info.getQueryString(), "|");
                while (tokenizer.hasMoreTokens()) {
                    CDOClassifierRef classifierRef;
                    String val = tokenizer.nextToken();
                    Object id = val.startsWith("e") ? CDOIDUtil.createExternal((String)val.substring(1)) : store.createObjectID(val.substring(1));
                    if (id instanceof CDOClassifierRef.Provider) {
                        classifierRef = ((CDOClassifierRef.Provider)id).getClassifierRef();
                    } else {
                        val = tokenizer.nextToken();
                        classifierRef = new CDOClassifierRef(val);
                    }
                    EClass eClass = (EClass)classifierRef.resolve((EPackage.Registry)packageRegistry);
                    this.targetObjects.put((CDOID)id, eClass);
                }
            }
            return this.targetObjects;
        }

        @Override
        public EReference[] getSourceReferences() {
            if (this.sourceReferences == null) {
                this.sourceReferences = this.parseSourceReferences();
            }
            return this.sourceReferences;
        }

        private EReference[] parseSourceReferences() {
            ArrayList<EReference> result = new ArrayList<EReference>();
            CDOPackageRegistry packageRegistry = this.context.getView().getRepository().getPackageRegistry();
            String params = (String)this.info.getParameters().get("sourceReferences");
            if (params == null) {
                return new EReference[0];
            }
            StringTokenizer tokenizer = new StringTokenizer(params, "|");
            while (tokenizer.hasMoreTokens()) {
                String className = tokenizer.nextToken();
                CDOClassifierRef classifierRef = new CDOClassifierRef(className);
                EClass eClass = (EClass)classifierRef.resolve((EPackage.Registry)packageRegistry);
                String featureName = tokenizer.nextToken();
                EReference sourceReference = (EReference)eClass.getEStructuralFeature(featureName);
                result.add(sourceReference);
            }
            return result.toArray(new EReference[result.size()]);
        }

        @Override
        public Map<EClass, List<EReference>> getSourceCandidates() {
            if (this.sourceCandidates == null) {
                this.sourceCandidates = new HashMap<EClass, List<EReference>>();
                Collection<EClass> concreteTypes = this.getTargetObjects().values();
                EReference[] sourceReferences = this.getSourceReferences();
                if (sourceReferences.length != 0) {
                    InternalRepository repository = (InternalRepository)this.context.getView().getRepository();
                    InternalCDOPackageRegistry packageRegistry = repository.getPackageRegistry(false);
                    EReference[] eReferenceArray = sourceReferences;
                    int n = sourceReferences.length;
                    int n2 = 0;
                    while (n2 < n) {
                        EReference eReference = eReferenceArray[n2];
                        XRefsQueryHandler.collectSourceCandidates(eReference, concreteTypes, this.sourceCandidates, (CDOPackageRegistry)packageRegistry);
                        ++n2;
                    }
                } else {
                    XRefsQueryHandler.collectSourceCandidates(this.context.getView(), concreteTypes, this.sourceCandidates);
                }
            }
            return this.sourceCandidates;
        }

        @Override
        public int getMaxResults() {
            return this.info.getMaxResults();
        }

        @Override
        public boolean addXRef(CDOID targetID, CDOID sourceID, EReference sourceReference, int sourceIndex) {
            if (CDOIDUtil.isNull((CDOID)targetID)) {
                return true;
            }
            return this.context.addResult(new CDOIDReference(targetID, sourceID, (EStructuralFeature)sourceReference, sourceIndex));
        }
    }
}

