/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.spi.server;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.cdo.internal.server.SessionManager;
import org.eclipse.emf.cdo.internal.server.bundle.OM;
import org.eclipse.emf.cdo.server.CDOServerUtil;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.IRepositoryFactory;
import org.eclipse.emf.cdo.server.IStore;
import org.eclipse.emf.cdo.server.IStoreFactory;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.spi.server.InternalSessionManager;
import org.eclipse.emf.cdo.spi.server.InternalStore;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.om.OMPlatform;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.eclipse.net4j.util.security.IAuthenticator;
import org.eclipse.net4j.util.security.IUserManager;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryConfigurator {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_REPOSITORY, RepositoryConfigurator.class);
    private IManagedContainer container;
    private Map<String, IRepositoryFactory> repositoryFactories = new HashMap<String, IRepositoryFactory>();
    private Map<String, IStoreFactory> storeFactories = new HashMap<String, IStoreFactory>();

    public RepositoryConfigurator() {
        this(null);
    }

    public RepositoryConfigurator(IManagedContainer container) {
        this.container = container;
    }

    public IManagedContainer getContainer() {
        return this.container;
    }

    public Map<String, IRepositoryFactory> getRepositoryFactories() {
        return this.repositoryFactories;
    }

    public Map<String, IStoreFactory> getStoreFactories() {
        return this.storeFactories;
    }

    public IRepository[] configure(File configFile) throws ParserConfigurationException, SAXException, IOException, CoreException {
        if (TRACER.isEnabled()) {
            TRACER.trace("Configuring CDO server from " + configFile.getAbsolutePath());
        }
        ArrayList<IRepository> repositories = new ArrayList<IRepository>();
        Document document = this.getDocument(configFile);
        NodeList elements = document.getElementsByTagName("repository");
        int i = 0;
        while (i < elements.getLength()) {
            Element repositoryConfig = (Element)elements.item(i);
            IRepository repository = this.getRepository(repositoryConfig);
            repositories.add(repository);
            if (this.container != null) {
                CDOServerUtil.addRepository(this.container, repository);
            }
            ++i;
        }
        return repositories.toArray(new IRepository[repositories.size()]);
    }

    protected Document getDocument(File configFile) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(configFile);
    }

    protected IRepositoryFactory getRepositoryFactory(String type) throws CoreException {
        IRepositoryFactory factory = this.repositoryFactories.get(type);
        if (factory == null) {
            factory = (IRepositoryFactory)RepositoryConfigurator.createExecutableExtension("repositoryFactories", "repositoryFactory", "repositoryType", type);
        }
        if (factory == null) {
            throw new IllegalStateException("CDORepositoryInfo factory not found: " + type);
        }
        return factory;
    }

    protected IRepository getRepository(Element repositoryConfig) throws CoreException {
        String repositoryName = repositoryConfig.getAttribute("name");
        if (StringUtil.isEmpty((String)repositoryName)) {
            throw new IllegalArgumentException("CDORepositoryInfo name is missing or empty");
        }
        String repositoryType = repositoryConfig.getAttribute("type");
        if (StringUtil.isEmpty((String)repositoryType)) {
            repositoryType = "default";
        }
        if (TRACER.isEnabled()) {
            TRACER.format("Configuring repository {0} (type={1})", new Object[]{repositoryName, repositoryType});
        }
        Map<String, String> properties = RepositoryConfigurator.getProperties(repositoryConfig, 1);
        Element storeConfig = this.getStoreConfig(repositoryConfig);
        IStore store = this.createStore(repositoryName, properties, storeConfig);
        InternalRepository repository = (InternalRepository)this.getRepository(repositoryType);
        repository.setName(repositoryName);
        repository.setStore((InternalStore)store);
        repository.setProperties(properties);
        this.setUserManager(repository, repositoryConfig);
        this.setAuthenticator(repository, repositoryConfig);
        EPackage[] initialPackages = this.getInitialPackages(repositoryConfig);
        if (initialPackages.length != 0) {
            repository.setInitialPackages(initialPackages);
        }
        return repository;
    }

    protected IRepository getRepository(String repositoryType) throws CoreException {
        IRepositoryFactory factory = this.getRepositoryFactory(repositoryType);
        return factory.createRepository();
    }

    protected Element getUserManagerConfig(Element repositoryConfig) {
        NodeList userManagerConfig = repositoryConfig.getElementsByTagName("userManager");
        if (userManagerConfig.getLength() > 1) {
            String repositoryName = repositoryConfig.getAttribute("name");
            throw new IllegalStateException("At most one user manager must be configured for repository " + repositoryName);
        }
        return (Element)(userManagerConfig.getLength() > 0 ? userManagerConfig.item(0) : null);
    }

    protected IUserManager getUserManager(Element userManagerConfig) throws CoreException {
        String type = userManagerConfig.getAttribute("type");
        String description = userManagerConfig.getAttribute("description");
        return this.getUserManager(type, description);
    }

    protected IUserManager getUserManager(String type, String description) throws CoreException {
        IUserManager userManager = (IUserManager)this.container.getElement("org.eclipse.net4j.userManagers", type, description);
        if (userManager == null) {
            throw new IllegalStateException("UserManager factory not found: " + type);
        }
        return userManager;
    }

    protected void setUserManager(InternalRepository repository, Element repositoryConfig) throws CoreException {
        IUserManager userManager;
        Element userManagerConfig = this.getUserManagerConfig(repositoryConfig);
        if (userManagerConfig != null && (userManager = this.getUserManager(userManagerConfig)) != null) {
            InternalSessionManager sessionManager = repository.getSessionManager();
            if (sessionManager == null) {
                sessionManager = new SessionManager();
                repository.setSessionManager(sessionManager);
            }
            sessionManager.setUserManager(userManager);
        }
    }

    protected Element getAuthenticatorConfig(Element repositoryConfig) {
        NodeList authenticatorConfig = repositoryConfig.getElementsByTagName("authenticator");
        if (authenticatorConfig.getLength() > 1) {
            String repositoryName = repositoryConfig.getAttribute("name");
            throw new IllegalStateException("At most one authenticator must be configured for repository " + repositoryName);
        }
        return (Element)(authenticatorConfig.getLength() > 0 ? authenticatorConfig.item(0) : null);
    }

    protected IAuthenticator getAuthenticator(Element authenticatorConfig) throws CoreException {
        String type = authenticatorConfig.getAttribute("type");
        String description = authenticatorConfig.getAttribute("description");
        return this.getAuthenticator(type, description);
    }

    protected IAuthenticator getAuthenticator(String type, String description) throws CoreException {
        IAuthenticator authenticator = (IAuthenticator)this.container.getElement("org.eclipse.net4j.authenticators", type, description);
        if (authenticator == null) {
            throw new IllegalStateException("Authenticator factory not found: " + type);
        }
        return authenticator;
    }

    protected void setAuthenticator(InternalRepository repository, Element repositoryConfig) throws CoreException {
        IAuthenticator authenticator;
        Element authenticatorConfig = this.getAuthenticatorConfig(repositoryConfig);
        if (authenticatorConfig != null && (authenticator = this.getAuthenticator(authenticatorConfig)) != null) {
            InternalSessionManager sessionManager = repository.getSessionManager();
            if (sessionManager == null) {
                sessionManager = new SessionManager();
                repository.setSessionManager(sessionManager);
            }
            sessionManager.setAuthenticator(authenticator);
        }
    }

    protected EPackage[] getInitialPackages(Element repositoryConfig) {
        ArrayList<EPackage> result = new ArrayList<EPackage>();
        NodeList initialPackagesConfig = repositoryConfig.getElementsByTagName("initialPackage");
        int i = 0;
        while (i < initialPackagesConfig.getLength()) {
            Element initialPackageConfig = (Element)initialPackagesConfig.item(i);
            String nsURI = initialPackageConfig.getAttribute("nsURI");
            if (nsURI == null) {
                throw new IllegalStateException("nsURI missing for initialPackage element");
            }
            EPackage initialPackage = EPackage.Registry.INSTANCE.getEPackage(nsURI);
            if (initialPackage == null) {
                throw new IllegalStateException("Initial package not found in global package registry: " + nsURI);
            }
            result.add(initialPackage);
            ++i;
        }
        return result.toArray(new EPackage[result.size()]);
    }

    protected Element getStoreConfig(Element repositoryConfig) {
        NodeList storeConfigs = repositoryConfig.getElementsByTagName("store");
        if (storeConfigs.getLength() == 0) {
            String repositoryName = repositoryConfig.getAttribute("name");
            throw new IllegalStateException("A store must be configured for repository " + repositoryName);
        }
        return (Element)storeConfigs.item(0);
    }

    protected IStoreFactory getStoreFactory(String type) throws CoreException {
        IStoreFactory factory = this.storeFactories.get(type);
        if (factory == null) {
            factory = (IStoreFactory)RepositoryConfigurator.createExecutableExtension("storeFactories", "storeFactory", "storeType", type);
        }
        if (factory == null) {
            throw new IllegalStateException("Store factory not found: " + type);
        }
        return factory;
    }

    protected IStore createStore(String repositoryName, Map<String, String> repositoryProperties, Element storeConfig) throws CoreException {
        String type = storeConfig.getAttribute("type");
        IStoreFactory storeFactory = this.getStoreFactory(type);
        return storeFactory.createStore(repositoryName, repositoryProperties, storeConfig);
    }

    public static Map<String, String> getProperties(Element element, int levels) {
        HashMap<String, String> properties = new HashMap<String, String>();
        RepositoryConfigurator.collectProperties(element, "", properties, levels);
        return properties;
    }

    private static void collectProperties(Element element, String prefix, Map<String, String> properties, int levels) {
        if ("property".equals(element.getNodeName())) {
            String name = element.getAttribute("name");
            String value = element.getAttribute("value");
            properties.put(String.valueOf(prefix) + name, value);
            prefix = String.valueOf(prefix) + name + ".";
        }
        if (levels > 0) {
            NodeList childNodes = element.getChildNodes();
            int i = 0;
            while (i < childNodes.getLength()) {
                Node childNode = childNodes.item(i);
                if (childNode instanceof Element) {
                    RepositoryConfigurator.collectProperties((Element)childNode, prefix, properties, levels - 1);
                }
                ++i;
            }
        }
    }

    private static <T> T createExecutableExtension(String extPointName, String elementName, String attributeName, String type) throws CoreException {
        if (OMPlatform.INSTANCE.isExtensionRegistryAvailable()) {
            IConfigurationElement[] elements;
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IConfigurationElement[] iConfigurationElementArray = elements = registry.getConfigurationElementsFor("org.eclipse.emf.cdo.server", extPointName);
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                String storeType;
                IConfigurationElement element = iConfigurationElementArray[n2];
                if (ObjectUtil.equals((Object)element.getName(), (Object)elementName) && ObjectUtil.equals((Object)(storeType = element.getAttribute(attributeName)), (Object)type)) {
                    Object result = element.createExecutableExtension("class");
                    return (T)result;
                }
                ++n2;
            }
        }
        return null;
    }
}

