/*
 * Copyright (c) 2007, 2009-2012 Eike Stepper (Berlin, Germany) and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *    Eike Stepper - initial API and implementation
 */
package org.eclipse.emf.cdo.eresource.validation;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource.Diagnostic;
import org.eclipse.emf.ecore.resource.ResourceSet;

/**
 * A sample validator interface for {@link org.eclipse.emf.cdo.eresource.CDOResource}. This doesn't really do anything,
 * and it's not a real EMF artifact. It was generated by the org.eclipse.emf.examples.generator.validator plug-in to
 * illustrate how EMF's code generator can be extended. This can be disabled with -vmargs
 * -Dorg.eclipse.emf.examples.generator.validator=false.
 * 
 * @since 2.0
 */
@Deprecated
public interface CDOResourceValidator
{
  boolean validate();

  boolean validateResourceSet(ResourceSet value);

  boolean validateURI(URI value);

  boolean validateContents(EList<EObject> value);

  boolean validateModified(boolean value);

  boolean validateLoaded(boolean value);

  boolean validateTrackingModification(boolean value);

  boolean validateErrors(EList<Diagnostic> value);

  boolean validateWarnings(EList<Diagnostic> value);

  boolean validateTimeStamp(long value);
}
