/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.filters.impl;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ILog;
import org.eclipse.emf.compare.rcp.extension.AbstractRegistryEventListener;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.filters.IDifferenceFilter;

public class DifferenceFilterExtensionRegistryListener
extends AbstractRegistryEventListener {
    static final String TAG_FILTER_ACTION = "filter";
    static final String ATT_CLASS = "class";
    static final String ATT_LABEL = "label";
    static final String ATT_ACTIVE = "activeByDefault";
    private final IDifferenceFilter.Registry filterRegistry;

    public DifferenceFilterExtensionRegistryListener(String pluginID, String extensionPointID, ILog log, IDifferenceFilter.Registry filterRegistry) {
        super(pluginID, extensionPointID, log);
        this.filterRegistry = filterRegistry;
    }

    protected boolean validateExtensionElement(IConfigurationElement element) {
        boolean valid;
        if (element.getName().equals(TAG_FILTER_ACTION)) {
            if (element.getAttribute(ATT_CLASS) == null) {
                this.logMissingAttribute(element, ATT_CLASS);
                valid = false;
            } else if (element.getAttribute(ATT_LABEL) == null) {
                this.logMissingAttribute(element, ATT_LABEL);
                valid = false;
            } else if (element.getAttribute(ATT_ACTIVE) == null) {
                this.logMissingAttribute(element, ATT_ACTIVE);
                valid = false;
            } else {
                valid = true;
            }
        } else {
            valid = false;
        }
        return valid;
    }

    protected boolean addedValid(IConfigurationElement element) {
        try {
            IDifferenceFilter filter = (IDifferenceFilter)element.createExecutableExtension(ATT_CLASS);
            filter.setLabel(element.getAttribute(ATT_LABEL));
            if (Boolean.valueOf(element.getAttribute(ATT_ACTIVE)).booleanValue()) {
                filter.setDefaultSelected(true);
            } else {
                filter.setDefaultSelected(false);
            }
            IDifferenceFilter previous = this.filterRegistry.add(filter);
            if (previous != null) {
                this.log(2, element, "The filter '" + filter.getClass().getName() + "' is registered twice.");
            }
        }
        catch (CoreException e) {
            this.log(element, e);
            return false;
        }
        return true;
    }

    protected boolean removedValid(IConfigurationElement element) {
        this.filterRegistry.remove(element.getAttribute(ATT_CLASS));
        return true;
    }
}

