/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.ui.viewers;

import org.eclipse.emf.diffmerge.ui.Messages;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class MergeChoicesDialog
extends MessageDialog {
    private final MergeChoiceData _data;
    private final boolean _askAboutChildren;

    public MergeChoicesDialog(Shell parentShell_p, String title_p, MergeChoiceData data_p, boolean askAboutChildren_p) {
        super(parentShell_p, title_p, null, Messages.MergeChoicesDialog_Question, 3, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        this._data = data_p;
        this._askAboutChildren = askAboutChildren_p;
    }

    protected Control createCustomArea(Composite parent_p) {
        Composite result = new Composite(parent_p, 0);
        GridLayout layout = new GridLayout(1, true);
        result.setLayout((Layout)layout);
        Button coverChildrenButton = new Button(result, 32);
        coverChildrenButton.setText(Messages.MergeChoicesDialog_IncludeChildren);
        coverChildrenButton.setSelection(this.getData().getCoverChildren());
        coverChildrenButton.setEnabled(this._askAboutChildren);
        coverChildrenButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                MergeChoicesDialog.this.getData().setCoverChildren(!MergeChoicesDialog.this.getData().getCoverChildren());
            }
        });
        Button incrementalModeButton = new Button(result, 32);
        incrementalModeButton.setText(Messages.MergeChoicesDialog_IncrementalMode);
        incrementalModeButton.setSelection(this.getData().getIncrementalMode());
        incrementalModeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                MergeChoicesDialog.this.getData().setIncrementalMode(!MergeChoicesDialog.this.getData().getIncrementalMode());
            }
        });
        Button showImpactButton = new Button(result, 32);
        showImpactButton.setText(Messages.MergeChoicesDialog_ShowImpact);
        showImpactButton.setSelection(this.getData().getShowImpact());
        showImpactButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                MergeChoicesDialog.this.getData().setShowImpact(!MergeChoicesDialog.this.getData().getShowImpact());
            }
        });
        return result;
    }

    protected MergeChoiceData getData() {
        return this._data;
    }

    public static class MergeChoiceData {
        private boolean _coverChildren;
        private boolean _incrementalMode;
        private boolean _showImpact;

        public MergeChoiceData() {
            this._coverChildren = false;
            this._incrementalMode = false;
            this._showImpact = false;
        }

        public MergeChoiceData(boolean coverChildren_p, boolean incrementalMode_p, boolean showImpact_p) {
            this._coverChildren = coverChildren_p;
            this._incrementalMode = incrementalMode_p;
            this._showImpact = showImpact_p;
        }

        public boolean getCoverChildren() {
            return this._coverChildren;
        }

        public boolean getIncrementalMode() {
            return this._incrementalMode;
        }

        public boolean getShowImpact() {
            return this._showImpact;
        }

        public void setCoverChildren(boolean newValue_p) {
            this._coverChildren = newValue_p;
        }

        public void setIncrementalMode(boolean newValue_p) {
            this._incrementalMode = newValue_p;
        }

        public void setShowImpact(boolean newValue_p) {
            this._showImpact = newValue_p;
        }
    }
}

