/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.common.sdk.ui.internal.wizards;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.facet.common.sdk.ui.internal.Activator;
import org.eclipse.emf.facet.common.sdk.ui.internal.Messages;
import org.eclipse.emf.facet.common.sdk.ui.internal.wizards.NewProjectCreationOperation;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.part.ISetSelectionTarget;

public class NewProjectWizard
extends Wizard
implements INewWizard {
    private static final String NEW_PROJECT_CREATION_PAGE_NAME = "NewProjectCreationPage";
    private IWorkbench workbench;
    private IProject project;
    private String projectName;
    private IPath projectLocation;

    public void init(IWorkbench pWorkbench, IStructuredSelection selection) {
        this.workbench = pWorkbench;
        this.setWindowTitle(Messages.NewProjectWizard_emfFacetProject);
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public void setProjectLocation(IPath projectLocation) {
        this.projectLocation = projectLocation;
    }

    public void addPages() {
        WizardNewProjectCreationPage newProjectCreationPage = new WizardNewProjectCreationPage(NEW_PROJECT_CREATION_PAGE_NAME){

            protected boolean validatePage() {
                NewProjectWizard.this.setProjectLocation(this.getLocationPath());
                String projName = this.getProjectName();
                NewProjectWizard.this.setProjectName(projName);
                if (projName != null && projName.length() > 0) {
                    NewProjectWizard.this.setProject(ResourcesPlugin.getWorkspace().getRoot().getProject(projName));
                }
                return super.validatePage() && NewProjectWizard.this.canFinish();
            }
        };
        newProjectCreationPage.setInitialProjectName(this.projectName);
        newProjectCreationPage.setTitle(Messages.NewProjectWizard_emfFacetProject);
        newProjectCreationPage.setDescription(Messages.NewProjectWizard_emfFacetProject_description);
        this.addPage((IWizardPage)newProjectCreationPage);
    }

    public boolean performFinish() {
        IWorkbenchPage page;
        IWorkbenchPart activePart;
        NewProjectCreationOperation operation = new NewProjectCreationOperation(this.projectLocation, this.project);
        try {
            this.getContainer().run(false, false, (IRunnableWithProgress)operation);
        }
        catch (Exception e) {
            Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
            return false;
        }
        if (this.project != null && (activePart = (page = this.workbench.getActiveWorkbenchWindow().getActivePage()).getActivePart()) instanceof ISetSelectionTarget) {
            StructuredSelection targetSelection = new StructuredSelection((Object)this.project);
            this.getShell().getDisplay().asyncExec(new Runnable((ISelection)targetSelection){
                private final /* synthetic */ ISelection val$targetSelection;
                {
                    this.val$targetSelection = iSelection;
                }

                public void run() {
                    ((ISetSelectionTarget)activePart).selectReveal(this.val$targetSelection);
                }
            });
        }
        return true;
    }

    public boolean canFinish() {
        return this.projectName != null && this.projectName.length() > 0 && this.project != null && !this.project.exists();
    }
}

