/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.custom.sdk.core.internal;

import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.facet.custom.metamodel.v0_2_0.custom.Customization;
import org.eclipse.emf.facet.custom.sdk.core.ICustomizationActions;
import org.eclipse.emf.facet.custom.sdk.core.internal.Activator;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.emf.facet.util.core.internal.BuildPropertiesUtils;
import org.eclipse.emf.facet.util.emf.core.ICatalogSetManager2;
import org.eclipse.emf.facet.util.emf.core.ICatalogSetManagerFactory;
import org.eclipse.emf.facet.util.emf.core.exception.InvalidFacetSetException;

public class CustomizationActionsImpl
implements ICustomizationActions {
    public void saveCustomization(Customization customization, IFile file) throws IOException, InvalidFacetSetException {
        if (customization == null) {
            throw new IllegalArgumentException("The given customization cannot be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("The given file cannot be null");
        }
        if (file.exists()) {
            throw new IllegalArgumentException("The given file already exists");
        }
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        URI fileURI = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
        Resource resource = resourceSet.createResource(fileURI);
        resource.getContents().add((Object)customization);
        resource.save(null);
        try {
            BuildPropertiesUtils.addToBuild((IFile)file);
        }
        catch (Exception e) {
            Logger.logError((Throwable)e, (String)("Error adding file " + file.getFullPath() + " to the build.properties"), (Plugin)Activator.getDefault());
        }
        ICatalogSetManager2 catalogSetManager = ICatalogSetManagerFactory.DEFAULT.createICatalogSetManager((ResourceSet)resourceSet);
        catalogSetManager.registerModelDeclaration(file);
    }
}

