/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.infra.query.core.internal.validation;

import java.util.Iterator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.facet.infra.query.Messages;
import org.eclipse.emf.facet.infra.query.ModelQuery;
import org.eclipse.emf.facet.infra.query.core.internal.Activator;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.osgi.util.NLS;

public class ReturnTypeValidation
extends AbstractModelConstraint {
    public IStatus validate(IValidationContext ctx) {
        EObject eObject = ctx.getTarget();
        EMFEventType eType = ctx.getEventType();
        try {
            IStatus result = null;
            if (eType == EMFEventType.NULL) {
                ModelQuery modelQuery = (ModelQuery)eObject;
                EClassifier returnType = modelQuery.getReturnType();
                if (returnType == null) {
                    return ctx.createFailureStatus(new Object[]{Messages.ReturnTypeValidation_noReturnType});
                }
                EPackage returnTypePackage = returnType.getEPackage();
                String returnTypePackageNsURI = returnTypePackage.getNsURI();
                boolean found = returnTypePackageNsURI.equals(EcorePackage.eINSTANCE.getNsURI());
                Iterator ePackages = modelQuery.getModelQuerySet().getAssociatedMetamodels().iterator();
                while (!found && ePackages.hasNext()) {
                    EPackage ePackage = (EPackage)ePackages.next();
                    if (!ePackage.getEClassifiers().contains((Object)returnType)) continue;
                    found = true;
                }
                result = found ? ctx.createSuccessStatus() : ctx.createFailureStatus(new Object[]{NLS.bind((String)Messages.ReturnTypeValidation_wrongReturnType, (Object)returnType.getName())});
            } else {
                result = ctx.createSuccessStatus();
            }
            return result;
        }
        catch (NullPointerException e) {
            Status status = new Status(2, "org.eclipse.emf.facet.infra.query.core", String.valueOf(Messages.ReturnTypeValidation_0) + eObject.eResource().getURI().toString(), (Throwable)e);
            Activator.getDefault().getLog().log((IStatus)status);
            return ctx.createSuccessStatus();
        }
    }
}

