/**
 * Copyright (c) 2010 CEA LIST.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Gregoire Dupe (Mia-Software) - Bug 340571 - To be able have more than one localCustomization
 *   Gregoire Dupe (Mia-Software) - Bug 340572 - Wrong multiplicity in TableInstance.facets
 */
package org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.facet.infra.browser.custom.MetamodelView;
import org.eclipse.emf.facet.infra.facet.Facet;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.TableInstanceImpl;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.TableInstance2;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.Tableinstance2Package;

/**
 * <!-- begin-user-doc --> An implementation of the model object '
 * <em><b>Table Instance2</b></em>'. <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 * <li>
 * {@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.impl.TableInstance2Impl#getLocalCustomizations
 * <em>Local Customizations</em>}</li>
 * <li>
 * {@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.impl.TableInstance2Impl#getFacets2
 * <em>Facets2</em>}</li>
 * </ul>
 * </p>
 * 
 * @generated
 * @deprecated https://bugs.eclipse.org/bugs/show_bug.cgi?id=374120
 */
@Deprecated
public class TableInstance2Impl extends TableInstanceImpl implements TableInstance2 {
	/**
	 * The cached value of the '{@link #getLocalCustomizations() <em>Local Customizations</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLocalCustomizations()
	 * @generated
	 * @ordered
	 */
	protected EList<MetamodelView> localCustomizations;

	/**
	 * The cached value of the '{@link #getFacets2() <em>Facets2</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getFacets2()
	 * @generated
	 * @ordered
	 */
	protected EList<Facet> facets2;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TableInstance2Impl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return Tableinstance2Package.Literals.TABLE_INSTANCE2;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<MetamodelView> getLocalCustomizations() {
		if (localCustomizations == null) {
			localCustomizations = new EObjectContainmentEList<MetamodelView>(MetamodelView.class, this, Tableinstance2Package.TABLE_INSTANCE2__LOCAL_CUSTOMIZATIONS);
		}
		return localCustomizations;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Facet> getFacets2() {
		if (facets2 == null) {
			facets2 = new EObjectResolvingEList<Facet>(Facet.class, this, Tableinstance2Package.TABLE_INSTANCE2__FACETS2);
		}
		return facets2;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(final InternalEObject otherEnd, final int featureID, final NotificationChain msgs) {
		switch (featureID) {
			case Tableinstance2Package.TABLE_INSTANCE2__LOCAL_CUSTOMIZATIONS:
				return ((InternalEList<?>)getLocalCustomizations()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(final int featureID, final boolean resolve, final boolean coreType) {
		switch (featureID) {
			case Tableinstance2Package.TABLE_INSTANCE2__LOCAL_CUSTOMIZATIONS:
				return getLocalCustomizations();
			case Tableinstance2Package.TABLE_INSTANCE2__FACETS2:
				return getFacets2();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(final int featureID, final Object newValue) {
		switch (featureID) {
			case Tableinstance2Package.TABLE_INSTANCE2__LOCAL_CUSTOMIZATIONS:
				getLocalCustomizations().clear();
				getLocalCustomizations().addAll((Collection<? extends MetamodelView>)newValue);
				return;
			case Tableinstance2Package.TABLE_INSTANCE2__FACETS2:
				getFacets2().clear();
				getFacets2().addAll((Collection<? extends Facet>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(final int featureID) {
		switch (featureID) {
			case Tableinstance2Package.TABLE_INSTANCE2__LOCAL_CUSTOMIZATIONS:
				getLocalCustomizations().clear();
				return;
			case Tableinstance2Package.TABLE_INSTANCE2__FACETS2:
				getFacets2().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(final int featureID) {
		switch (featureID) {
			case Tableinstance2Package.TABLE_INSTANCE2__LOCAL_CUSTOMIZATIONS:
				return localCustomizations != null && !localCustomizations.isEmpty();
			case Tableinstance2Package.TABLE_INSTANCE2__FACETS2:
				return facets2 != null && !facets2.isEmpty();
		}
		return super.eIsSet(featureID);
	}

} //TableInstance2Impl
