/*******************************************************************************
 * Copyright (c) 2012 Mia-Software.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Gregoire Dupe (Mia-Software) - Bug 352485 - [Table] Default height of cells is too small, leading to text truncations
 *    Fabien Treguer (Soft-Maint) - Bug 422829 - [Table] Row height too small when Windows dpi settings are increased
 *******************************************************************************/
package org.eclipse.emf.facet.widgets.table.ui.nattable.internal;

import org.eclipse.emf.facet.util.core.DebugUtils;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;

public final class DefaultSizeUtils {

	private static final boolean DEBUG = DebugUtils.getDebugStatus(Activator.getDefault());

	private static final int DEFAULT_WIDTH = 100;
	private static final int WIDTH_MARGIN = 0;
	
	private static final int DEFAULT_HEIGHT = 20;
	private static final int HEIGHT_MARGIN = 4;

	private static final int DEFAULT_HEADER_WIDTH = 20;
	private static final int DEFAULT_HEADER_WIDTH_PER_DIGIT = 8;
	private static final int HEADER_WIDTH_MARGIN = 4;
	
	private static final int DEFAULT_DPI = 96;
	
	private DefaultSizeUtils() {
		// Must not be used.
	}
	

	public static int getDefaultCellHeight() {
		return getCellHeight(-1);
	}

	public static int getCellHeight(final int storedHeight) {
		int height;
		if (storedHeight == -1) {
			height = (int) (DEFAULT_HEIGHT * getRatio()) + HEIGHT_MARGIN;
		} else {
			height = (int) ((int) (Math.max(1, storedHeight) - HEIGHT_MARGIN) * getRatio() + HEIGHT_MARGIN);
		}
		if (DefaultSizeUtils.DEBUG) {
			System.out.println(DefaultSizeUtils.class.getName() + ".getDefaultCellHeight: height=" + height); //$NON-NLS-1$
		}
		return height;
	}

	public static int getDefaultCellWidth() {
		return getCellWidth(-1);
	}
	
	public static int getCellWidth(final int storedWidth) {
		int width;
		if (storedWidth == -1) {
			width = (int) (DEFAULT_WIDTH * getRatio()) + DefaultSizeUtils.WIDTH_MARGIN;
		} else {
			width = (int) ((int) (Math.max(1, storedWidth) - WIDTH_MARGIN) * getRatio() + WIDTH_MARGIN);
		}
		if (DefaultSizeUtils.DEBUG) {
			System.out.println(DefaultSizeUtils.class.getName() + ".getDefaultCellWidth: " + width); //$NON-NLS-1$
		}
		return width;
	}

	public static int getDefaultRowHeaderWidth() {
		int width = (int) (DEFAULT_HEADER_WIDTH * getRatio()) + DefaultSizeUtils.HEADER_WIDTH_MARGIN;
		if (DefaultSizeUtils.DEBUG) {
			System.out.println(DefaultSizeUtils.class.getName() + ".getDefaultRowHeaderWidth: " + width); //$NON-NLS-1$
		}
		return width;
	}
	
	public static int getRowHeaderWidth(final int rowCount) {
		int width = (int) (Math.max(20, DEFAULT_HEADER_WIDTH_PER_DIGIT * String.valueOf(rowCount).length()) * getRatio()) + DefaultSizeUtils.HEADER_WIDTH_MARGIN;
		if (DefaultSizeUtils.DEBUG) {
			System.out.println(DefaultSizeUtils.class.getName() + ".getRowHeaderWidth: " + width); //$NON-NLS-1$
		}
		return width;
	}

	public static Font getHeaderFont() {
		FontData[] fd = Display.getDefault().getSystemFont().getFontData().clone();
		fd[0].setStyle(SWT.BOLD);
		// FIXME cache font
		Font headerFont = new Font(Display.getDefault(), fd);
		return headerFont;
	}
	
	private static double getRatio() {
		int dpiX = Display.getDefault().getDPI().x;
		int dpiY = Display.getDefault().getDPI().y;
		if (DefaultSizeUtils.DEBUG) {
			System.out.println(DefaultSizeUtils.class.getName() + ".getDefaultCellHeight: dpi x=" + dpiX); //$NON-NLS-1$
			System.out.println(DefaultSizeUtils.class.getName() + ".getDefaultCellHeight: dpi y=" + dpiY); //$NON-NLS-1$
		}
		return ((double) dpiY) / DefaultSizeUtils.DEFAULT_DPI;
	}
}
