/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.table.ui.workbench.internal.view;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.runtime.ETypedElementResult;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.NavigationTable;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Table;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.tableconfiguration.TableConfiguration;
import org.eclipse.emf.facet.widgets.table.ui.TableUtils;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.ITableWidget;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.ITableWidgetFactory;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.ITableWidgetProvider;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.TableWidgetUtils;
import org.eclipse.emf.facet.widgets.table.ui.workbench.internal.Activator;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableView
extends ViewPart
implements IEditingDomainProvider,
ISelectionProvider,
ISelectionChangedListener {
    public static final String VIEW_ID = "org.eclipse.emf.facet.widgets.table.ui.workbench.view.TableView";
    private final Collection<ISelectionChangedListener> selectionChangedListeners = new ArrayList<ISelectionChangedListener>();
    private ITableWidget tableWidget;
    private EditingDomain editingDomain;
    private Composite partControlParent;
    private MenuManager menuMgr;
    private static int secondaryID = 0;

    public static void openOn(List<EObject> elements, EditingDomain editingDomain, String description, TableConfiguration configuration, EObject context, Object parameter) {
        Table tableInstance = TableUtils.createTableInstance(elements, (String)description, (TableConfiguration)configuration, (EObject)context, (Object)parameter);
        TableView.openOn(tableInstance, editingDomain);
    }

    public static void openOnQueryResult(List<ETypedElementResult> result, EditingDomain editingDomain, TableConfiguration configuration, EObject context, Object parameter) {
        NavigationTable table = TableWidgetUtils.createQueryTableInstance(result, (TableConfiguration)configuration, (EObject)context, (Object)parameter);
        TableView.openOn((Table)table, editingDomain);
    }

    private static void openOn(Table tableInstance, EditingDomain editingDomain) {
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            IViewPart viewPart = activePage.showView(VIEW_ID, Integer.toString(secondaryID++), 1);
            if (viewPart instanceof TableView) {
                TableView natTableView = (TableView)viewPart;
                natTableView.setEditingDomain(editingDomain);
                natTableView.setInput(tableInstance);
            }
        }
        catch (PartInitException e) {
            Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
        }
    }

    private void setInput(Table tableInstance) {
        if (this.tableWidget != null) {
            this.tableWidget.getComposite().dispose();
        }
        this.tableWidget = ITableWidgetFactory.INSTANCE.createTableWidget(this.partControlParent, (IEditingDomainProvider)this, tableInstance, this.menuMgr);
        this.tableWidget.addSelectionChangedListener((ISelectionChangedListener)this);
        this.partControlParent.layout();
    }

    public void createPartControl(Composite parent) {
        this.partControlParent = parent;
        this.menuMgr = new MenuManager("#PopUp", VIEW_ID);
        this.menuMgr.add((IContributionItem)new GroupMarker("additions"));
        this.menuMgr.setRemoveAllWhenShown(true);
        this.setInput(null);
        this.getSite().registerContextMenu(this.menuMgr, (ISelectionProvider)this);
        parent.setLayout((Layout)new FillLayout());
        this.getSite().setSelectionProvider((ISelectionProvider)this);
        parent.layout();
    }

    public void setFocus() {
        if (this.tableWidget != null && !this.tableWidget.getComposite().isDisposed()) {
            this.tableWidget.getComposite().setFocus();
        }
    }

    public Object getAdapter(Class adapter) {
        ITableWidgetProvider result = null;
        if (adapter == ITableWidgetProvider.class) {
            result = new ITableWidgetProvider(){

                public ITableWidget getTableWidget() {
                    return TableView.this.getTableWidget();
                }
            };
        }
        return result;
    }

    protected ITableWidget getTableWidget() {
        return this.tableWidget;
    }

    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    protected void setEditingDomain(EditingDomain editingDomain) {
        this.editingDomain = editingDomain;
    }

    public IWorkbenchPart getPart() {
        return this;
    }

    public final void addSelectionChangedListener(ISelectionChangedListener listener) {
        if (!this.selectionChangedListeners.contains(listener)) {
            this.selectionChangedListeners.add(listener);
        }
    }

    public final void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove(listener);
    }

    public ISelection getSelection() {
        return this.tableWidget.getSelection();
    }

    public void setSelection(ISelection selection) {
        this.tableWidget.setSelection(selection);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ArrayList<ISelectionChangedListener> listeners = new ArrayList<ISelectionChangedListener>(this.selectionChangedListeners);
        for (ISelectionChangedListener listener : listeners) {
            listener.selectionChanged(event);
        }
    }
}

