/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tooling.runtime.impl.ocl.tracker.activeocl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.tooling.runtime.impl.ocl.tracker.activeocl.ActiveOclEvaluatorImpl;
import org.eclipse.gmf.tooling.runtime.impl.ocl.tracker.activeocl.ContextData;
import org.eclipse.gmf.tooling.runtime.impl.ocl.tracker.activeocl.SimpleDependencyCollector;
import org.eclipse.gmf.tooling.runtime.ocl.tracker.OclTracker;
import org.eclipse.gmf.tooling.runtime.ocl.tracker.OclTrackerBase;
import org.eclipse.ocl.ParserException;

class ActiveOclTracker
extends OclTrackerBase {
    private NotificationListener myListener;
    private SimpleDependencyCollector myDependecyCollector;
    private List<EObject> myParserElements;
    private OclTracker.Registrator myRegistrator;
    private Object myValue;
    private boolean myValueInitialized = false;
    private final boolean myCached;

    public ActiveOclTracker(String expressionBody, boolean cached) {
        super(expressionBody);
        this.myCached = cached;
        this.myDependecyCollector = new SimpleDependencyCollector();
    }

    public void installListeners(TransactionalEditingDomain domain, NotificationListener listener, OclTracker.Registrator registrator) {
        this.myListener = listener;
        this.myRegistrator = registrator;
        this.registerListeners();
    }

    public void uninstallListeners() {
        this.unregisterListeners();
    }

    private void registerListeners() {
        if (this.myRegistrator == null) {
            return;
        }
        this.myParserElements = new ArrayList<EObject>(this.myDependecyCollector.getContext2Data().keySet());
        int i = 0;
        while (i < this.myParserElements.size()) {
            this.myRegistrator.registerListener("ActiveOclTracker#SemanticModel" + i, this.myListener, this.myParserElements.get(i));
            ++i;
        }
    }

    private void unregisterListeners() {
        if (this.myParserElements == null) {
            return;
        }
        int i = 0;
        while (i < this.myParserElements.size()) {
            this.myRegistrator.unregisterListener("ActiveOclTracker#SemanticModel" + i);
            ++i;
        }
    }

    public Object getValue() {
        if (!this.myValueInitialized || !this.isCached()) {
            this.doInitialize();
        }
        return this.myValue;
    }

    public boolean handleNotification(Notification notification) {
        boolean affected;
        ContextData contextData = (ContextData)this.myDependecyCollector.getContext2Data().get(notification.getNotifier());
        boolean bl = affected = contextData != null && contextData.getFeatures().contains(notification.getFeature());
        if (affected) {
            this.doInitialize();
        }
        return affected;
    }

    protected void doInitialize() {
        this.unregisterListeners();
        this.myDependecyCollector.clear();
        try {
            this.myValue = new ActiveOclEvaluatorImpl().evaluate(this.getContext(), this.getExpressionBody(), this.myDependecyCollector);
        }
        catch (ParserException e) {
            throw new RuntimeException(e);
        }
        this.registerListeners();
    }

    private boolean isCached() {
        return this.myCached;
    }
}

