/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.examples.common.navigator;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.graphiti.ui.editor.DiagramEditorInput;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.navigator.ILinkHelper;
import org.eclipse.ui.part.FileEditorInput;

public class EditorLinkHelper
implements ILinkHelper {
    public IStructuredSelection findSelection(IEditorInput editorInput) {
        DiagramEditorInput diagramEditorInput;
        IFile file;
        if (editorInput instanceof DiagramEditorInput && editorInput.exists() && (file = this.getFile((diagramEditorInput = (DiagramEditorInput)editorInput).getUri())) != null) {
            return new StructuredSelection((Object)file);
        }
        return StructuredSelection.EMPTY;
    }

    public void activateEditor(IWorkbenchPage aPage, IStructuredSelection aSelection) {
        if (aSelection == null || aSelection.isEmpty()) {
            return;
        }
        if (aSelection.getFirstElement() instanceof IFile) {
            FileEditorInput fileInput = new FileEditorInput((IFile)aSelection.getFirstElement());
            IEditorPart editor = null;
            editor = aPage.findEditor((IEditorInput)fileInput);
            if (editor != null) {
                aPage.bringToTop((IWorkbenchPart)editor);
            }
        }
    }

    private IFile getFile(URI uri) {
        if (uri == null) {
            return null;
        }
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        String filePath = this.getWorkspaceFilePath(uri.trimFragment());
        if (filePath == null) {
            IPath location = Path.fromOSString((String)uri.toString());
            IFile file = workspaceRoot.getFileForLocation(location);
            if (file != null) {
                return file;
            }
            return null;
        }
        IResource workspaceResource = workspaceRoot.findMember(filePath);
        return (IFile)workspaceResource;
    }

    private String getWorkspaceFilePath(URI uri) {
        if (uri.isPlatform()) {
            return uri.toPlatformString(true);
        }
        return null;
    }
}

