/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.services.impl;

import java.util.Collection;
import org.eclipse.graphiti.ui.internal.GraphitiUIPlugin;
import org.eclipse.graphiti.ui.internal.platform.ExtensionManager;
import org.eclipse.graphiti.ui.platform.IImageProvider;
import org.eclipse.graphiti.ui.services.IImageService;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ImageService
implements IImageService {
    public ImageDescriptor getImageDescriptorForId(String providerId, String imageId) {
        if (imageId == null || providerId == null) {
            return null;
        }
        String registryKey = this.makeKey(providerId, imageId);
        ImageRegistry imageRegistry = GraphitiUIPlugin.getDefault().getImageRegistry();
        ImageDescriptor imageDescriptor = imageRegistry.getDescriptor(registryKey);
        if (imageDescriptor != null) {
            return imageDescriptor;
        }
        imageDescriptor = this.createImageDescriptorForId(providerId, imageId);
        return imageDescriptor;
    }

    public Image getImageForId(String providerId, String imageId) {
        if (imageId == null || providerId == null) {
            return null;
        }
        String registryKey = this.makeKey(providerId, imageId);
        ImageRegistry imageRegistry = GraphitiUIPlugin.getDefault().getImageRegistry();
        Image result = imageRegistry.get(registryKey);
        if (result != null && !result.isDisposed()) {
            return result;
        }
        this.createImageDescriptorForId(providerId, imageId);
        Image image = imageRegistry.get(registryKey);
        if (image == null) {
            throw new IllegalStateException("No image could be retrieved for imageId '" + imageId + "'");
        }
        return image;
    }

    public void removeImageFromRegistry(String key) {
        ImageRegistry imageRegistry = GraphitiUIPlugin.getDefault().getImageRegistry();
        imageRegistry.remove(key);
    }

    public ImageDescriptor getPlatformImageDescriptorForId(String imageId) {
        if (imageId == null) {
            return null;
        }
        String registryKey = this.makePlatformKey(imageId);
        ImageRegistry imageRegistry = GraphitiUIPlugin.getDefault().getImageRegistry();
        ImageDescriptor imageDescriptor = imageRegistry.getDescriptor(registryKey);
        if (imageDescriptor != null) {
            return imageDescriptor;
        }
        imageDescriptor = this.createPlatformImageDescriptorForId(imageId);
        return imageDescriptor;
    }

    public Image getPlatformImageForId(String imageId) {
        if (imageId == null) {
            return null;
        }
        String registryKey = this.makePlatformKey(imageId);
        ImageRegistry imageRegistry = GraphitiUIPlugin.getDefault().getImageRegistry();
        Image result = imageRegistry.get(registryKey);
        if (result != null && !result.isDisposed()) {
            return result;
        }
        this.createPlatformImageDescriptorForId(imageId);
        Image image = imageRegistry.get(registryKey);
        if (image == null) {
            throw new IllegalStateException("No image could be retrieved for imageId '" + imageId + "'");
        }
        return image;
    }

    private ImageDescriptor fixImageDescriptor(ImageDescriptor descriptor) {
        ImageData data = descriptor.getImageData();
        return ImageDescriptor.createFromImageData((ImageData)data);
    }

    private ImageDescriptor createImageDescriptorForId(String providerId, String imageId) {
        if (imageId == null || providerId == null) {
            return null;
        }
        String registryKey = this.makeKey(providerId, imageId);
        ImageRegistry imageRegistry = GraphitiUIPlugin.getDefault().getImageRegistry();
        ImageDescriptor imageDescriptor = imageRegistry.getDescriptor(registryKey);
        if (imageDescriptor != null) {
            return imageDescriptor;
        }
        Collection<IImageProvider> imageProviders = ExtensionManager.getSingleton().getImageProvidersForDiagramTypeProviderId(providerId);
        for (IImageProvider imageProvider : imageProviders) {
            String imageFilePath = imageProvider.getImageFilePath(imageId);
            if (imageFilePath == null) continue;
            String pluginId = imageProvider.getPluginId();
            if (pluginId == null) break;
            imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)pluginId, (String)imageFilePath);
            break;
        }
        if (imageDescriptor == null) {
            imageDescriptor = ImageDescriptor.getMissingImageDescriptor();
        }
        imageDescriptor = this.fixImageDescriptor(imageDescriptor);
        imageRegistry.put(registryKey, imageDescriptor);
        return imageDescriptor;
    }

    private ImageDescriptor createPlatformImageDescriptorForId(String imageId) {
        String pluginId;
        if (imageId == null) {
            return null;
        }
        String registryKey = this.makePlatformKey(imageId);
        ImageRegistry imageRegistry = GraphitiUIPlugin.getDefault().getImageRegistry();
        ImageDescriptor imageDescriptor = imageRegistry.getDescriptor(registryKey);
        if (imageDescriptor != null) {
            return imageDescriptor;
        }
        IImageProvider platformImageProvider = ExtensionManager.getSingleton().getPlatformImageProvider();
        String imageFilePath = platformImageProvider.getImageFilePath(imageId);
        if (imageFilePath != null && (pluginId = platformImageProvider.getPluginId()) != null) {
            imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)pluginId, (String)imageFilePath);
        }
        if (imageDescriptor == null) {
            imageDescriptor = ImageDescriptor.getMissingImageDescriptor();
        }
        imageDescriptor = this.fixImageDescriptor(imageDescriptor);
        imageRegistry.put(registryKey, imageDescriptor);
        return imageDescriptor;
    }

    private String makeKey(String dtp, String imageId) {
        return String.valueOf(dtp) + "||" + imageId;
    }

    private String makePlatformKey(String imageId) {
        return this.makeKey("org.eclipse.graphiti.ui.platform.PlatformImageProvider", imageId);
    }
}

