/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.cloud.internal.locking;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gyrex.cloud.internal.CloudDebug;
import org.eclipse.gyrex.cloud.internal.CloudState;
import org.eclipse.gyrex.cloud.internal.NodeInfo;
import org.eclipse.gyrex.cloud.internal.locking.LockAcquirationFailedException;
import org.eclipse.gyrex.cloud.internal.zk.ZooKeeperGate;
import org.eclipse.gyrex.cloud.internal.zk.ZooKeeperGateCallable;
import org.eclipse.gyrex.cloud.internal.zk.ZooKeeperMonitor;
import org.eclipse.gyrex.cloud.services.locking.IDistributedLock;
import org.eclipse.gyrex.cloud.services.locking.ILockMonitor;
import org.eclipse.gyrex.cloud.services.zookeeper.ZooKeeperBasedService;
import org.eclipse.gyrex.common.identifiers.IdHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ZooKeeperLock<T extends IDistributedLock>
extends ZooKeeperBasedService
implements IDistributedLock {
    private static final String SEPARATOR = "__";
    private static final String LOCK_NAME_PREFIX = "lock-";
    private static final Logger LOG = LoggerFactory.getLogger(ZooKeeperLock.class);
    final ZooKeeperMonitor killMonitor = new ZooKeeperMonitor(){

        @Override
        protected void pathDeleted(String path) {
            if (!ZooKeeperLock.this.isActiveLock() || ZooKeeperLock.this.isClosed()) {
                return;
            }
            LOG.warn("Lock {} has been deleted on the lock server!", (Object)ZooKeeperLock.this.getId());
            ZooKeeperLock.this.killLock(KillReason.LOCK_DELETED);
        }

        @Override
        protected void recordChanged(String path) {
            if (!ZooKeeperLock.this.isActiveLock() || ZooKeeperLock.this.isClosed()) {
                return;
            }
            LOG.warn("Lock {} has been stolen!", (Object)ZooKeeperLock.this.getId());
            ZooKeeperLock.this.killLock(KillReason.LOCK_STOLEN);
        }
    };
    final String lockId;
    final IPath lockNodePath;
    final String lockNodeContent;
    final boolean ephemeral;
    final boolean recoverable;
    private final ILockMonitor<T> lockMonitor;
    private final AtomicBoolean suspended = new AtomicBoolean(false);
    volatile String myLockName;
    volatile String myRecoveryKey;
    volatile String activeLockName;

    public static String createRecoveryKey(String lockName, String nodeContent) {
        return lockName.concat(SEPARATOR).concat(nodeContent);
    }

    public static String[] extractRecoveryKeyDetails(String recoveryKey) {
        String[] keySegments = StringUtils.splitByWholeSeparator((String)recoveryKey, (String)SEPARATOR);
        if (keySegments.length < 2) {
            throw new IllegalArgumentException("invalid recovery key format");
        }
        String lockName = keySegments[0];
        String nodeContent = StringUtils.removeStart((String)recoveryKey, (String)lockName.concat(SEPARATOR));
        if (StringUtils.isBlank((String)lockName) || StringUtils.isBlank((String)nodeContent)) {
            throw new IllegalArgumentException("invalid recovery key format");
        }
        return new String[]{lockName, nodeContent};
    }

    private static int getSequenceNumber(String nodeName) {
        return NumberUtils.toInt((String)StringUtils.removeStart((String)nodeName, (String)LOCK_NAME_PREFIX), (int)-1);
    }

    public ZooKeeperLock(String lockId, ILockMonitor<T> lockMonitor, IPath lockNodeParentPath, boolean ephemeral, boolean recovarable) {
        super(200L, 5);
        if (!IdHelper.isValidId((String)lockId)) {
            throw new IllegalArgumentException("invalid lock id; please see IdHelper#isValidId");
        }
        this.lockId = lockId;
        this.lockNodePath = lockNodeParentPath.append(lockId);
        this.lockMonitor = lockMonitor;
        this.ephemeral = ephemeral;
        this.recoverable = recovarable;
        NodeInfo nodeInfo = CloudState.getNodeInfo();
        if (nodeInfo == null) {
            nodeInfo = new NodeInfo();
        }
        try {
            this.lockNodeContent = String.valueOf(nodeInfo.getNodeId()) + SEPARATOR + nodeInfo.getLocation() + SEPARATOR + DigestUtils.shaHex((byte[])UUID.randomUUID().toString().getBytes("US-ASCII"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException("Please use a JVM that supports UTF-8.");
        }
        try {
            this.asLockType();
        }
        catch (ClassCastException e) {
            throw new ClassCastException(String.format("Cannot cast the lock implementation %s to the generic lock type. Please make sure that the implementation implements the interface. %s", this.getClass().getName(), e.getMessage()));
        }
        this.activate();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final T acquire(long timeout, boolean recover, String recoveryKey) throws InterruptedException, TimeoutException {
        long abortTime = System.currentTimeMillis() + timeout;
        if (recover && !this.isRecoverable()) {
            throw new IllegalStateException("lock implementation is not recoverable");
        }
        try {
            if (recover) {
                if (!this.execute(new RecoverLockNode(recoveryKey)).booleanValue()) {
                    return null;
                }
            } else {
                this.execute(new CreateLockNode());
            }
            this.execute(new AcquireLockLoop(abortTime, timeout, recover));
            return this.asLockType();
        }
        catch (Exception e) {
            try {
                this.killLock(KillReason.ACQUIRE_FAILED);
            }
            catch (Exception cleanUpException) {
                LOG.error("Error during cleanup of failed lock acquisition. Please check server logs and also check lock service server. The lock may now be stalled. {}", (Object)ExceptionUtils.getRootCauseMessage((Throwable)cleanUpException));
            }
            if (e instanceof InterruptedException) {
                throw (InterruptedException)e;
            }
            if (e instanceof TimeoutException) {
                throw (TimeoutException)e;
            }
            throw new LockAcquirationFailedException(this.lockId, e);
        }
    }

    T asLockType() {
        return (T)this;
    }

    @Override
    protected void disconnect() {
        this.killLock(KillReason.ZOOKEEPER_DISCONNECT);
    }

    @Override
    protected void doClose() {
        if (CloudDebug.zooKeeperLockService) {
            LOG.debug("Closing lock {}/{}", (Object)this.lockNodePath, (Object)this.myLockName);
        }
        this.activeLockName = null;
    }

    @Override
    public String getId() {
        return this.lockId;
    }

    public final String getMyLockName() {
        return this.myLockName;
    }

    public IStatus getStatus() {
        try {
            IStatus iStatus = this.execute(new GetLockStatus());
            return iStatus;
        }
        catch (Exception e) {
            Status status = new Status(4, "org.eclipse.gyrex.cloud", String.format("Unable to read lock information. %s", e.getMessage()), (Throwable)e);
            return status;
        }
        finally {
            this.close();
        }
    }

    @Override
    protected String getToStringDetails() {
        StringBuilder details = new StringBuilder();
        details.append("id=").append(this.lockId);
        if (this.isActiveLock()) {
            details.append(", ACQUIRED");
        }
        if (this.isSuspended()) {
            details.append(", SUSPENDED");
        }
        details.append(", lockName=").append(this.myLockName);
        details.append(", activeLockName=").append(this.activeLockName);
        return details.toString();
    }

    boolean isActiveLock() {
        String myLockName = this.myLockName;
        String activeLockName = this.activeLockName;
        return myLockName != null && activeLockName != null && activeLockName.equals(myLockName);
    }

    protected final boolean isEphemeral() {
        return this.ephemeral;
    }

    protected final boolean isRecoverable() {
        return this.recoverable;
    }

    @Override
    public boolean isSuspended() {
        return this.suspended.get();
    }

    @Override
    public boolean isValid() {
        this.resumeOrKill();
        return this.isActiveLock();
    }

    void killLock(KillReason killReason) {
        if (this.myLockName == null || this.isClosed()) {
            return;
        }
        this.close();
        if (CloudDebug.zooKeeperLockService) {
            LOG.debug("Killing lock {}/{}", (Object)this.lockNodePath, (Object)this.myLockName);
        }
        try {
            try {
                if (this.shouldDeleteOnKill(killReason)) {
                    this.execute(new DeleteLockNode());
                }
                this.notifyLockReleased(killReason);
            }
            catch (KeeperException.SessionExpiredException sessionExpiredException) {
                if (CloudDebug.zooKeeperLockService) {
                    LOG.debug("ZooKeeper session expired. Relying on ZooKeeper server to remove lock node {}/{}", (Object)this.lockNodePath, (Object)this.myLockName);
                }
                this.notifyLockReleased(KillReason.ZOOKEEPER_DISCONNECT);
                this.close();
            }
            catch (Exception e) {
                if (killReason == KillReason.REGULAR_RELEASE) {
                    throw new IllegalStateException(String.format("Unable to remove lock node %s. Please check server logs and also ZooKeeper. If node still exists and the session is not closed it might never get released. %s", this.lockNodePath.append(this.myLockName), ExceptionUtils.getRootCauseMessage((Throwable)e)), e);
                }
                LOG.warn("Unable to remove lock node {}. Please check server logs and also ZooKeeper. If node still exists and the session is not closed it might never get released. However, it should get released automatically after the session times out on the ZooKeeper server. {}", (Object)this.lockNodePath.append(this.myLockName), (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                this.close();
            }
        }
        finally {
            this.close();
        }
    }

    void notifyLockAcquired() {
        LOG.info("Successfully acquired lock {}!", (Object)this.getId());
        if (this.lockMonitor != null && !this.isClosed() && this.isActiveLock()) {
            this.lockMonitor.lockAcquired(this.asLockType());
        }
    }

    void notifyLockReleased(KillReason reason) {
        boolean released;
        boolean bl = released = reason == KillReason.REGULAR_RELEASE;
        if (reason != KillReason.ACQUIRE_FAILED) {
            LOG.info(released ? "Successfully released lock {}!" : "Lost lock {}!", (Object)this.getId());
        }
        if (this.lockMonitor != null) {
            if (released) {
                this.lockMonitor.lockReleased(this.asLockType());
            } else if (reason != KillReason.ACQUIRE_FAILED) {
                this.lockMonitor.lockLost(this.asLockType());
            }
        }
    }

    void notifyLockSuspended() {
        LOG.info("Lock {} has been suspended!", (Object)this.getId());
        if (this.lockMonitor != null && !this.isClosed() && this.isActiveLock()) {
            this.lockMonitor.lockSuspended(this.asLockType());
        }
    }

    @Override
    protected void reconnect() {
        if (!this.isSuspended() || !this.isActiveLock() || this.isClosed()) {
            return;
        }
        try {
            if (!this.execute(new ResumeLockLoop()).booleanValue()) {
                this.killLock(KillReason.LOCK_DELETED);
            } else {
                this.suspended.set(false);
            }
        }
        catch (Exception exception) {
            try {
                this.killLock(KillReason.RESUME_FAILED);
            }
            catch (Exception cleanUpException) {
                LOG.error("Error during cleanup of failed lock resume. Please check server logs and also check lock service server. The lock may now be stalled. {}", (Object)ExceptionUtils.getRootCauseMessage((Throwable)cleanUpException));
            }
        }
    }

    @Override
    public void release() {
        this.killLock(KillReason.REGULAR_RELEASE);
    }

    private void resumeOrKill() {
        if (!this.isSuspended()) {
            return;
        }
        LOG.warn("Lock {} is suspended! Waiting for resume.", (Object)this.getId());
        long abortTime = System.currentTimeMillis() + 30000L;
        while (this.isSuspended() && abortTime < System.currentTimeMillis()) {
            this.sleep(1);
        }
        if (this.isSuspended()) {
            this.disconnect();
        }
    }

    private boolean shouldDeleteOnKill(KillReason killReason) {
        switch (killReason) {
            case LOCK_DELETED: 
            case LOCK_STOLEN: {
                return false;
            }
            case REGULAR_RELEASE: {
                return true;
            }
            case ZOOKEEPER_DISCONNECT: {
                return !this.isRecoverable();
            }
            case ACQUIRE_FAILED: 
            case RESUME_FAILED: {
                return true;
            }
        }
        LOG.warn("Unhandled lock kill reason {}. Please report this issue to the developers. They should sanity check the implementation.", (Object)killReason);
        return true;
    }

    void sortLockNodeChildren(Object[] nodeNames) {
        Arrays.sort(nodeNames, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                String n1 = (String)o1;
                String n2 = (String)o2;
                int sequence1 = ZooKeeperLock.getSequenceNumber(n1);
                int sequence2 = ZooKeeperLock.getSequenceNumber(n2);
                if (sequence1 == -1) {
                    return sequence2 != -1 ? 1 : n1.compareTo(n2);
                }
                return sequence2 == -1 ? -1 : sequence1 - sequence2;
            }
        });
    }

    @Override
    protected void suspend() {
        if (this.suspended.compareAndSet(false, true)) {
            this.notifyLockSuspended();
        }
    }

    private final class AcquireLockLoop
    implements Callable<Boolean> {
        private final long abortTime;
        private final long timeout;
        private final boolean recover;

        private AcquireLockLoop(long abortTime, long timeout, boolean recover) {
            this.abortTime = abortTime;
            this.timeout = timeout;
            this.recover = recover;
        }

        @Override
        public Boolean call() throws Exception {
            ZooKeeperGate zk = ZooKeeperGate.get();
            block0: do {
                IPath pathToPreceedingNode;
                Object[] nodeNames;
                if (CloudDebug.zooKeeperLockService) {
                    LOG.debug("Starting acquire lock loop for lock {}/{}", (Object)ZooKeeperLock.this.lockNodePath, (Object)ZooKeeperLock.this.myLockName);
                }
                if ((nodeNames = zk.readChildrenNames(ZooKeeperLock.this.lockNodePath, null).toArray()).length == 0) {
                    LOG.warn("Unexpected child count for ZooKeeper node {}. We just created a sequential child but it wasn't there. This may indicate an instability in the system.", (Object)ZooKeeperLock.this.lockNodePath);
                    continue;
                }
                ZooKeeperLock.this.sortLockNodeChildren(nodeNames);
                ZooKeeperLock.this.activeLockName = (String)nodeNames[0];
                if (CloudDebug.zooKeeperLockService) {
                    LOG.debug("Found active lock {} for lock {}", (Object)ZooKeeperLock.this.activeLockName, (Object)ZooKeeperLock.this.lockNodePath);
                }
                if (ZooKeeperLock.this.isActiveLock()) {
                    ZooKeeperLock.this.notifyLockAcquired();
                    return true;
                }
                String precedingNodeName = null;
                int i = 0;
                while (i < nodeNames.length) {
                    if (ZooKeeperLock.this.myLockName.equals(nodeNames[i])) {
                        precedingNodeName = i > 0 ? (String)nodeNames[i - 1] : null;
                    }
                    ++i;
                }
                if (precedingNodeName == null) {
                    if (this.recover) {
                        throw new LockAcquirationFailedException(ZooKeeperLock.this.getId(), "Impossible to recover lock. The preceding lock could not be discovered.");
                    }
                    throw new LockAcquirationFailedException(ZooKeeperLock.this.getId(), "Impossible to acquire lock. The preceding lock could not be discovered.");
                }
                if (CloudDebug.zooKeeperLockService) {
                    LOG.debug("Found preceding lock {} for lock {}", precedingNodeName, (Object)ZooKeeperLock.this.lockNodePath);
                }
                if (zk.exists(pathToPreceedingNode = ZooKeeperLock.this.lockNodePath.append(precedingNodeName))) {
                    long maxSleepTime = this.timeout <= 0L ? 5000L : Math.max(this.abortTime - System.currentTimeMillis() - 500L, 50L);
                    long sleepTime = 250L;
                    while (this.timeout <= 0L || this.abortTime > System.currentTimeMillis()) {
                        if (!zk.exists(pathToPreceedingNode)) continue block0;
                        if (CloudDebug.zooKeeperLockService) {
                            LOG.debug("Sleeping {}ms lock {}/{}", new Object[]{sleepTime, ZooKeeperLock.this.lockNodePath, ZooKeeperLock.this.myLockName});
                        }
                        Thread.sleep(sleepTime);
                        sleepTime = Math.min(sleepTime * 2L, maxSleepTime);
                    }
                }
                if (!CloudDebug.zooKeeperLockService) continue;
                LOG.debug("End acquire lock loop for lock {}/{}", (Object)ZooKeeperLock.this.lockNodePath, (Object)ZooKeeperLock.this.myLockName);
            } while (this.timeout <= 0L || this.abortTime > System.currentTimeMillis());
            if (CloudDebug.zooKeeperLockService) {
                LOG.debug("Timeout retrying to acquire lock {}/{}", (Object)ZooKeeperLock.this.lockNodePath, (Object)ZooKeeperLock.this.myLockName);
            }
            throw new TimeoutException(String.format("Unable to acquire lock %s within the given timeout. (%s/%s)", ZooKeeperLock.this.getId(), ZooKeeperLock.this.activeLockName, ZooKeeperLock.this.myLockName));
        }
    }

    private final class CreateLockNode
    implements Callable<Boolean> {
        private CreateLockNode() {
        }

        @Override
        public Boolean call() throws Exception {
            if (!ZooKeeperLock.this.isClosed() && ZooKeeperLock.this.myLockName == null) {
                ZooKeeperGate zk = ZooKeeperGate.get();
                IPath nodePath = zk.createPath(ZooKeeperLock.this.lockNodePath.append(ZooKeeperLock.LOCK_NAME_PREFIX), ZooKeeperLock.this.isEphemeral() ? CreateMode.EPHEMERAL_SEQUENTIAL : CreateMode.PERSISTENT_SEQUENTIAL, ZooKeeperLock.this.lockNodeContent);
                ZooKeeperLock.this.myLockName = nodePath.lastSegment();
                if (CloudDebug.zooKeeperLockService) {
                    LOG.debug("Created lock node {} for lock {}", (Object)ZooKeeperLock.this.myLockName, (Object)ZooKeeperLock.this.lockNodePath);
                }
                ZooKeeperLock.this.myRecoveryKey = ZooKeeperLock.createRecoveryKey(ZooKeeperLock.this.myLockName, ZooKeeperLock.this.lockNodeContent);
                zk.readRecord(nodePath, ZooKeeperLock.this.killMonitor, null);
            }
            return true;
        }
    }

    private final class DeleteLockNode
    extends ZooKeeperBasedService.ZooKeeperCallable<Boolean> {
        private DeleteLockNode() {
        }

        @Override
        protected Boolean call(ZooKeeper keeper) throws Exception {
            block10: {
                block9: {
                    String lockName = ZooKeeperLock.this.myLockName;
                    if (lockName == null) {
                        return false;
                    }
                    try {
                        if (CloudDebug.zooKeeperLockService) {
                            LOG.debug("Deleting my lock node in ZooKeeper {}/{}", (Object)ZooKeeperLock.this.lockNodePath, (Object)ZooKeeperLock.this.myLockName);
                        }
                        keeper.delete(ZooKeeperLock.this.lockNodePath.append(lockName).toString(), -1);
                    }
                    catch (KeeperException.NoNodeException noNodeException) {
                        if (!CloudDebug.zooKeeperLockService) break block9;
                        LOG.debug("My lock node already gone {}/{}", (Object)ZooKeeperLock.this.lockNodePath, (Object)ZooKeeperLock.this.myLockName);
                    }
                }
                ZooKeeperLock.this.myLockName = null;
                try {
                    if (CloudDebug.zooKeeperLockService) {
                        LOG.debug("Deleting lock node in ZooKeeper {}", (Object)ZooKeeperLock.this.lockNodePath);
                    }
                    keeper.delete(ZooKeeperLock.this.lockNodePath.toString(), -1);
                }
                catch (KeeperException.NoNodeException noNodeException) {
                    if (CloudDebug.zooKeeperLockService) {
                        LOG.debug("Lock node already gone {}", (Object)ZooKeeperLock.this.lockNodePath);
                    }
                }
                catch (KeeperException.NotEmptyException notEmptyException) {
                    if (!CloudDebug.zooKeeperLockService) break block10;
                    LOG.debug("Lock node not empty {}", (Object)ZooKeeperLock.this.lockNodePath);
                }
            }
            return true;
        }
    }

    private final class GetLockStatus
    extends ZooKeeperGateCallable<IStatus> {
        private GetLockStatus() {
        }

        @Override
        protected IStatus call(ZooKeeperGate zk) throws Exception {
            Object[] nodeNames;
            try {
                nodeNames = zk.readChildrenNames(ZooKeeperLock.this.lockNodePath, null).toArray();
            }
            catch (KeeperException.NoNodeException noNodeException) {
                nodeNames = null;
            }
            if (nodeNames == null || nodeNames.length == 0) {
                return this.info("Lock '%s' is inactive! There are no clients waiting to aquire the lock.", ZooKeeperLock.this.lockId);
            }
            MultiStatus status = new MultiStatus("org.eclipse.gyrex.cloud", 0, String.format("Lock '%s' is active", ZooKeeperLock.this.lockId), null);
            ZooKeeperLock.this.sortLockNodeChildren(nodeNames);
            int i = 0;
            while (i < nodeNames.length) {
                Stat stat;
                String lockName = (String)nodeNames[i];
                IPath nodePath = ZooKeeperLock.this.lockNodePath.append(lockName);
                String record = zk.readRecord(nodePath, "", stat = new Stat());
                String[] lockData = StringUtils.splitByWholeSeparator((String)record, (String)ZooKeeperLock.SEPARATOR);
                if (lockData == null | lockData.length < 3) {
                    status.add((IStatus)this.error("Invalid data for client '%s'", lockName));
                } else {
                    status.add((IStatus)this.info("%s: %s (%s, 0x%s, owner 0x%s)", i == 0 ? "OWNER" : "WAITING", lockData[0], lockData[1], StringUtils.left((String)lockData[2], (int)6), Long.toHexString(stat.getEphemeralOwner())));
                }
                ++i;
            }
            return status;
        }

        private Status error(String format, Object ... args) {
            return new Status(1, "org.eclipse.gyrex.cloud", String.format(format, args));
        }

        private Status info(String format, Object ... args) {
            return new Status(1, "org.eclipse.gyrex.cloud", String.format(format, args));
        }
    }

    static enum KillReason {
        ZOOKEEPER_DISCONNECT,
        LOCK_DELETED,
        LOCK_STOLEN,
        REGULAR_RELEASE,
        ACQUIRE_FAILED,
        RESUME_FAILED;

    }

    private final class RecoverLockNode
    implements Callable<Boolean> {
        private final String lockName;
        private final String expectedNodeContent;

        public RecoverLockNode(String recoveryKey) {
            if (StringUtils.isBlank((String)recoveryKey)) {
                throw new IllegalArgumentException("recovery key must not be empty");
            }
            String[] extractRecoveryKeyDetails = ZooKeeperLock.extractRecoveryKeyDetails(recoveryKey);
            this.lockName = extractRecoveryKeyDetails[0];
            this.expectedNodeContent = extractRecoveryKeyDetails[1];
        }

        @Override
        public Boolean call() throws Exception {
            if (!ZooKeeperLock.this.isClosed() && ZooKeeperLock.this.myLockName == null) {
                Stat stat;
                IPath nodePath;
                String record;
                ZooKeeperGate zk = ZooKeeperGate.get();
                if (CloudDebug.zooKeeperLockService) {
                    LOG.debug("Recovery attempt for lock node {} for lock {}", (Object)this.lockName, (Object)ZooKeeperLock.this.lockNodePath);
                }
                if (StringUtils.isBlank((String)(record = zk.readRecord(nodePath = ZooKeeperLock.this.lockNodePath.append(this.lockName), "", stat = new Stat())))) {
                    if (CloudDebug.zooKeeperLockService) {
                        LOG.debug("Recovery attempt failed. Lock node {}/{} does not exists", (Object)ZooKeeperLock.this.lockNodePath, (Object)this.lockName);
                    }
                    return false;
                }
                if (!StringUtils.equals((String)record, (String)this.expectedNodeContent)) {
                    if (CloudDebug.zooKeeperLockService) {
                        LOG.debug("Recovery attempt failed. Recovery key does not match for lock node {}/{}", (Object)ZooKeeperLock.this.lockNodePath, (Object)this.lockName);
                    }
                    throw new LockAcquirationFailedException(ZooKeeperLock.this.lockId, "Unable to recover lock. The recovery key does not match.");
                }
                ZooKeeperLock.this.myLockName = nodePath.lastSegment();
                if (CloudDebug.zooKeeperLockService) {
                    LOG.debug("Recovered lock node {} for lock {}", (Object)ZooKeeperLock.this.myLockName, (Object)ZooKeeperLock.this.lockNodePath);
                }
                ZooKeeperLock.this.myRecoveryKey = ZooKeeperLock.createRecoveryKey(ZooKeeperLock.this.myLockName, ZooKeeperLock.this.lockNodeContent);
                zk.writeRecord(nodePath, ZooKeeperLock.this.myRecoveryKey, stat.getVersion());
                zk.readRecord(nodePath, ZooKeeperLock.this.killMonitor, null);
            }
            return true;
        }
    }

    private final class ResumeLockLoop
    implements Callable<Boolean> {
        private ResumeLockLoop() {
        }

        @Override
        public Boolean call() throws Exception {
            Object[] nodeNames;
            ZooKeeperGate zk = ZooKeeperGate.get();
            if (CloudDebug.zooKeeperLockService) {
                LOG.debug("Starting resume lock loop for lock {}/{}", (Object)ZooKeeperLock.this.lockNodePath, (Object)ZooKeeperLock.this.myLockName);
            }
            if ((nodeNames = zk.readChildrenNames(ZooKeeperLock.this.lockNodePath, null).toArray()).length == 0) {
                return false;
            }
            Arrays.sort(nodeNames, new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    String n1 = (String)o1;
                    String n2 = (String)o2;
                    int sequence1 = ZooKeeperLock.getSequenceNumber(n1);
                    int sequence2 = ZooKeeperLock.getSequenceNumber(n2);
                    if (sequence1 == -1) {
                        return sequence2 != -1 ? 1 : n1.compareTo(n2);
                    }
                    return sequence2 == -1 ? -1 : sequence1 - sequence2;
                }
            });
            ZooKeeperLock.this.activeLockName = (String)nodeNames[0];
            if (CloudDebug.zooKeeperLockService) {
                LOG.debug("Found active lock {} for lock {}", (Object)ZooKeeperLock.this.activeLockName, (Object)ZooKeeperLock.this.lockNodePath);
            }
            if (ZooKeeperLock.this.isActiveLock()) {
                ZooKeeperLock.this.notifyLockAcquired();
                return true;
            }
            int i = 0;
            while (i < nodeNames.length) {
                if (ZooKeeperLock.this.myLockName.equals(nodeNames[i])) {
                    throw new LockAcquirationFailedException(ZooKeeperLock.this.getId(), "Impossible to resume lock. The active lock changed and conflicts with this lock.");
                }
                ++i;
            }
            return false;
        }
    }

    static class WaitForDeletionMonitor
    extends ZooKeeperMonitor {
        private static CountDownLatch deletionHappend = new CountDownLatch(1);

        WaitForDeletionMonitor() {
        }

        public boolean await(long timeout) throws InterruptedException {
            if (timeout > 0L) {
                return deletionHappend.await(timeout, TimeUnit.MILLISECONDS);
            }
            deletionHappend.await();
            return true;
        }

        @Override
        protected void pathDeleted(String path) {
            deletionHappend.countDown();
        }
    }
}

