/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.cloud.internal.queue.console;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.eclipse.gyrex.cloud.internal.CloudActivator;
import org.eclipse.gyrex.cloud.internal.queue.Message;
import org.eclipse.gyrex.cloud.internal.queue.ZooKeeperQueue;
import org.eclipse.gyrex.cloud.internal.queue.ZooKeeperQueueService;
import org.eclipse.gyrex.cloud.services.queue.IQueue;
import org.eclipse.gyrex.cloud.services.queue.IQueueService;
import org.eclipse.gyrex.common.console.Command;
import org.eclipse.gyrex.common.identifiers.IdHelper;
import org.kohsuke.args4j.Argument;

public class ListQueuesCmd
extends Command {
    @Argument(index=0, metaVar="FILTER", usage="an optional filter string")
    String filter;

    public ListQueuesCmd() {
        super("[FILTER] - list queues");
    }

    protected void doExecute() throws Exception {
        ZooKeeperQueueService queueService = this.getQueueService();
        TreeSet<String> queueIds = new TreeSet<String>(queueService.getQueues());
        if (IdHelper.isValidId((String)this.filter) && queueIds.contains(this.filter)) {
            this.printQueueDetails(this.filter);
            return;
        }
        for (String queueId : queueIds) {
            IQueue queue;
            if (!StringUtils.isBlank((String)this.filter) && !StringUtils.containsIgnoreCase((String)queueId, (String)this.filter) || (queue = queueService.getQueue(queueId, (Map)null)) == null) continue;
            this.printf("%s (%d)", new Object[]{queueId, ((ZooKeeperQueue)queue).size()});
        }
    }

    private ZooKeeperQueueService getQueueService() {
        return (ZooKeeperQueueService)CloudActivator.getInstance().getService(IQueueService.class);
    }

    private void printQueueDetails(String queueId) {
        IQueue queue = this.getQueueService().getQueue(queueId, (Map)null);
        if (queue == null) {
            this.printf("Queue '%s' has been removed!", new Object[]{queueId});
            return;
        }
        this.printf("%s", new Object[]{queueId});
        List<Message> messages = ((ZooKeeperQueue)queue).getMessages();
        if (!messages.isEmpty()) {
            for (Message message : messages) {
                if (message.isHidden()) {
                    this.printf("  %s (hidden till %tc)", new Object[]{message.getMessageId(), new Date(message.getInvisibleTimeoutTS())});
                    continue;
                }
                this.printf("  %s (%d bytes)", new Object[]{message.getMessageId(), message.getBody().length});
            }
        } else {
            this.printf("  (empty)", new Object[0]);
        }
    }
}

