/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.cloud.internal.zk.console;

import java.util.List;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.eclipse.gyrex.cloud.internal.zk.console.PathBasedCmd;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

public class CreateCmd
extends PathBasedCmd {
    @Option(name="--charset-name", usage="name of the character set to use when writing the input string as byte array")
    String charsetName;
    @Argument(index=1, metaVar="DATA", usage="optional input string to set")
    String data;
    @Option(name="-e", aliases={"--ephemeral"}, usage="if the node should be ephemeral")
    boolean ephemeral;
    @Option(name="-s", aliases={"--sequential"}, usage="if the node should be sequential")
    boolean sequential;

    public CreateCmd() {
        super("- creates a path in ZK");
    }

    @Override
    protected void doExecute(ZooKeeper zk, String path) throws Exception {
        byte[] bytes = null;
        if (this.data != null) {
            bytes = this.charsetName != null ? this.data.getBytes(this.charsetName) : this.data.getBytes();
        }
        CreateMode flags = CreateMode.PERSISTENT;
        if (this.ephemeral && this.sequential) {
            flags = CreateMode.EPHEMERAL_SEQUENTIAL;
        } else if (this.ephemeral) {
            flags = CreateMode.EPHEMERAL;
        } else if (this.sequential) {
            flags = CreateMode.PERSISTENT_SEQUENTIAL;
        }
        String newPath = zk.create(path, bytes, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, flags);
        this.ci.println((Object)("Created " + newPath));
    }
}

