/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.common.console;

import org.eclipse.osgi.framework.console.CommandInterpreter;

public abstract class Command {
    private final String description;
    protected CommandInterpreter ci;

    public Command(String description) {
        this.description = description;
    }

    protected abstract void doExecute() throws Exception;

    public void execute(CommandInterpreter ci) throws Exception {
        this.ci = ci;
        try {
            this.doExecute();
        }
        finally {
            this.ci = null;
        }
    }

    public String getDescription() {
        return this.description;
    }

    protected void printf(String message, Object ... args) {
        if (this.ci != null) {
            this.ci.println((Object)String.format(message, args));
        }
    }

    protected void run(String cmd) {
        this.printf("Executing: %s", cmd);
        this.ci.execute(cmd);
    }

    protected void run(String commandUsingFormat, Object ... args) {
        this.run(String.format(commandUsingFormat, args));
    }
}

