/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.context.internal.di;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import org.eclipse.e4.core.di.IInjector;
import org.eclipse.e4.core.di.InjectionException;
import org.eclipse.e4.core.di.suppliers.IObjectDescriptor;
import org.eclipse.e4.core.di.suppliers.IRequestor;
import org.eclipse.e4.core.di.suppliers.PrimaryObjectSupplier;
import org.eclipse.gyrex.common.internal.services.IServiceProxyChangeListener;
import org.eclipse.gyrex.common.internal.services.IServiceProxyDisposalListener;
import org.eclipse.gyrex.common.internal.services.ServiceProxy;
import org.eclipse.gyrex.common.services.IServiceProxy;
import org.eclipse.gyrex.common.services.ServiceNotAvailableException;
import org.eclipse.gyrex.common.services.annotations.DynamicService;
import org.eclipse.gyrex.context.IRuntimeContext;
import org.eclipse.gyrex.context.internal.ContextDebug;
import org.eclipse.gyrex.context.internal.IContextDisposalListener;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServicePermission;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseContextObjectSupplier
extends PrimaryObjectSupplier {
    public static boolean dynamicInjectionEnabled = Boolean.getBoolean("gyrex.context.dynamicInjection");
    private static final Logger LOG = LoggerFactory.getLogger(BaseContextObjectSupplier.class);

    protected abstract void addDisposable(IContextDisposalListener var1);

    public void get(IObjectDescriptor[] descriptors, Object[] actualValues, IRequestor requestor, boolean initial, boolean track, boolean group) {
        int i = 0;
        while (i < descriptors.length) {
            if (actualValues[i] == IInjector.NOT_A_VALUE) {
                IObjectDescriptor descriptor = descriptors[i];
                Class<?> key = this.getKey(descriptor);
                Object value = this.getContextObject(key);
                if (value == null) {
                    value = this.getService(key, descriptor, requestor, initial, track, group);
                }
                if (value == null && descriptor.getQualifiers() != null) {
                    Annotation[] qualifiers = descriptor.getQualifiers();
                    int j = 0;
                    while (value == null && j < qualifiers.length) {
                        value = this.getQualifiedObjected(key, qualifiers[j]);
                        ++j;
                    }
                }
                if (value != null) {
                    actualValues[i] = value;
                }
            }
            ++i;
        }
        if (track) {
            this.addDisposable(new RequestorDisposer(requestor, this));
        }
    }

    private BundleContext getBundleContext(IRequestor requestor) {
        Class requestingObjectClass = requestor.getRequestingObjectClass();
        if (requestingObjectClass == null) {
            return null;
        }
        Bundle bundle = FrameworkUtil.getBundle((Class)requestingObjectClass);
        if (bundle == null) {
            return null;
        }
        return bundle.getBundleContext();
    }

    final Class<?> getClass(Type type) {
        block4: {
            if (type instanceof Class) {
                return (Class)type;
            }
            if (type instanceof ParameterizedType) {
                try {
                    return (Class)((ParameterizedType)type).getRawType();
                }
                catch (Exception ignored) {
                    if (!ContextDebug.injection) break block4;
                    LOG.debug("Unable to cast raw type of ParameterizedType ({}) to Class.", (Object)type, (Object)ignored);
                }
            }
        }
        return null;
    }

    private Class<?> getCollectionElementType(IObjectDescriptor descriptor) {
        Type[] typeArguments;
        Type elementType = descriptor.getDesiredType();
        if (elementType instanceof ParameterizedType && (typeArguments = ((ParameterizedType)elementType).getActualTypeArguments()).length == 1) {
            return this.getClass(typeArguments[0]);
        }
        if (ContextDebug.injection) {
            LOG.debug("Unable to detect collection element type for object descriptor ({}).", (Object)descriptor);
        }
        return null;
    }

    protected abstract Object getContextObject(Class<?> var1);

    final Class<?> getKey(IObjectDescriptor descriptor) {
        return this.getClass(descriptor.getDesiredType());
    }

    protected abstract Object getQualifiedObjected(Class<?> var1, Annotation var2);

    private Object getService(Class<?> key, IObjectDescriptor descriptor, IRequestor requestor, boolean initial, boolean track, boolean group) {
        IServiceProxy<?> proxy;
        Class<?> serviceInterface;
        DynamicService serviceAnnotation = (DynamicService)descriptor.getQualifier(DynamicService.class);
        if (serviceAnnotation == null) {
            if (ContextDebug.injection) {
                LOG.debug("No @DynamicService annotation present on ({}).", (Object)descriptor);
            }
            return null;
        }
        BundleContext bundleContext = this.getBundleContext(requestor);
        if (bundleContext == null) {
            if (ContextDebug.injection) {
                LOG.debug("No bundle context found for requestor ({}).", (Object)requestor);
            }
            return null;
        }
        boolean collectionOfServices = Collection.class.isAssignableFrom(key) || List.class.isAssignableFrom(key);
        Class<?> clazz = serviceInterface = collectionOfServices ? this.getCollectionElementType(descriptor) : key;
        if (!bundleContext.getBundle().hasPermission((Object)new ServicePermission(serviceInterface.getName(), "get"))) {
            if (ContextDebug.injection) {
                LOG.debug("Bundle ({}) does not have permissions to get service ({}) for requestor ({}).", new Object[]{bundleContext.getBundle(), serviceInterface, requestor});
            }
            return null;
        }
        String filter = serviceAnnotation.filter();
        try {
            proxy = this.trackService(bundleContext, serviceInterface, filter);
        }
        catch (InvalidSyntaxException e) {
            throw new InjectionException(String.format("Error parsing filter '%s' specified in annotation at %s. %s", filter, descriptor, e.getMessage()), (Throwable)e);
        }
        if (proxy == null) {
            if (ContextDebug.injection) {
                LOG.debug("OSGI service lookup disabled in supplier ({}) for service ({}).", new Object[]{this, serviceInterface});
            }
            return null;
        }
        if (collectionOfServices) {
            if (ContextDebug.injection) {
                LOG.debug("Injecting service collection ({}).", proxy);
            }
            return proxy.getServices();
        }
        if (track && dynamicInjectionEnabled && !serviceAnnotation.preferProxy()) {
            try {
                Object service = proxy.getService();
                if (ContextDebug.injection) {
                    LOG.debug("Injected real service instance ({}).", proxy);
                }
                ((ServiceProxy)proxy).addChangeListener((IServiceProxyChangeListener)new ReinjectOnUpdate(requestor));
                ((ServiceProxy)proxy).addDisposalListener((IServiceProxyDisposalListener)new ReinjectOnDisposal(requestor));
                return service;
            }
            catch (ServiceNotAvailableException serviceNotAvailableException) {
                if (ContextDebug.injection) {
                    LOG.debug("Service not available ({}), falling back to proxy.", proxy);
                }
                return proxy.getProxy();
            }
        }
        return proxy.getProxy();
    }

    public void pauseRecording() {
    }

    public void resumeRecording() {
    }

    protected abstract IServiceProxy<?> trackService(BundleContext var1, Class<?> var2, String var3) throws InvalidSyntaxException;

    private static final class ReinjectOnDisposal
    implements IServiceProxyDisposalListener {
        private final IRequestor requestor;

        private ReinjectOnDisposal(IRequestor requestor) {
            this.requestor = requestor;
        }

        public void disposed(IServiceProxy<?> proxy) {
            if (!this.requestor.isValid()) {
                return;
            }
            if (ContextDebug.injection) {
                LOG.debug("Service proxy ({}) disposed, re-injecting ({})", proxy, (Object)this.requestor);
            }
            this.requestor.resolveArguments(false);
            this.requestor.execute();
        }
    }

    private static final class ReinjectOnUpdate
    implements IServiceProxyChangeListener {
        private final IRequestor requestor;

        private ReinjectOnUpdate(IRequestor requestor) {
            this.requestor = requestor;
        }

        public boolean serviceChanged(IServiceProxy<?> proxy) {
            if (!this.requestor.isValid()) {
                return false;
            }
            if (ContextDebug.injection) {
                LOG.debug("Service proxy ({}) changed, re-injecting ({})", proxy, (Object)this.requestor);
            }
            this.requestor.resolveArguments(false);
            this.requestor.execute();
            return true;
        }
    }

    private static final class RequestorDisposer
    implements IContextDisposalListener {
        private final IRequestor requestor;
        private final PrimaryObjectSupplier supplier;

        private RequestorDisposer(IRequestor requestor, PrimaryObjectSupplier supplier) {
            this.requestor = requestor;
            this.supplier = supplier;
        }

        @Override
        public void contextDisposed(IRuntimeContext handle) {
            if (this.requestor.isValid()) {
                this.requestor.disposed(this.supplier);
            }
        }
    }
}

