/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.http.jaxrs.internal;

import com.sun.jersey.core.spi.scanning.Scanner;
import com.sun.jersey.core.spi.scanning.ScannerException;
import com.sun.jersey.core.spi.scanning.ScannerListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleWiring;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleScanner
implements Scanner {
    private static final Logger LOG = LoggerFactory.getLogger(BundleScanner.class);
    private final BundleWiring bundleWiring;
    private final ClassLoader loader;
    private final Bundle bundle;

    public BundleScanner(Bundle bundle, BundleWiring bundleWiring, ClassLoader loader) {
        this.bundle = bundle;
        this.bundleWiring = bundleWiring;
        this.loader = loader;
    }

    public void scan(ScannerListener scannerListener) throws ScannerException {
        Collection resources = this.bundleWiring.listResources("/", "*.class", 3);
        if (resources == null) {
            throw new ScannerException(String.format("No resources available for bundle '%s'", this.bundle));
        }
        for (String resource : resources) {
            LOG.trace("Found resource: {}", (Object)resource);
            if (!scannerListener.onAccept(resource)) {
                LOG.debug("Resource rejected: {}", (Object)resource);
                continue;
            }
            InputStream in = null;
            try {
                try {
                    in = this.loader.getResourceAsStream(resource);
                    scannerListener.onProcess(resource, in);
                }
                catch (IOException e) {
                    throw new ScannerException(String.format("Error scanning resource '%s': %s", resource, ExceptionUtils.getRootCauseMessage((Throwable)e)), (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)in);
        }
    }
}

