/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.http.registry.internal;

import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.gyrex.context.IRuntimeContext;
import org.eclipse.gyrex.context.registry.IRuntimeContextRegistry;
import org.eclipse.gyrex.http.application.context.IResourceProvider;
import org.eclipse.gyrex.http.application.context.NamespaceException;
import org.eclipse.gyrex.http.application.manager.ApplicationRegistrationException;
import org.eclipse.gyrex.http.application.manager.IApplicationManager;
import org.eclipse.gyrex.http.application.manager.MountConflictException;
import org.eclipse.gyrex.http.registry.internal.ApplicationManager;
import org.eclipse.gyrex.http.registry.internal.BundleResourceProvider;
import org.eclipse.gyrex.http.registry.internal.HttpRegistryDebug;
import org.eclipse.gyrex.http.registry.internal.MountManager;
import org.eclipse.gyrex.http.registry.internal.RegistryApplication;
import org.eclipse.gyrex.http.registry.internal.RegistryApplicationProvider;
import org.eclipse.gyrex.http.registry.internal.ResourceManager;
import org.eclipse.gyrex.http.registry.internal.ServletManager;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationRegistryManager {
    private static final Logger LOG = LoggerFactory.getLogger(ApplicationRegistryManager.class);
    private final ApplicationManager applicationManager;
    private final ServletManager servletManager;
    private final ResourceManager resourceManager;
    private final MountManager mountManager;
    private final IApplicationManager httpApplicationManager;
    private final PackageAdmin packageAdmin;
    private final RegistryApplicationProvider applicationProvider;
    private final Map<String, ApplicationContribution> applications = new HashMap<String, ApplicationContribution>();
    private final Map<String, RegistryApplication> activeApplications = new HashMap<String, RegistryApplication>();
    private final Map<String, ServletContribution> servlets = new HashMap<String, ServletContribution>();
    private final Map<String, ResourcesContribution> resources = new HashMap<String, ResourcesContribution>();
    private final Map<String, MountContribution> mounts = new HashMap<String, MountContribution>();
    private final IRuntimeContextRegistry contextRegistry;

    public ApplicationRegistryManager(ServiceReference reference, IApplicationManager httpApplicationManager, PackageAdmin packageAdmin, IExtensionRegistry registry, IRuntimeContextRegistry contextRegistry) {
        this.httpApplicationManager = httpApplicationManager;
        this.packageAdmin = packageAdmin;
        this.contextRegistry = contextRegistry;
        this.applicationProvider = RegistryApplicationProvider.getInstance();
        this.applicationManager = new ApplicationManager(this, registry);
        this.servletManager = new ServletManager(this, reference, registry);
        this.resourceManager = new ResourceManager(this, reference, registry);
        this.mountManager = new MountManager(this, reference, registry);
    }

    public synchronized boolean addApplicationContribution(String applicationId, String contextPath, IConfigurationElement configurationElement) {
        if (this.applications.containsKey(applicationId)) {
            LOG.warn("Application {} already registered (existing registration: {}).", (Object)applicationId, (Object)this.applications.get(applicationId));
            return false;
        }
        IRuntimeContext context = this.contextRegistry.get((IPath)(contextPath != null ? new Path(contextPath) : Path.EMPTY));
        if (context == null) {
            LOG.warn("Context path {} requested by application {} is unknown.", (Object)contextPath, (Object)applicationId);
            return false;
        }
        this.applications.put(applicationId, new ApplicationContribution(applicationId, contextPath, configurationElement));
        try {
            if (HttpRegistryDebug.applicationLifecycle) {
                LOG.debug("Registering application {}.", (Object)applicationId);
            }
            this.httpApplicationManager.register(applicationId, "org.eclipse.gyrex.http.registry.application", context, null);
        }
        catch (ApplicationRegistrationException e) {
            LOG.warn("Could not register application {}. {}", (Object)applicationId, (Object)e.getMessage());
            return false;
        }
        for (MountContribution contribution : this.mounts.values()) {
            if (!applicationId.equals(contribution.applicationId)) continue;
            this.mountApplication(contribution);
        }
        return true;
    }

    public synchronized boolean addMountContribution(String url, String applicationId, IContributor contributor) {
        if (this.mounts.containsKey(url)) {
            LOG.warn("Mount point {} already in use (application trying to use {}, existing registration {}.", new Object[]{url, applicationId, this.mounts.get(url)});
            return false;
        }
        MountContribution mountContribution = new MountContribution(applicationId, url, contributor);
        this.mounts.put(url, mountContribution);
        if (this.applications.containsKey(applicationId)) {
            return this.mountApplication(mountContribution);
        }
        return true;
    }

    public synchronized boolean addResourcesContribution(String alias, String path, String applicationId, IContributor contributor) {
        String registrationKey = String.valueOf(applicationId) + ":" + alias;
        if (this.resources.containsKey(registrationKey) || this.servlets.containsKey(registrationKey)) {
            LOG.warn("Alias {} already registered for application {} (existing registrations: {}, {}).", new Object[]{alias, applicationId, this.resources.containsKey(registrationKey), this.servlets.containsKey(registrationKey)});
            return false;
        }
        ResourcesContribution contribution = new ResourcesContribution(alias, path, applicationId, new BundleResourceProvider(this.getBundle(contributor)), contributor);
        this.resources.put(registrationKey, contribution);
        if (this.activeApplications.containsKey(applicationId)) {
            this.registerResources(contribution, this.activeApplications.get(applicationId));
        }
        return true;
    }

    public synchronized boolean addServletContribution(String alias, Servlet servlet, Map<String, String> initparams, String applicationId, IContributor contributor) {
        String registrationKey = String.valueOf(applicationId) + ":" + alias;
        if (this.resources.containsKey(registrationKey) || this.servlets.containsKey(registrationKey)) {
            LOG.warn("Alias {} already registered for application {} (existing registrations: {}, {}).", new Object[]{alias, applicationId, this.resources.containsKey(registrationKey), this.servlets.containsKey(registrationKey)});
            return false;
        }
        ServletContribution contribution = new ServletContribution(alias, servlet, initparams, applicationId, contributor);
        this.servlets.put(registrationKey, contribution);
        if (this.activeApplications.containsKey(applicationId)) {
            this.registerServlet(contribution, this.activeApplications.get(applicationId));
        }
        return true;
    }

    public synchronized void closeApplication(RegistryApplication application) {
        String applicationId = application.getId();
        if (this.activeApplications.remove(applicationId) != null) {
            for (ResourcesContribution resourcesContribution : this.resources.values()) {
                if (!applicationId.equals(resourcesContribution.applicationId)) continue;
                this.unregister(resourcesContribution.alias, application);
            }
            for (ServletContribution servletContribution : this.servlets.values()) {
                if (!applicationId.equals(servletContribution.applicationId)) continue;
                this.unregister(servletContribution.alias, application);
            }
        }
    }

    public Bundle getBundle(IContributor contributor) {
        return this.getBundle(contributor.getName());
    }

    public Bundle getBundle(String symbolicName) {
        Bundle[] bundles = this.packageAdmin.getBundles(symbolicName, null);
        if (bundles == null) {
            return null;
        }
        int i = 0;
        while (i < bundles.length) {
            if ((bundles[i].getState() & 3) == 0) {
                return bundles[i];
            }
            ++i;
        }
        return null;
    }

    public synchronized void initApplication(RegistryApplication registryApplication) {
        String applicationId = registryApplication.getId();
        if (this.activeApplications.containsKey(applicationId)) {
            return;
        }
        this.activeApplications.put(applicationId, registryApplication);
        ApplicationContribution applicationContribution = this.applications.get(applicationId);
        registryApplication.setCustomizer(ApplicationManager.createCustomizer(applicationContribution.configurationElement));
        for (ResourcesContribution resourcesContribution : this.resources.values()) {
            if (!applicationId.equals(resourcesContribution.applicationId)) continue;
            this.registerResources(resourcesContribution, registryApplication);
        }
        for (ServletContribution servletContribution : this.servlets.values()) {
            if (!applicationId.equals(servletContribution.applicationId)) continue;
            this.registerServlet(servletContribution, registryApplication);
        }
    }

    private boolean mountApplication(MountContribution contribution) {
        try {
            if (HttpRegistryDebug.applicationLifecycle) {
                LOG.debug("Mounting application {} to {}.", (Object)contribution.applicationId, (Object)contribution.url);
            }
            this.httpApplicationManager.mount(contribution.url, contribution.applicationId);
        }
        catch (MountConflictException e) {
            LOG.warn("Could not mount application {}. {}", (Object)contribution.applicationId, (Object)e.getMessage());
            return false;
        }
        catch (MalformedURLException e) {
            LOG.warn("Could not mount application {}. {}", (Object)contribution.applicationId, (Object)e.getMessage());
            return false;
        }
        return true;
    }

    private void registerResources(ResourcesContribution contribution, RegistryApplication registryApplication) {
        try {
            if (HttpRegistryDebug.applicationLifecycle) {
                LOG.debug("Registering resource {} with application {}.", new Object[]{contribution.alias, contribution.applicationId});
            }
            registryApplication.getApplicationContext().registerResources(contribution.alias, contribution.path, contribution.resourceProvider);
        }
        catch (NamespaceException e) {
            LOG.warn("Could not register resource {} with application {}. {}", new Object[]{contribution.alias, contribution.applicationId, e.getMessage()});
        }
        catch (IllegalStateException e) {
            LOG.warn("Could not register resource {} with application {}. {}", new Object[]{contribution.alias, contribution.applicationId, e.getMessage()});
        }
    }

    private void registerServlet(ServletContribution contribution, RegistryApplication registryApplication) {
        try {
            if (HttpRegistryDebug.applicationLifecycle) {
                LOG.debug("Registering servlet {} with application {}.", new Object[]{contribution.alias, contribution.applicationId});
            }
            registryApplication.getApplicationContext().registerServlet(contribution.alias, contribution.servlet, contribution.initparams);
        }
        catch (NamespaceException e) {
            LOG.warn("Could not register servlet {} with application {}. {}", new Object[]{contribution.alias, contribution.applicationId, e.getMessage()});
        }
        catch (ServletException e) {
            LOG.warn("Could not register servlet {} with application {}. Error in servlet initialization. {}", new Object[]{contribution.alias, contribution.applicationId, e.getMessage()});
        }
        catch (IllegalStateException e) {
            LOG.warn("Could not register servlet {} with application {}. {}", new Object[]{contribution.alias, contribution.applicationId, e.getMessage()});
        }
    }

    public synchronized void removeApplicationContribution(String applicationId) {
        if (this.applications.remove(applicationId) != null) {
            if (HttpRegistryDebug.applicationLifecycle) {
                LOG.debug("Unregistering application {}.", (Object)applicationId);
            }
            this.httpApplicationManager.unregister(applicationId);
        }
    }

    public synchronized void removeContribution(String alias, String applicationId) {
        this.resources.remove(String.valueOf(applicationId) + ":" + alias);
        this.servlets.remove(String.valueOf(applicationId) + ":" + alias);
        if (this.activeApplications.containsKey(applicationId)) {
            this.unregister(alias, this.activeApplications.get(applicationId));
        }
    }

    public synchronized void removeMountContribution(String url, String applicationId) {
        if (this.mounts.remove(url) != null) {
            try {
                if (HttpRegistryDebug.applicationLifecycle) {
                    LOG.debug("Unmounting {} from application {}.", new Object[]{url, applicationId});
                }
                this.httpApplicationManager.unmount(url);
            }
            catch (Exception e) {
                LOG.warn("Could not unmount {} from application {}. {}", new Object[]{url, applicationId, e.getMessage()});
            }
        }
    }

    public void start() {
        this.applicationProvider.setManager(this);
        this.applicationManager.start();
        this.servletManager.start();
        this.resourceManager.start();
        this.mountManager.start();
    }

    public void stop() {
        this.mountManager.stop();
        this.resourceManager.stop();
        this.servletManager.stop();
        this.applicationManager.stop();
        this.applicationProvider.setManager(null);
    }

    private void unregister(String alias, RegistryApplication application) {
        try {
            if (HttpRegistryDebug.applicationLifecycle) {
                LOG.debug("Removing registration {} from application {}", new Object[]{alias, application.getId()});
            }
            application.getApplicationContext().unregister(alias);
        }
        catch (IllegalArgumentException e) {
            LOG.warn("Could not unregister {} from application {}. {}", new Object[]{alias, application.getId(), e.getMessage()});
        }
        catch (IllegalStateException e) {
            LOG.warn("Could not unregister {} from application {}. {}", new Object[]{alias, application.getId(), e.getMessage()});
        }
    }

    class ApplicationContribution {
        final String applicationId;
        final String contextPath;
        final IConfigurationElement configurationElement;

        public ApplicationContribution(String applicationId, String contextPath, IConfigurationElement configurationElement) {
            this.applicationId = applicationId;
            this.contextPath = contextPath;
            this.configurationElement = configurationElement;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("ApplicationContribution [");
            if (this.applicationId != null) {
                builder.append("applicationId=");
                builder.append(this.applicationId);
                builder.append(", ");
            }
            if (this.contextPath != null) {
                builder.append("contextPath=");
                builder.append(this.contextPath);
                builder.append(", ");
            }
            if (this.configurationElement != null) {
                builder.append("contributor=");
                builder.append(this.configurationElement.getContributor());
            }
            builder.append("]");
            return builder.toString();
        }
    }

    class MountContribution {
        final IContributor contributor;
        final String applicationId;
        final String url;

        public MountContribution(String applicationId, String url, IContributor contributor) {
            this.applicationId = applicationId;
            this.url = url;
            this.contributor = contributor;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("MountContribution [");
            if (this.url != null) {
                builder.append("url=");
                builder.append(this.url);
                builder.append(", ");
            }
            if (this.applicationId != null) {
                builder.append("applicationId=");
                builder.append(this.applicationId);
                builder.append(", ");
            }
            if (this.contributor != null) {
                builder.append("contributor=");
                builder.append(this.contributor);
            }
            builder.append("]");
            return builder.toString();
        }
    }

    class ResourcesContribution {
        final String alias;
        final String path;
        final String applicationId;
        final IResourceProvider resourceProvider;
        final IContributor contributor;

        public ResourcesContribution(String alias, String path, String applicationId, IResourceProvider resourceProvider, IContributor contributor) {
            this.alias = alias;
            this.path = path;
            this.applicationId = applicationId;
            this.resourceProvider = resourceProvider;
            this.contributor = contributor;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("ResourcesContribution [");
            if (this.alias != null) {
                builder.append("alias=");
                builder.append(this.alias);
                builder.append(", ");
            }
            if (this.applicationId != null) {
                builder.append("applicationId=");
                builder.append(this.applicationId);
                builder.append(", ");
            }
            if (this.contributor != null) {
                builder.append("contributor=");
                builder.append(this.contributor);
            }
            builder.append("]");
            return builder.toString();
        }
    }

    class ServletContribution {
        final String alias;
        final Servlet servlet;
        final Map<String, String> initparams;
        final String applicationId;
        final IContributor contributor;

        public ServletContribution(String alias, Servlet servlet, Map<String, String> initparams, String applicationId, IContributor contributor) {
            this.alias = alias;
            this.servlet = servlet;
            this.initparams = initparams;
            this.applicationId = applicationId;
            this.contributor = contributor;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("ServletContribution [");
            if (this.alias != null) {
                builder.append("alias=");
                builder.append(this.alias);
                builder.append(", ");
            }
            if (this.applicationId != null) {
                builder.append("applicationId=");
                builder.append(this.applicationId);
                builder.append(", ");
            }
            if (this.contributor != null) {
                builder.append("contributor=");
                builder.append(this.contributor);
            }
            builder.append("]");
            return builder.toString();
        }
    }
}

