/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.http.registry.internal;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.gyrex.context.IRuntimeContext;
import org.eclipse.gyrex.http.application.Application;
import org.eclipse.gyrex.http.application.provider.ApplicationProvider;
import org.eclipse.gyrex.http.registry.internal.ApplicationRegistryManager;
import org.eclipse.gyrex.http.registry.internal.RegistryApplication;

public class RegistryApplicationProvider
extends ApplicationProvider {
    public static final String ID = "org.eclipse.gyrex.http.registry.application";
    private static final AtomicReference<RegistryApplicationProvider> instanceRef = new AtomicReference();
    private final Map<String, RegistryApplication> activeApplicationsById = new ConcurrentHashMap<String, RegistryApplication>();
    private ApplicationRegistryManager applicationRegistryManager;

    public static RegistryApplicationProvider getInstance() {
        RegistryApplicationProvider instance = instanceRef.get();
        if (instance != null) {
            return instance;
        }
        instanceRef.compareAndSet(null, new RegistryApplicationProvider());
        return instanceRef.get();
    }

    private RegistryApplicationProvider() {
        super(ID);
    }

    public Application createApplication(String applicationId, IRuntimeContext context) throws CoreException {
        RegistryApplication application = new RegistryApplication(applicationId, context);
        this.activeApplicationsById.put(applicationId, application);
        return application;
    }

    public synchronized void initApplication(RegistryApplication registryApplication) {
        if (this.applicationRegistryManager != null) {
            this.applicationRegistryManager.initApplication(registryApplication);
        }
    }

    public synchronized void removeApplication(String id) {
        RegistryApplication registryApplication = this.activeApplicationsById.remove(id);
        if (this.applicationRegistryManager != null && registryApplication != null) {
            this.applicationRegistryManager.closeApplication(registryApplication);
        }
    }

    public void setManager(ApplicationRegistryManager applicationRegistryManager) {
        this.applicationRegistryManager = applicationRegistryManager;
    }
}

