/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.http.tests.internal;

import java.net.MalformedURLException;
import java.util.concurrent.ConcurrentHashMap;
import junit.framework.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.gyrex.context.IRuntimeContext;
import org.eclipse.gyrex.http.application.Application;
import org.eclipse.gyrex.http.application.manager.MountConflictException;
import org.eclipse.gyrex.http.application.provider.ApplicationProvider;
import org.eclipse.gyrex.http.internal.application.gateway.HttpGatewayBinding;
import org.eclipse.gyrex.http.internal.application.gateway.IHttpGateway;
import org.eclipse.gyrex.http.internal.application.gateway.IUrlRegistry;
import org.eclipse.gyrex.http.internal.application.manager.ApplicationManager;
import org.eclipse.gyrex.http.tests.internal.Activator;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class ApplicationManagerTest {
    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testMount() {
        BundleContext context = Activator.getBundleContext();
        ApplicationManager applicationManager = new ApplicationManager();
        ServiceRegistration serviceRegistration = null;
        try {
            TestAppProvider appProvider = new TestAppProvider();
            serviceRegistration = context.registerService(ApplicationProvider.class.getName(), (Object)appProvider, null);
            String applicationId = "testMountApp" + String.valueOf(System.currentTimeMillis());
            try {
                applicationManager.register(applicationId, appProvider.getId(), null, null);
            }
            catch (Exception e) {
                Assert.fail((String)("error while registering dummy application: " + e));
            }
            String urlWithServerAndPath = "http://someserver/some/path";
            String urlWithServerAndPathAndTrailingSlash = "http://someserver/some/path/";
            String urlJustServer = "http://just.a.server.name";
            String urlJustServerWithTrailingSlash = "http://just.a.server.name/";
            String urlWithoutServerButWithPath1 = "http:///some/path";
            String urlWithoutServerButWithPath2 = "http:/some/path";
            String urlWithoutServerButWithPathAndTrailingSlash1 = "http:///some/path/";
            String urlWithoutServerButWithPathAndTrailingSlash2 = "http:/some/path/";
            String urlWithoutServerWithoutPath1 = "http:///";
            String urlWithoutServerWithoutPath2 = "http:/";
            this.testMountFollowedByUnmount(applicationManager, applicationId, "http://someserver/some/path");
            this.testMountFollowedByUnmount(applicationManager, applicationId, "http://someserver/some/path/");
            this.testMountFollowedByUnmount(applicationManager, applicationId, "http://just.a.server.name");
            this.testMountFollowedByUnmount(applicationManager, applicationId, "http://just.a.server.name/");
            this.testMountFollowedByUnmount(applicationManager, applicationId, "http:///some/path");
            this.testMountFollowedByUnmount(applicationManager, applicationId, "http:/some/path");
            this.testMountFollowedByUnmount(applicationManager, applicationId, "http:///some/path/");
            this.testMountFollowedByUnmount(applicationManager, applicationId, "http:/some/path/");
            this.testMountFollowedByUnmount(applicationManager, applicationId, "http:///");
            this.testMountFollowedByUnmount(applicationManager, applicationId, "http:/");
            this.testMountAndUnmountConflicts(applicationManager, applicationId, "http://someserver/some/path", "http://someserver/some/path/");
            this.testMountAndUnmountConflicts(applicationManager, applicationId, "http://just.a.server.name", "http://just.a.server.name/");
            this.testMountAndUnmountConflicts(applicationManager, applicationId, "http:///some/path", "http:/some/path");
            this.testMountAndUnmountConflicts(applicationManager, applicationId, "http:///some/path", "http:///some/path/");
            this.testMountAndUnmountConflicts(applicationManager, applicationId, "http:///some/path", "http:/some/path/");
            this.testMountAndUnmountConflicts(applicationManager, applicationId, "http:///some/path/", "http:/some/path/");
            this.testMountAndUnmountConflicts(applicationManager, applicationId, "http:///", "http:/");
        }
        finally {
            if (serviceRegistration != null) {
                serviceRegistration.unregister();
            }
        }
    }

    private void testMountAndUnmountConflicts(ApplicationManager applicationManager, String applicationId, String url1, String url2) {
        this.testMountUrl(applicationManager, applicationId, url1, false);
        this.testMountUrl(applicationManager, applicationId, url2, true);
        this.testUnmountUrl(applicationManager, url1, false);
        this.testUnmountUrl(applicationManager, url2, true);
        this.testMountUrl(applicationManager, applicationId, url1, false);
        this.testMountUrl(applicationManager, applicationId, url2, true);
        this.testUnmountUrl(applicationManager, url2, false);
        this.testUnmountUrl(applicationManager, url1, true);
        this.testMountUrl(applicationManager, applicationId, url2, false);
        this.testMountUrl(applicationManager, applicationId, url1, true);
        this.testUnmountUrl(applicationManager, url1, false);
        this.testUnmountUrl(applicationManager, url2, true);
        this.testMountUrl(applicationManager, applicationId, url2, false);
        this.testMountUrl(applicationManager, applicationId, url1, true);
        this.testUnmountUrl(applicationManager, url2, false);
        this.testUnmountUrl(applicationManager, url1, true);
    }

    private void testMountFollowedByUnmount(ApplicationManager applicationManager, String applicationId, String url) {
        this.testMountUrl(applicationManager, applicationId, url, false);
        this.testUnmountUrl(applicationManager, url, false);
    }

    private void testMountUrl(ApplicationManager applicationManager, String applicationId, String url, boolean expectMountConflict) {
        try {
            applicationManager.mount(url, applicationId);
            if (expectMountConflict) {
                Assert.fail((String)("mount conflict expected but not occured for url '" + url + "'"));
            }
        }
        catch (MountConflictException e) {
            if (!expectMountConflict) {
                Assert.fail((String)("mount conflict occured but not expected for url '" + url + "': " + e.getMessage()));
            }
        }
        catch (MalformedURLException e) {
            Assert.fail((String)("invalid test url '" + url + "': " + e.getMessage()));
        }
        catch (IllegalArgumentException e) {
            Assert.fail((String)("invalid test url '" + url + "': " + e.getMessage()));
        }
    }

    private void testUnmountUrl(ApplicationManager applicationManager, String url, boolean expectedUnmountToFail) {
        block5: {
            try {
                applicationManager.unmount(url);
                if (expectedUnmountToFail) {
                    Assert.fail((String)("unmount did not fail but was expected for url '" + url + "'"));
                }
            }
            catch (MalformedURLException e) {
                Assert.fail((String)("invalid test url '" + url + "': " + e.getMessage()));
            }
            catch (IllegalArgumentException e) {
                Assert.fail((String)("invalid test url '" + url + "': " + e.getMessage()));
            }
            catch (IllegalStateException e) {
                if (expectedUnmountToFail) break block5;
                Assert.fail((String)("unmount failed but not expected for url '" + url + "': " + e.getMessage()));
            }
        }
    }

    static class TestApp
    extends Application {
        TestApp(String id, IRuntimeContext context) {
            super(id, context);
        }
    }

    static class TestAppProvider
    extends ApplicationProvider {
        TestAppProvider() {
            super(TestAppProvider.class.getName());
        }

        public Application createApplication(String applicationId, IRuntimeContext context) throws CoreException {
            return new TestApp(applicationId, context);
        }
    }

    static class TestGateway
    implements IHttpGateway {
        TestGateway() {
        }

        public String getName() {
            return "Test";
        }

        public IUrlRegistry getUrlRegistry(HttpGatewayBinding applicationManager) {
            return new TestUrlRegistry();
        }
    }

    static class TestUrlRegistry
    implements IUrlRegistry {
        ConcurrentHashMap<String, String> map = new ConcurrentHashMap();

        TestUrlRegistry() {
        }

        public void applicationUnregistered(String applicationId) {
        }

        public String registerIfAbsent(String url, String applicationId) {
            return this.map.putIfAbsent(url, applicationId);
        }

        public String unregister(String url) {
            return this.map.remove(url);
        }
    }
}

