/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.jobs.internal.commands;

import org.eclipse.gyrex.common.identifiers.IdHelper;
import org.eclipse.gyrex.jobs.internal.commands.BaseScheduleStoreCmd;
import org.eclipse.gyrex.jobs.internal.schedules.ScheduleImpl;
import org.eclipse.gyrex.jobs.internal.schedules.ScheduleStore;
import org.kohsuke.args4j.Argument;

public class RemoveScheduleEntryCmd
extends BaseScheduleStoreCmd {
    @Argument(index=1, usage="the entry id", required=true, metaVar="ID")
    String entryId;

    public RemoveScheduleEntryCmd() {
        super("<entryId> - Removes a schedule entry");
    }

    @Override
    protected void doExecute(String storageId, String scheduleId) throws Exception {
        ScheduleImpl schedule = ScheduleStore.load(storageId, scheduleId, true);
        if (schedule.isEnabled()) {
            this.printf("Schedule %s is enabled, please disable first!", new Object[]{scheduleId});
            return;
        }
        if (!IdHelper.isValidId((String)this.entryId)) {
            throw new IllegalArgumentException("invalid entry id");
        }
        schedule.removeEntry(this.entryId);
        ScheduleStore.flush(storageId, schedule);
        this.printf("Removed entry %s in schedule %s !", new Object[]{this.entryId, scheduleId});
    }
}

