/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.jobs.internal.schedules;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.gyrex.common.identifiers.IdHelper;
import org.eclipse.gyrex.jobs.internal.scheduler.Schedule;
import org.eclipse.gyrex.jobs.internal.schedules.ScheduleImpl;
import org.eclipse.gyrex.jobs.schedules.IScheduleEntry;
import org.eclipse.gyrex.jobs.schedules.manager.IScheduleEntryWorkingCopy;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;
import org.quartz.CronExpression;

public class ScheduleEntryImpl
implements IScheduleEntry,
IScheduleEntryWorkingCopy {
    private static final char SEPARATOR_CHAR = ',';
    private static final String PARAMETER = "parameter";
    private static final String JOB_TYPE_ID = "jobTypeId";
    private static final String CRON_EXPRESSION = "cronExpression";
    private static final String ENABLED = "enabled";
    private static final String PRECEDING_ENTRIES = "precedingEntries";
    private static final String QUEUE_ID = "queueId";
    private final String id;
    private ScheduleImpl schedule;
    private boolean enabled;
    private String cronExpression;
    private String jobTypeId;
    private Map<String, String> jobParamater;
    private String queueId;
    private Collection<String> precedingEntries;

    private static void setIfNotNullOrRemoveIfNull(Preferences node, String key, String value) {
        if (value != null) {
            node.put(key, value);
        } else {
            node.remove(key);
        }
    }

    public static void validateCronExpression(String expression) throws IllegalArgumentException {
        String[] tokens = StringUtils.split((String)expression);
        if (tokens.length < 5 || tokens.length > 6) {
            throw new IllegalArgumentException("A cron expression must consist of five to six tokens (<Minute> <Hour> <Day_of_the_Month> <Month_of_the_Year> <Day_of_the_Week> <Year>).");
        }
        if (CronExpression.isValidExpression((String)Schedule.asQuartzCronExpression(expression))) {
            return;
        }
        try {
            new CronExpression(Schedule.asQuartzCronExpression(expression));
            throw new IllegalArgumentException("invalid cron expression: " + expression);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public ScheduleEntryImpl(String id, ScheduleImpl schedule) {
        this.schedule = schedule;
        if (!IdHelper.isValidId((String)id)) {
            throw new IllegalArgumentException("invalid entry id");
        }
        this.id = id;
        this.enabled = true;
    }

    @Override
    public String getCronExpression() {
        return this.cronExpression;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getJobId() {
        return this.schedule.getId().concat("__entry__").concat(this.id);
    }

    @Override
    public Map<String, String> getJobParameter() {
        if (this.jobParamater != null) {
            return Collections.unmodifiableMap(this.jobParamater);
        }
        return Collections.emptyMap();
    }

    @Override
    public String getJobTypeId() {
        return this.jobTypeId;
    }

    @Override
    public Collection<String> getPrecedingEntries() {
        Collection<String> ids = this.precedingEntries;
        if (ids == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(ids);
    }

    @Override
    public String getQueueId() {
        return this.queueId;
    }

    @Override
    public ScheduleImpl getSchedule() {
        return this.schedule;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    void load(Preferences node) throws BackingStoreException {
        try {
            String expression;
            this.setJobTypeId(node.get(JOB_TYPE_ID, null));
            this.setEnabled(node.getBoolean(ENABLED, true));
            if (node.nodeExists(PARAMETER)) {
                Preferences paramNode = node.node(PARAMETER);
                String[] keys = paramNode.keys();
                this.jobParamater = new HashMap<String, String>(keys.length);
                String[] stringArray = keys;
                int n = keys.length;
                int n2 = 0;
                while (n2 < n) {
                    String key = stringArray[n2];
                    this.jobParamater.put(key, paramNode.get(key, null));
                    ++n2;
                }
            }
            if ((expression = node.get(CRON_EXPRESSION, null)) != null) {
                this.setCronExpression(expression);
            }
            this.setQueueId(node.get(QUEUE_ID, null));
            this.setPrecedingEntries(StringUtils.split((String)node.get(PRECEDING_ENTRIES, null), (char)','));
        }
        catch (IllegalArgumentException e) {
            throw new BackingStoreException(String.format("Unable to load entry '%s'. %s", this.id, e.getMessage()), (Throwable)e);
        }
    }

    void saveWithoutFlush(Preferences node) throws BackingStoreException {
        this.setJobTypeId(this.jobTypeId);
        node.put(JOB_TYPE_ID, this.jobTypeId);
        node.putBoolean(ENABLED, this.enabled);
        if (this.jobParamater != null && !this.jobParamater.isEmpty()) {
            Preferences paramNode = node.node(PARAMETER);
            String[] stringArray = paramNode.keys();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                if (StringUtils.isBlank((String)this.jobParamater.get(key))) {
                    paramNode.remove(key);
                }
                ++n2;
            }
            for (String key : this.jobParamater.keySet()) {
                String value = this.jobParamater.get(key);
                if (!StringUtils.isNotBlank((String)value)) continue;
                paramNode.put(key, value);
            }
        } else if (node.nodeExists(PARAMETER)) {
            node.node(PARAMETER).removeNode();
        }
        if (this.cronExpression != null) {
            node.put(CRON_EXPRESSION, this.cronExpression);
        } else {
            node.remove(CRON_EXPRESSION);
        }
        ScheduleEntryImpl.setIfNotNullOrRemoveIfNull(node, CRON_EXPRESSION, this.cronExpression);
        ScheduleEntryImpl.setIfNotNullOrRemoveIfNull(node, QUEUE_ID, this.queueId);
        ScheduleEntryImpl.setIfNotNullOrRemoveIfNull(node, PRECEDING_ENTRIES, StringUtils.join(this.precedingEntries, (char)','));
    }

    @Override
    public void setCronExpression(String cronExpression) {
        if (StringUtils.isNotBlank((String)cronExpression)) {
            ScheduleEntryImpl.validateCronExpression(cronExpression);
        }
        this.cronExpression = cronExpression;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public void setJobParameter(Map<String, String> jobParameter) {
        this.jobParamater = jobParameter != null ? new HashMap<String, String>(jobParameter) : null;
    }

    @Override
    public void setJobTypeId(String jobTypeId) {
        if (!IdHelper.isValidId((String)jobTypeId)) {
            throw new IllegalArgumentException("invalid type id");
        }
        this.jobTypeId = jobTypeId;
    }

    @Override
    public void setPrecedingEntries(String ... scheduleEntryIds) throws IllegalArgumentException {
        if (scheduleEntryIds == null || scheduleEntryIds.length == 0) {
            this.precedingEntries = null;
        } else {
            ArrayList<String> list = new ArrayList<String>(scheduleEntryIds.length);
            int i = 0;
            while (i < scheduleEntryIds.length) {
                if (!IdHelper.isValidId((String)scheduleEntryIds[i])) {
                    throw new IllegalArgumentException("invalid schedule entry id at index " + i + ": " + scheduleEntryIds[i]);
                }
                list.add(scheduleEntryIds[i]);
                ++i;
            }
            LinkedList<String> sequence = new LinkedList<String>();
            sequence.add(this.id);
            ScheduleImpl.checkExecutionSequenceForLoops(this, sequence, list);
            this.precedingEntries = list;
        }
    }

    @Override
    public void setQueueId(String queueId) throws IllegalArgumentException {
        if (queueId != null && !IdHelper.isValidId((String)queueId)) {
            throw new IllegalArgumentException("invalide queue id: " + queueId);
        }
        this.queueId = queueId;
    }

    public void setSchedule(ScheduleImpl schedule) {
        this.schedule = schedule;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ScheduleEntryImpl [id=").append(this.id).append(", cronExpression=").append(this.cronExpression).append(", jobProviderId=").append(this.jobTypeId).append(", jobParamater=").append(this.jobParamater).append("]");
        return builder.toString();
    }
}

