/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.monitoring.internal;

import java.util.Hashtable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.gyrex.monitoring.diagnostics.StatusTracker;
import org.eclipse.gyrex.monitoring.internal.DiagnosticsStatusMetrics;
import org.eclipse.gyrex.monitoring.metrics.MetricSet;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class StatusTrackerWithMetric
extends StatusTracker {
    private final DiagnosticsStatusMetrics diagnosticsStatusMetrics = new DiagnosticsStatusMetrics();
    private ServiceRegistration<MetricSet> metricSetRegistration;

    public StatusTrackerWithMetric(BundleContext context) {
        super(context);
    }

    public void close() {
        super.close();
        if (this.metricSetRegistration != null) {
            try {
                this.metricSetRegistration.unregister();
            }
            catch (Exception exception) {}
            this.metricSetRegistration = null;
        }
    }

    public void open(boolean trackAllServices) {
        super.open(trackAllServices);
        Hashtable<String, String> properties = new Hashtable<String, String>(3);
        properties.put("service.vendor", "Eclipse Gyrex");
        properties.put("service.description", this.diagnosticsStatusMetrics.getDescription());
        properties.put("service.pid", this.diagnosticsStatusMetrics.getId());
        this.metricSetRegistration = this.context.registerService(MetricSet.class, (Object)this.diagnosticsStatusMetrics, properties);
    }

    @Override
    protected void setSystemStatus(IStatus systemStatus) {
        this.diagnosticsStatusMetrics.setStatus(systemStatus);
        super.setSystemStatus(systemStatus);
    }
}

