/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.p2.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.gyrex.common.identifiers.IdHelper;
import org.eclipse.gyrex.p2.internal.packages.IPackageManager;
import org.eclipse.gyrex.p2.internal.packages.InstallState;
import org.eclipse.gyrex.p2.internal.packages.InstallableUnitReference;
import org.eclipse.gyrex.p2.internal.packages.PackageDefinition;
import org.eclipse.gyrex.preferences.CloudScope;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackageManager
implements IPackageManager {
    private static final String PREF_NODE_PACKAGES = "packages";
    private static final String PREF_NODE_COMPONENTS = "components";
    private static final String PREF_KEY_NODE_FILTER = "nodeFilter";
    private static final String PREF_KEY_INSTALL_STATE = "installState";
    private static final String PREF_KEY_INSTALL_STATE_TIMESTAMP = "installStateTS";
    private static final String PREF_KEY_TYPE = "type";
    private static final String PREF_KEY_VERSION = "version";
    private static final String COMPONENT_TYPE_IU = "IU";
    private static final Logger LOG = LoggerFactory.getLogger(PackageManager.class);

    private static String toRelativeTime(long duration) {
        if (duration < TimeUnit.MINUTES.toMillis(2L)) {
            return "a minute ago";
        }
        if (duration < TimeUnit.HOURS.toMillis(2L)) {
            return String.format("%d minutes ago", TimeUnit.MILLISECONDS.toMinutes(duration));
        }
        return String.format("%d hours ago", TimeUnit.MILLISECONDS.toMinutes(duration));
    }

    @Override
    public PackageDefinition getPackage(String id) {
        block6: {
            IEclipsePreferences rootNode;
            block5: {
                try {
                    if (!IdHelper.isValidId((String)id)) {
                        throw new IllegalArgumentException("invalid id");
                    }
                    rootNode = CloudScope.INSTANCE.getNode("org.eclipse.gyrex.p2");
                    if (rootNode.nodeExists(PREF_NODE_PACKAGES)) break block5;
                    return null;
                }
                catch (BackingStoreException e) {
                    throw new IllegalStateException("Error reading package definition from backend store. " + ExceptionUtils.getRootCauseMessage((Throwable)e), e);
                }
            }
            Preferences node = rootNode.node(PREF_NODE_PACKAGES);
            if (node.nodeExists(id)) break block6;
            return null;
        }
        return this.readPackage(id);
    }

    private Preferences getPackageNode(String packageId) {
        return CloudScope.INSTANCE.getNode("org.eclipse.gyrex.p2").node(PREF_NODE_PACKAGES).node(packageId);
    }

    @Override
    public Collection<PackageDefinition> getPackages() {
        try {
            IEclipsePreferences rootNode = CloudScope.INSTANCE.getNode("org.eclipse.gyrex.p2");
            if (!rootNode.nodeExists(PREF_NODE_PACKAGES)) {
                return Collections.emptyList();
            }
            Preferences channelsNode = rootNode.node(PREF_NODE_PACKAGES);
            String[] childrenNames = channelsNode.childrenNames();
            ArrayList<PackageDefinition> channels = new ArrayList<PackageDefinition>();
            String[] stringArray = childrenNames;
            int n = childrenNames.length;
            int n2 = 0;
            while (n2 < n) {
                String channelId = stringArray[n2];
                PackageDefinition descriptor = this.readPackage(channelId);
                if (descriptor != null) {
                    channels.add(descriptor);
                }
                ++n2;
            }
            return channels;
        }
        catch (BackingStoreException e) {
            throw new IllegalStateException("Error reading package definitions from backend store. " + ExceptionUtils.getRootCauseMessage((Throwable)e), e);
        }
    }

    @Override
    public boolean isMarkedForInstall(PackageDefinition packageDefinition) {
        try {
            if (!IdHelper.isValidId((String)packageDefinition.getId())) {
                throw new IllegalArgumentException("invalid id");
            }
            IEclipsePreferences rootNode = CloudScope.INSTANCE.getNode("org.eclipse.gyrex.p2");
            if (!rootNode.nodeExists(PREF_NODE_PACKAGES)) {
                throw new IllegalArgumentException("package does not exist");
            }
            Preferences node = rootNode.node(PREF_NODE_PACKAGES);
            if (!node.nodeExists(packageDefinition.getId())) {
                throw new IllegalArgumentException("package does not exist");
            }
            Preferences pkgNode = node.node(packageDefinition.getId());
            String installState = pkgNode.get(PREF_KEY_INSTALL_STATE, null);
            if (installState == null && pkgNode.get("install", null) != null) {
                return pkgNode.getBoolean("install", false);
            }
            return InstallState.fromString(installState) == InstallState.ROLLOUT;
        }
        catch (BackingStoreException e) {
            throw new IllegalStateException("Error reading package definition from backend store. " + ExceptionUtils.getRootCauseMessage((Throwable)e), e);
        }
    }

    @Override
    public boolean isMarkedForUninstall(PackageDefinition packageDefinition) {
        try {
            if (!IdHelper.isValidId((String)packageDefinition.getId())) {
                throw new IllegalArgumentException("invalid id");
            }
            IEclipsePreferences rootNode = CloudScope.INSTANCE.getNode("org.eclipse.gyrex.p2");
            if (!rootNode.nodeExists(PREF_NODE_PACKAGES)) {
                throw new IllegalArgumentException("package does not exist");
            }
            Preferences node = rootNode.node(PREF_NODE_PACKAGES);
            if (!node.nodeExists(packageDefinition.getId())) {
                throw new IllegalArgumentException("package does not exist");
            }
            Preferences pkgNode = node.node(packageDefinition.getId());
            String installState = pkgNode.get(PREF_KEY_INSTALL_STATE, null);
            if (installState == null && pkgNode.get("uninstall", null) != null) {
                return pkgNode.getBoolean("uninstall", false);
            }
            return InstallState.fromString(installState) == InstallState.REVOKE;
        }
        catch (BackingStoreException e) {
            throw new IllegalStateException("Error reading package definition from backend store. " + ExceptionUtils.getRootCauseMessage((Throwable)e), e);
        }
    }

    private boolean isPackageNodeAvailable(String packageId) throws BackingStoreException {
        IEclipsePreferences rootNode = CloudScope.INSTANCE.getNode("org.eclipse.gyrex.p2");
        if (!rootNode.nodeExists(PREF_NODE_PACKAGES)) {
            return false;
        }
        return rootNode.node(PREF_NODE_PACKAGES).nodeExists(packageId);
    }

    @Override
    public void markedForInstall(PackageDefinition packageDefinition) {
        try {
            if (!IdHelper.isValidId((String)packageDefinition.getId())) {
                throw new IllegalArgumentException("invalid id");
            }
            if (!this.isPackageNodeAvailable(packageDefinition.getId())) {
                throw new IllegalArgumentException("package does not exist");
            }
            Preferences pkgNode = this.getPackageNode(packageDefinition.getId());
            pkgNode.put(PREF_KEY_INSTALL_STATE, InstallState.toString(InstallState.ROLLOUT));
            pkgNode.putLong(PREF_KEY_INSTALL_STATE_TIMESTAMP, System.currentTimeMillis());
            pkgNode.remove("install");
            pkgNode.remove("uninstall");
            pkgNode.flush();
        }
        catch (BackingStoreException e) {
            throw new IllegalStateException("Error reading package definition from backend store. " + ExceptionUtils.getRootCauseMessage((Throwable)e), e);
        }
    }

    @Override
    public void markedForUninstall(PackageDefinition packageDefinition) {
        try {
            if (!IdHelper.isValidId((String)packageDefinition.getId())) {
                throw new IllegalArgumentException("invalid id");
            }
            if (!this.isPackageNodeAvailable(packageDefinition.getId())) {
                throw new IllegalArgumentException("package does not exist");
            }
            Preferences pkgNode = this.getPackageNode(packageDefinition.getId());
            pkgNode.put(PREF_KEY_INSTALL_STATE, InstallState.toString(InstallState.REVOKE));
            pkgNode.putLong(PREF_KEY_INSTALL_STATE_TIMESTAMP, System.currentTimeMillis());
            pkgNode.remove("install");
            pkgNode.remove("uninstall");
            pkgNode.flush();
        }
        catch (BackingStoreException e) {
            throw new IllegalStateException("Error reading package definition from backend store. " + ExceptionUtils.getRootCauseMessage((Throwable)e), e);
        }
    }

    private PackageDefinition readPackage(String id) {
        try {
            PackageDefinition pkgDefinition = new PackageDefinition();
            pkgDefinition.setId(id);
            Preferences node = this.getPackageNode(id);
            pkgDefinition.setNodeFilter(node.get(PREF_KEY_NODE_FILTER, null));
            pkgDefinition.setInstallState(InstallState.fromString(node.get(PREF_KEY_INSTALL_STATE, id)));
            if (node.nodeExists(PREF_NODE_COMPONENTS)) {
                Preferences componentsNode = node.node(PREF_NODE_COMPONENTS);
                String[] stringArray = componentsNode.childrenNames();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String componentId = stringArray[n2];
                    Preferences componentNode = componentsNode.node(componentId);
                    String type = componentNode.get(PREF_KEY_TYPE, null);
                    if (StringUtils.equals((String)COMPONENT_TYPE_IU, (String)type)) {
                        InstallableUnitReference iu = new InstallableUnitReference();
                        iu.setId(componentId);
                        String version = componentNode.get(PREF_KEY_VERSION, null);
                        if (version != null) {
                            iu.setVersion(Version.create((String)version));
                        }
                        pkgDefinition.addComponentToInstall(iu);
                    }
                    ++n2;
                }
            }
            return pkgDefinition;
        }
        catch (Exception e) {
            LOG.warn("Unable to read package definition {}. {}", (Object)id, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            return null;
        }
    }

    @Override
    public void removePackage(String id) {
        try {
            if (!IdHelper.isValidId((String)id)) {
                throw new IllegalArgumentException("invalid id");
            }
            IEclipsePreferences rootNode = CloudScope.INSTANCE.getNode("org.eclipse.gyrex.p2");
            if (!rootNode.nodeExists(PREF_NODE_PACKAGES)) {
                return;
            }
            Preferences node = rootNode.node(PREF_NODE_PACKAGES);
            if (!node.nodeExists(id)) {
                return;
            }
            IStatus modifiable = this.verifyPackageIsModifiable(id);
            if (!modifiable.isOK()) {
                throw new IllegalStateException(modifiable.getMessage());
            }
            node.node(id).removeNode();
            node.flush();
        }
        catch (BackingStoreException e) {
            throw new IllegalStateException("Error removing package definition from backend store. " + ExceptionUtils.getRootCauseMessage((Throwable)e), e);
        }
    }

    @Override
    public void savePackage(PackageDefinition packageDefinition) {
        try {
            IStatus modifiable;
            String id = packageDefinition.getId();
            if (!IdHelper.isValidId((String)id)) {
                throw new IllegalArgumentException("invalid id");
            }
            if (this.isPackageNodeAvailable(id) && !(modifiable = this.verifyPackageIsModifiable(id)).isOK()) {
                throw new IllegalStateException(modifiable.getMessage());
            }
            Collection<InstallableUnitReference> componentsToInstall = packageDefinition.getComponentsToInstall();
            Preferences node = this.getPackageNode(id);
            String nodeFilter = packageDefinition.getNodeFilter();
            if (StringUtils.isNotBlank((String)nodeFilter)) {
                node.put(PREF_KEY_NODE_FILTER, nodeFilter);
            } else {
                node.remove(PREF_KEY_NODE_FILTER);
            }
            Preferences componentsToInstallNode = node.node(PREF_NODE_COMPONENTS);
            HashSet<String> componentsWritten = new HashSet<String>();
            for (InstallableUnitReference component : componentsToInstall) {
                componentsWritten.add(component.getId());
                Preferences componentNode = componentsToInstallNode.node(component.getId());
                componentNode.put(PREF_KEY_TYPE, COMPONENT_TYPE_IU);
                InstallableUnitReference iu = component;
                Version version = iu.getVersion();
                if (version != null) {
                    StringBuffer versionString = new StringBuffer();
                    version.toString(versionString);
                    componentNode.put(PREF_KEY_VERSION, versionString.toString());
                    continue;
                }
                componentNode.remove(PREF_KEY_VERSION);
            }
            String[] stringArray = componentsToInstallNode.childrenNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String child = stringArray[n2];
                if (!componentsWritten.contains(child)) {
                    componentsToInstallNode.node(child).removeNode();
                }
                ++n2;
            }
            node.flush();
        }
        catch (BackingStoreException e) {
            throw new IllegalStateException("Error saving package definition to backend store. " + ExceptionUtils.getRootCauseMessage((Throwable)e), e);
        }
    }

    @Override
    public IStatus verifyPackageIsModifiable(String id) throws IllegalStateException, IllegalArgumentException {
        if (!IdHelper.isValidId((String)id)) {
            return new Status(4, "org.eclipse.gyrex.p2", "invalid package id");
        }
        try {
            long revokeDuration;
            if (!this.isPackageNodeAvailable(id)) {
                return new Status(4, "org.eclipse.gyrex.p2", "package does not exist");
            }
            Preferences pkgNode = this.getPackageNode(id);
            InstallState installState = InstallState.fromString(pkgNode.get(PREF_KEY_INSTALL_STATE, null));
            if (installState == InstallState.ROLLOUT) {
                return new Status(4, "org.eclipse.gyrex.p2", String.format("Package '%s' is marked for rollout! Please revoke it first.", id));
            }
            if (installState == InstallState.REVOKE && (revokeDuration = System.currentTimeMillis() - pkgNode.getLong(PREF_KEY_INSTALL_STATE_TIMESTAMP, 0L)) < TimeUnit.HOURS.toMillis(48L)) {
                return new Status(4, "org.eclipse.gyrex.p2", String.format("Package '%s' was revoked %s! Please wait at least 48 hours before modifying a revoked package!", id, PackageManager.toRelativeTime(revokeDuration)));
            }
            return Status.OK_STATUS;
        }
        catch (BackingStoreException e) {
            return new Status(4, "org.eclipse.gyrex.p2", String.format("Error accessing backend store. Unable to verify package modifiability. %s", e.getMessage()), (Throwable)e);
        }
    }
}

