/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.p2.internal.commands;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.gyrex.common.identifiers.IdHelper;
import org.eclipse.gyrex.p2.internal.commands.BaseSwCmd;
import org.eclipse.gyrex.p2.internal.packages.InstallableUnitReference;
import org.eclipse.gyrex.p2.internal.packages.PackageDefinition;
import org.kohsuke.args4j.Argument;

public final class RemoveArtifactFromPkgCmd
extends BaseSwCmd {
    @Argument(index=0, usage="the package id", required=true, metaVar="ID")
    String id;
    @Argument(index=1, usage="the installable unit id", required=true, metaVar="IU")
    String iuId;
    @Argument(index=2, usage="an optional installable unit version", required=false, metaVar="VERSION")
    String iuVersion;

    public RemoveArtifactFromPkgCmd() {
        super("<packageId> <installableUnitId> [<installUnitVersion>] - removes an installable unit from a package");
    }

    protected void doExecute() throws Exception {
        if (!IdHelper.isValidId((String)this.id)) {
            this.printf("ERROR: invalid package id", new Object[0]);
            return;
        }
        PackageDefinition packageDefinition = this.getPackageManager().getPackage(this.id);
        if (packageDefinition == null) {
            this.printf("ERROR: package not found", new Object[0]);
            return;
        }
        IStatus modifiable = this.getPackageManager().verifyPackageIsModifiable(this.id);
        if (!modifiable.isOK()) {
            this.printf("ERROR: %s", new Object[]{modifiable.getMessage()});
            return;
        }
        InstallableUnitReference iu = new InstallableUnitReference();
        if (!IdHelper.isValidId((String)this.iuId)) {
            this.printf("ERROR: invalid installable unit id", new Object[0]);
            return;
        }
        iu.setId(this.iuId);
        if (this.iuVersion != null) {
            try {
                iu.setVersion(Version.create((String)this.iuVersion));
            }
            catch (IllegalArgumentException e) {
                this.printf("ERROR: invalid installable unit version: %s", new Object[]{e.getMessage()});
                return;
            }
        }
        if (!packageDefinition.removeComponentToInstall(iu)) {
            this.printf("ERROR: installable unit not found in package", new Object[0]);
            return;
        }
        this.getPackageManager().savePackage(packageDefinition);
        this.printf("package updated", new Object[0]);
    }
}

